/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.BlockUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ig.threading.ThreadingUtils;
import java.util.function.Predicate;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WhileLoopSpinsOnFieldInspection
extends BaseInspection {
    private static final CallMatcher THREAD_ON_SPIN_WAIT = CallMatcher.staticCall("java.lang.Thread", "onSpinWait");
    public boolean ignoreNonEmtpyLoops = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("while.loop.spins.on.field.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/WhileLoopSpinsOnFieldInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("while.loop.spins.on.field.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/WhileLoopSpinsOnFieldInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new SpinLoopFix((PsiField)infos[0], (Boolean)infos[1]);
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("while.loop.spins.on.field.ignore.non.empty.loops.option", new Object[0]), this, "ignoreNonEmtpyLoops");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new WhileLoopSpinsOnFieldVisitor();
    }

    private static class SpinLoopFix
    extends InspectionGadgetsFix {
        private final SmartPsiElementPointer<PsiField> myFieldPointer;
        private final String myFieldName;
        private final boolean myAddOnSpinWait;
        private final boolean myAddVolatile;

        public SpinLoopFix(PsiField field, boolean addOnSpinWait) {
            this.myFieldPointer = SmartPointerManager.getInstance(field.getProject()).createSmartPsiElementPointer(field);
            this.myFieldName = field.getName();
            this.myAddOnSpinWait = addOnSpinWait;
            this.myAddVolatile = !field.hasModifierProperty("volatile");
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            if (this.myAddOnSpinWait && this.myAddVolatile) {
                String string = InspectionGadgetsBundle.message("while.loop.spins.on.field.fix.volatile.spinwait", this.myFieldName);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/WhileLoopSpinsOnFieldInspection$SpinLoopFix", "getName"));
                }
                return string;
            }
            if (this.myAddOnSpinWait) {
                String string = InspectionGadgetsBundle.message("while.loop.spins.on.field.fix.spinwait", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/WhileLoopSpinsOnFieldInspection$SpinLoopFix", "getName"));
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("while.loop.spins.on.field.fix.volatile", this.myFieldName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/WhileLoopSpinsOnFieldInspection$SpinLoopFix", "getName"));
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("while.loop.spins.on.field.fix.family.name", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/WhileLoopSpinsOnFieldInspection$SpinLoopFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            if (this.myAddVolatile) {
                SpinLoopFix.addVolatile(this.myFieldPointer.getElement());
            }
            if (this.myAddOnSpinWait) {
                SpinLoopFix.addOnSpinWait(descriptor.getStartElement());
            }
        }

        private static void addOnSpinWait(PsiElement element) {
            PsiLoopStatement loop = PsiTreeUtil.getParentOfType(element, PsiLoopStatement.class);
            if (loop == null) {
                return;
            }
            PsiStatement body = loop.getBody();
            if (body == null) {
                return;
            }
            PsiStatement spinCall = JavaPsiFacade.getElementFactory(element.getProject()).createStatementFromText("java.lang.Thread.onSpinWait();", element);
            if (body instanceof PsiBlockStatement) {
                PsiCodeBlock block = ((PsiBlockStatement)body).getCodeBlock();
                block.addAfter(spinCall, null);
            } else {
                BlockUtils.addBefore(body, spinCall);
            }
            CodeStyleManager.getInstance(element.getProject()).reformat(loop);
        }

        private static void addVolatile(PsiField field) {
            if (field == null) {
                return;
            }
            PsiModifierList list = field.getModifierList();
            if (list == null) {
                return;
            }
            list.setModifierProperty("volatile", true);
        }
    }

    private class WhileLoopSpinsOnFieldVisitor
    extends BaseInspectionVisitor {
        private WhileLoopSpinsOnFieldVisitor() {
        }

        @Override
        public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
            boolean shouldAddSpinWait;
            PsiExpressionStatement onlyExpr;
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/threading/WhileLoopSpinsOnFieldInspection$WhileLoopSpinsOnFieldVisitor", "visitWhileStatement"));
            }
            super.visitWhileStatement(statement);
            PsiStatement body = statement.getBody();
            boolean empty = ControlFlowUtils.statementIsEmpty(body);
            if (!(!WhileLoopSpinsOnFieldInspection.this.ignoreNonEmtpyLoops || empty || (onlyExpr = ObjectUtils.tryCast(ControlFlowUtils.stripBraces(body), PsiExpressionStatement.class)) != null && THREAD_ON_SPIN_WAIT.matches(onlyExpr.getExpression()))) {
                return;
            }
            PsiExpression condition = statement.getCondition();
            PsiField field = this.getFieldIfSimpleFieldComparison(condition);
            if (field == null) {
                return;
            }
            if (body != null && (VariableAccessUtils.variableIsAssigned(field, body) || this.containsCall(body, ThreadingUtils::isWaitCall))) {
                return;
            }
            boolean java9 = PsiUtil.isLanguageLevel9OrHigher(field);
            boolean bl = shouldAddSpinWait = java9 && empty && !this.containsCall(body, THREAD_ON_SPIN_WAIT);
            if (field.hasModifierProperty("volatile") && !shouldAddSpinWait) {
                return;
            }
            this.registerStatementError(statement, field, shouldAddSpinWait);
        }

        private boolean containsCall(@Nullable PsiElement element, final Predicate<PsiMethodCallExpression> predicate) {
            if (element == null) {
                return false;
            }
            final boolean[] result = new boolean[1];
            element.accept(new JavaRecursiveElementWalkingVisitor(){

                @Override
                public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                    super.visitMethodCallExpression(expression);
                    if (predicate.test(expression)) {
                        result[0] = true;
                        this.stopWalking();
                    }
                }
            });
            return result[0];
        }

        @Nullable
        private PsiField getFieldIfSimpleFieldComparison(PsiExpression condition) {
            PsiPrefixExpression prefixExpression;
            IElementType type;
            if ((condition = PsiUtil.deparenthesizeExpression(condition)) == null) {
                return null;
            }
            PsiField field = this.getFieldIfSimpleFieldAccess(condition);
            if (field != null) {
                return field;
            }
            if (condition instanceof PsiPrefixExpression && !(type = (prefixExpression = (PsiPrefixExpression)condition).getOperationTokenType()).equals(JavaTokenType.PLUSPLUS) && !type.equals(JavaTokenType.MINUSMINUS)) {
                PsiExpression operand = prefixExpression.getOperand();
                return this.getFieldIfSimpleFieldComparison(operand);
            }
            if (condition instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition;
                PsiExpression lOperand = binaryExpression.getLOperand();
                PsiExpression rOperand = binaryExpression.getROperand();
                if (ExpressionUtils.isLiteral(rOperand)) {
                    return this.getFieldIfSimpleFieldComparison(lOperand);
                }
                if (ExpressionUtils.isLiteral(lOperand)) {
                    return this.getFieldIfSimpleFieldComparison(rOperand);
                }
                return null;
            }
            return null;
        }

        @Nullable
        private PsiField getFieldIfSimpleFieldAccess(PsiExpression expression) {
            if ((expression = PsiUtil.deparenthesizeExpression(expression)) == null) {
                return null;
            }
            if (!(expression instanceof PsiReferenceExpression)) {
                return null;
            }
            PsiReferenceExpression reference = (PsiReferenceExpression)expression;
            PsiExpression qualifierExpression = reference.getQualifierExpression();
            if (qualifierExpression != null) {
                return null;
            }
            PsiElement referent = reference.resolve();
            if (!(referent instanceof PsiField)) {
                return null;
            }
            PsiField field = (PsiField)referent;
            if (field.hasModifierProperty("volatile") && !PsiUtil.isLanguageLevel9OrHigher(field)) {
                return null;
            }
            return field;
        }
    }
}

