/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.quickfix.SimplifyBooleanExpressionFix;
import com.intellij.codeInsight.intention.impl.AddNotNullAnnotationFix;
import com.intellij.codeInsight.intention.impl.AddNullableAnnotationFix;
import com.intellij.codeInspection.AnnotateMethodFix;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ReplaceWithTernaryOperatorFix;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaOptionalSupport;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.NullParameterConstraintChecker;
import com.intellij.codeInspection.dataFlow.NullabilityProblem;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StandardDataFlowRunner;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.fix.RedundantInstanceofFix;
import com.intellij.codeInspection.dataFlow.fix.ReplaceWithConstantValueFix;
import com.intellij.codeInspection.dataFlow.fix.ReplaceWithObjectsEqualsFix;
import com.intellij.codeInspection.dataFlow.fix.SimplifyToAssignmentFix;
import com.intellij.codeInspection.dataFlow.instructions.BinopInstruction;
import com.intellij.codeInspection.dataFlow.instructions.BranchingInstruction;
import com.intellij.codeInspection.dataFlow.instructions.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.instructions.TypeCastInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.nullable.NullableStuffInspectionBase;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataFlowInspectionBase
extends BaseJavaBatchLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.dataFlow.DataFlowInspection");
    @NonNls
    private static final String SHORT_NAME = "ConstantConditions";
    public boolean SUGGEST_NULLABLE_ANNOTATIONS;
    public boolean DONT_REPORT_TRUE_ASSERT_STATEMENTS;
    public boolean TREAT_UNKNOWN_MEMBERS_AS_NULLABLE;
    public boolean IGNORE_ASSERT_STATEMENTS;
    public boolean REPORT_CONSTANT_REFERENCE_VALUES = true;
    public boolean REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER = true;
    public boolean REPORT_NULLABLE_METHODS_RETURNING_NOT_NULL = true;
    public boolean REPORT_UNCHECKED_OPTIONALS = true;

    @Override
    public JComponent createOptionsPanel() {
        throw new RuntimeException("no UI in headless mode");
    }

    @Override
    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase", "writeSettings"));
        }
        node.addContent(new Element("option").setAttribute("name", "SUGGEST_NULLABLE_ANNOTATIONS").setAttribute("value", String.valueOf(this.SUGGEST_NULLABLE_ANNOTATIONS)));
        node.addContent(new Element("option").setAttribute("name", "DONT_REPORT_TRUE_ASSERT_STATEMENTS").setAttribute("value", String.valueOf(this.DONT_REPORT_TRUE_ASSERT_STATEMENTS)));
        if (this.IGNORE_ASSERT_STATEMENTS) {
            node.addContent(new Element("option").setAttribute("name", "IGNORE_ASSERT_STATEMENTS").setAttribute("value", "true"));
        }
        if (!this.REPORT_CONSTANT_REFERENCE_VALUES) {
            node.addContent(new Element("option").setAttribute("name", "REPORT_CONSTANT_REFERENCE_VALUES").setAttribute("value", "false"));
        }
        if (this.TREAT_UNKNOWN_MEMBERS_AS_NULLABLE) {
            node.addContent(new Element("option").setAttribute("name", "TREAT_UNKNOWN_MEMBERS_AS_NULLABLE").setAttribute("value", "true"));
        }
        if (!this.REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER) {
            node.addContent(new Element("option").setAttribute("name", "REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER").setAttribute("value", "false"));
        }
        if (!this.REPORT_NULLABLE_METHODS_RETURNING_NOT_NULL) {
            node.addContent(new Element("option").setAttribute("name", "REPORT_NULLABLE_METHODS_RETURNING_NOT_NULL").setAttribute("value", "false"));
        }
        if (!this.REPORT_UNCHECKED_OPTIONALS) {
            node.addContent(new Element("option").setAttribute("name", "REPORT_UNCHECKED_OPTIONALS").setAttribute("value", "false"));
        }
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitField(PsiField field) {
                DataFlowInspectionBase.this.analyzeCodeBlock(field, holder, isOnTheFly);
            }

            @Override
            public void visitMethod(PsiMethod method) {
                DataFlowInspectionBase.this.analyzeCodeBlock(method.getBody(), holder, isOnTheFly);
                DataFlowInspectionBase.this.analyzeNullLiteralMethodArguments(method, holder, isOnTheFly);
            }

            @Override
            public void visitClassInitializer(PsiClassInitializer initializer) {
                DataFlowInspectionBase.this.analyzeCodeBlock(initializer.getBody(), holder, isOnTheFly);
            }

            @Override
            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
                PsiType returnType;
                PsiType methodReturnType;
                super.visitMethodReferenceExpression(expression);
                PsiElement resolve = expression.resolve();
                if (resolve instanceof PsiMethod && TypeConversionUtil.isPrimitiveWrapper(methodReturnType = ((PsiMethod)resolve).getReturnType()) && NullableNotNullManager.isNullable((PsiMethod)resolve) && TypeConversionUtil.isPrimitiveAndNotNull(returnType = LambdaUtil.getFunctionalInterfaceReturnType(expression))) {
                    holder.registerProblem((PsiElement)expression, InspectionsBundle.message("dataflow.message.unboxing.method.reference", new Object[0]), new LocalQuickFix[0]);
                }
            }

            @Override
            public void visitIfStatement(PsiIfStatement statement) {
                PsiExpression condition = PsiUtil.skipParenthesizedExprDown(statement.getCondition());
                if (BranchingInstruction.isBoolConst(condition)) {
                    LocalQuickFix fix = DataFlowInspectionBase.createSimplifyBooleanExpressionFix(condition, condition.textMatches("true"));
                    holder.registerProblem((PsiElement)condition, "Condition is always " + condition.getText(), fix);
                }
            }

            @Override
            public void visitWhileStatement(PsiWhileStatement statement) {
                this.checkLoopCondition(statement.getCondition());
            }

            @Override
            public void visitDoWhileStatement(PsiDoWhileStatement statement) {
                this.checkLoopCondition(statement.getCondition());
            }

            @Override
            public void visitForStatement(PsiForStatement statement) {
                this.checkLoopCondition(statement.getCondition());
            }

            private void checkLoopCondition(PsiExpression condition) {
                if ((condition = PsiUtil.skipParenthesizedExprDown(condition)) != null && condition.textMatches("false")) {
                    holder.registerProblem((PsiElement)condition, "Condition is always false", DataFlowInspectionBase.createSimplifyBooleanExpressionFix(condition, false));
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    protected LocalQuickFix createNavigateToNullParameterUsagesFix(PsiParameter parameter) {
        return null;
    }

    private void analyzeNullLiteralMethodArguments(PsiMethod method, ProblemsHolder holder, boolean isOnTheFly) {
        if (this.REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER && isOnTheFly) {
            for (PsiParameter parameter : NullParameterConstraintChecker.checkMethodParameters(method)) {
                holder.registerProblem((PsiElement)parameter.getNameIdentifier(), InspectionsBundle.message("dataflow.method.fails.with.null.argument", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.createNavigateToNullParameterUsagesFix(parameter));
            }
        }
    }

    private void analyzeCodeBlock(@Nullable PsiElement scope, ProblemsHolder holder, boolean onTheFly) {
        if (scope == null) {
            return;
        }
        PsiClass containingClass = PsiTreeUtil.getParentOfType(scope, PsiClass.class);
        if (containingClass != null && PsiUtil.isLocalOrAnonymousClass(containingClass) && !(containingClass instanceof PsiEnumConstantInitializer)) {
            return;
        }
        StandardDataFlowRunner dfaRunner = new StandardDataFlowRunner(this.TREAT_UNKNOWN_MEMBERS_AS_NULLABLE, !DataFlowInspectionBase.isInsideConstructorOrInitializer(scope));
        this.analyzeDfaWithNestedClosures(scope, holder, dfaRunner, Collections.singletonList(dfaRunner.createMemoryState()), onTheFly);
    }

    private static boolean isInsideConstructorOrInitializer(PsiElement element) {
        while (element != null) {
            if ((element = PsiTreeUtil.getParentOfType(element, PsiMethod.class, PsiClassInitializer.class)) instanceof PsiClassInitializer) {
                return true;
            }
            if (!(element instanceof PsiMethod)) continue;
            if (((PsiMethod)element).isConstructor()) {
                return true;
            }
            PsiClass containingClass = ((PsiMethod)element).getContainingClass();
            return !InheritanceUtil.processSupers(containingClass, true, psiClass -> !DataFlowInspectionBase.canCallMethodsInConstructors(psiClass, psiClass != containingClass));
        }
        return false;
    }

    private static boolean canCallMethodsInConstructors(PsiClass aClass, boolean virtual) {
        for (PsiMethod constructor : aClass.getConstructors()) {
            if (!constructor.getLanguage().isKindOf(JavaLanguage.INSTANCE)) {
                return true;
            }
            PsiCodeBlock body = constructor.getBody();
            if (body == null) continue;
            for (PsiMethodCallExpression call : ((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot(body)).filter(PsiMethodCallExpression.class)) {
                PsiReferenceExpression methodExpression = call.getMethodExpression();
                if (methodExpression.textMatches("this") || methodExpression.textMatches("super")) continue;
                if (!virtual) {
                    return true;
                }
                PsiMethod target = call.resolveMethod();
                if (target == null || !PsiUtil.canBeOverriden(target)) continue;
                return true;
            }
        }
        return false;
    }

    private void analyzeDfaWithNestedClosures(PsiElement scope, ProblemsHolder holder, StandardDataFlowRunner dfaRunner, Collection<DfaMemoryState> initialStates, boolean onTheFly) {
        PsiMethod method;
        PsiIdentifier name;
        DataFlowInstructionVisitor visitor = new DataFlowInstructionVisitor();
        RunnerResult rc = dfaRunner.analyzeMethod(scope, visitor, this.IGNORE_ASSERT_STATEMENTS, initialStates);
        if (rc == RunnerResult.OK) {
            this.createDescription(dfaRunner, holder, visitor, onTheFly, scope);
            MultiMap<PsiElement, DfaMemoryState> nestedClosures = dfaRunner.getNestedClosures();
            for (PsiElement closure : nestedClosures.keySet()) {
                this.analyzeDfaWithNestedClosures(closure, holder, dfaRunner, nestedClosures.get(closure), onTheFly);
            }
        } else if (rc == RunnerResult.TOO_COMPLEX && scope.getParent() instanceof PsiMethod && (name = (method = (PsiMethod)scope.getParent()).getNameIdentifier()) != null) {
            holder.registerProblem((PsiElement)name, InspectionsBundle.message("dataflow.too.complex", new Object[0]), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
        }
    }

    @NotNull
    private List<LocalQuickFix> createNPEFixes(PsiExpression qualifier, PsiExpression expression, boolean onTheFly) {
        SmartList<LocalQuickFix> fixes = new SmartList<LocalQuickFix>();
        if (qualifier == null || expression == null) {
            SmartList<LocalQuickFix> smartList = fixes;
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase", "createNPEFixes"));
            }
            return smartList;
        }
        try {
            if (DataFlowInspectionBase.isVolatileFieldReference(qualifier)) {
                ContainerUtil.addIfNotNull(fixes, this.createIntroduceVariableFix(qualifier));
            } else if (!DataFlowInspectionBase.isNullLiteral(qualifier) && !(qualifier instanceof PsiMethodCallExpression)) {
                if (PsiUtil.getLanguageLevel(qualifier).isAtLeast(LanguageLevel.JDK_1_4)) {
                    Project project = qualifier.getProject();
                    PsiElementFactory elementFactory = JavaPsiFacade.getInstance(project).getElementFactory();
                    PsiBinaryExpression binary = (PsiBinaryExpression)elementFactory.createExpressionFromText("a != null", null);
                    binary.getLOperand().replace(qualifier);
                    ContainerUtil.addIfNotNull(fixes, this.createAssertFix(binary, expression));
                }
                this.addSurroundWithIfFix(qualifier, fixes, onTheFly);
                if (ReplaceWithTernaryOperatorFix.isAvailable(qualifier, expression)) {
                    fixes.add(new ReplaceWithTernaryOperatorFix(qualifier));
                }
            }
            ContainerUtil.addIfNotNull(fixes, DfaOptionalSupport.registerReplaceOptionalOfWithOfNullableFix(qualifier));
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
        }
        SmartList<LocalQuickFix> smartList = fixes;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase", "createNPEFixes"));
        }
        return smartList;
    }

    private static boolean isNullLiteral(PsiExpression qualifier) {
        return qualifier instanceof PsiLiteralExpression && ((PsiLiteralExpression)qualifier).getValue() == null;
    }

    @Nullable
    protected LocalQuickFix createIntroduceVariableFix(PsiExpression expression) {
        return null;
    }

    private static boolean isVolatileFieldReference(PsiExpression qualifier) {
        PsiElement target = qualifier instanceof PsiReferenceExpression ? ((PsiReferenceExpression)qualifier).resolve() : null;
        return target instanceof PsiField && ((PsiField)target).hasModifierProperty("volatile");
    }

    protected LocalQuickFix createAssertFix(PsiBinaryExpression binary, PsiExpression expression) {
        return null;
    }

    protected LocalQuickFix createReplaceWithTrivialLambdaFix(Object value) {
        return null;
    }

    protected void addSurroundWithIfFix(PsiExpression qualifier, List<LocalQuickFix> fixes, boolean onTheFly) {
    }

    private void createDescription(StandardDataFlowRunner runner, ProblemsHolder holder, DataFlowInstructionVisitor visitor, boolean onTheFly, PsiElement scope) {
        Pair<Set<Instruction>, Set<Instruction>> constConditions = runner.getConstConditionalExpressions();
        Set<Instruction> trueSet = constConditions.getFirst();
        Set<Instruction> falseSet = constConditions.getSecond();
        ArrayList<Instruction> allProblems = new ArrayList<Instruction>();
        allProblems.addAll(trueSet);
        allProblems.addAll(falseSet);
        allProblems.addAll(visitor.myCCEInstructions);
        allProblems.addAll(ContainerUtil.filter(runner.getInstructions(), instruction1 -> instruction1 instanceof InstanceofInstruction && visitor.isInstanceofRedundant((InstanceofInstruction)instruction1)));
        HashSet<PsiElement> reportedAnchors = new HashSet<PsiElement>();
        for (PsiElement element : visitor.getProblems(NullabilityProblem.callNPE)) {
            if (!reportedAnchors.add(element)) continue;
            this.reportCallMayProduceNpe(holder, (PsiMethodCallExpression)element, holder.isOnTheFly());
        }
        for (PsiElement element : visitor.getProblems(NullabilityProblem.fieldAccessNPE)) {
            if (!reportedAnchors.add(element)) continue;
            PsiElement parent = element.getParent();
            PsiElement fieldAccess = parent instanceof PsiArrayAccessExpression || parent instanceof PsiReferenceExpression ? parent : element;
            this.reportFieldAccessMayProduceNpe(holder, element, (PsiExpression)fieldAccess);
        }
        for (Instruction instruction : allProblems) {
            if (instruction instanceof TypeCastInstruction && reportedAnchors.add(((TypeCastInstruction)instruction).getCastExpression().getCastType())) {
                DataFlowInspectionBase.reportCastMayFail(holder, (TypeCastInstruction)instruction);
                continue;
            }
            if (!(instruction instanceof BranchingInstruction)) continue;
            this.handleBranchingInstruction(holder, visitor, trueSet, falseSet, reportedAnchors, (BranchingInstruction)instruction, onTheFly);
        }
        DataFlowInspectionBase.reportAlwaysFailingCalls(holder, visitor, reportedAnchors);
        this.reportConstantPushes(runner, holder, visitor, reportedAnchors);
        this.reportNullableArguments(visitor, holder, reportedAnchors);
        DataFlowInspectionBase.reportNullableAssignments(visitor, holder, reportedAnchors);
        DataFlowInspectionBase.reportUnboxedNullables(visitor, holder, reportedAnchors);
        this.reportNullableReturns(visitor, holder, reportedAnchors, scope);
        if (this.SUGGEST_NULLABLE_ANNOTATIONS) {
            this.reportNullableArgumentsPassedToNonAnnotated(visitor, holder, reportedAnchors);
        }
        DataFlowInspectionBase.reportOptionalOfNullableImprovements(holder, reportedAnchors, runner.getInstructions());
        this.reportUncheckedOptionalGet(holder, visitor.getOptionalCalls(), visitor.getOptionalQualifiers());
        visitor.getBooleanCalls().forEach((call, state) -> {
            if (state != ThreeState.UNSURE && reportedAnchors.add((PsiElement)call)) {
                this.reportConstantCondition(holder, visitor, (PsiElement)call, state.toBoolean());
            }
        });
        this.reportMethodReferenceProblems(holder, visitor);
        DataFlowInspectionBase.reportArrayAccessProblems(holder, visitor);
        if (this.REPORT_CONSTANT_REFERENCE_VALUES) {
            DataFlowInspectionBase.reportConstantReferenceValues(holder, visitor, reportedAnchors);
        }
        if (this.REPORT_NULLABLE_METHODS_RETURNING_NOT_NULL && visitor.isAlwaysReturnsNotNull()) {
            DataFlowInspectionBase.reportAlwaysReturnsNotNull(holder, scope);
        }
    }

    private static void reportArrayAccessProblems(ProblemsHolder holder, DataFlowInstructionVisitor visitor) {
        visitor.outOfBoundsArrayAccesses().forEach(access -> {
            PsiExpression indexExpression = access.getIndexExpression();
            if (indexExpression != null) {
                holder.registerProblem((PsiElement)indexExpression, InspectionsBundle.message("dataflow.message.array.index.out.of.bounds", new Object[0]), new LocalQuickFix[0]);
            }
        });
    }

    private void reportMethodReferenceProblems(ProblemsHolder holder, DataFlowInstructionVisitor visitor) {
        visitor.getMethodReferenceResults().forEach((methodRef, dfaValue) -> {
            Object value;
            if (dfaValue instanceof DfaConstValue && (value = ((DfaConstValue)dfaValue).getValue()) instanceof Boolean) {
                holder.registerProblem((PsiElement)methodRef, InspectionsBundle.message("dataflow.message.constant.method.reference", value), this.createReplaceWithTrivialLambdaFix(value));
            }
        });
    }

    private void reportUncheckedOptionalGet(ProblemsHolder holder, Map<PsiMethodCallExpression, ThreeState> calls, List<PsiExpression> qualifiers) {
        if (!this.REPORT_UNCHECKED_OPTIONALS) {
            return;
        }
        for (Map.Entry<PsiMethodCallExpression, ThreeState> entry : calls.entrySet()) {
            PsiExpression qualifier;
            PsiClass optionalClass;
            PsiMethodCallExpression call;
            PsiMethod method;
            ThreeState state = entry.getValue();
            if (state != ThreeState.UNSURE || (method = (call = entry.getKey()).resolveMethod()) == null || (optionalClass = method.getContainingClass()) == null || (qualifier = PsiUtil.skipParenthesizedExprDown(call.getMethodExpression().getQualifierExpression())) instanceof PsiMethodCallExpression && qualifiers.stream().anyMatch(q -> PsiEquivalenceUtil.areElementsEquivalent(q, qualifier))) continue;
            holder.registerProblem(DataFlowInspectionBase.getElementToHighlight(call), InspectionsBundle.message("dataflow.message.optional.get.without.is.present", optionalClass.getName()), new LocalQuickFix[0]);
        }
    }

    private static void reportAlwaysReturnsNotNull(ProblemsHolder holder, PsiElement scope) {
        if (!(scope.getParent() instanceof PsiMethod)) {
            return;
        }
        PsiMethod method = (PsiMethod)scope.getParent();
        if (PsiUtil.canBeOverriden(method)) {
            return;
        }
        PsiAnnotation nullableAnno = NullableNotNullManager.getInstance(scope.getProject()).getNullableAnnotation(method, false);
        if (nullableAnno == null || !nullableAnno.isPhysical()) {
            return;
        }
        PsiJavaCodeReferenceElement annoName = nullableAnno.getNameReferenceElement();
        assert (annoName != null);
        String msg = "@" + NullableStuffInspectionBase.getPresentableAnnoName(nullableAnno) + " method '" + method.getName() + "' always return a non-null value";
        holder.registerProblem((PsiElement)annoName, msg, new AddNotNullAnnotationFix(method));
    }

    private static void reportAlwaysFailingCalls(ProblemsHolder holder, DataFlowInstructionVisitor visitor, HashSet<PsiElement> reportedAnchors) {
        if (ProjectFileIndex.SERVICE.getInstance(holder.getProject()).isInTestSourceContent(holder.getFile().getViewProvider().getVirtualFile())) {
            return;
        }
        for (PsiCall call : visitor.getAlwaysFailingCalls()) {
            PsiMethod method = call.resolveMethod();
            if (method == null || !reportedAnchors.add(call)) continue;
            holder.registerProblem(DataFlowInspectionBase.getElementToHighlight(call), "The call to '#ref' always fails, according to its method contracts", new LocalQuickFix[0]);
        }
    }

    @NotNull
    private static PsiElement getElementToHighlight(@NotNull PsiCall call) {
        PsiJavaCodeReferenceElement ref;
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase", "getElementToHighlight"));
        }
        if (call instanceof PsiNewExpression) {
            ref = ((PsiNewExpression)call).getClassReference();
        } else if (call instanceof PsiMethodCallExpression) {
            ref = ((PsiMethodCallExpression)call).getMethodExpression();
        } else {
            PsiCall psiCall = call;
            if (psiCall == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase", "getElementToHighlight"));
            }
            return psiCall;
        }
        if (ref != null) {
            PsiElement name = ref.getReferenceNameElement();
            PsiElement psiElement = name != null ? name : ref;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase", "getElementToHighlight"));
            }
            return psiElement;
        }
        PsiCall psiCall = call;
        if (psiCall == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase", "getElementToHighlight"));
        }
        return psiCall;
    }

    private void reportConstantPushes(StandardDataFlowRunner runner, ProblemsHolder holder, DataFlowInstructionVisitor visitor, Set<PsiElement> reportedAnchors) {
        for (Instruction instruction : runner.getInstructions()) {
            Object constant;
            if (!(instruction instanceof PushInstruction)) continue;
            PsiExpression place = ((PushInstruction)instruction).getPlace();
            DfaValue value = ((PushInstruction)instruction).getValue();
            Object object = constant = value instanceof DfaConstValue ? ((DfaConstValue)value).getValue() : null;
            if (!(place instanceof PsiPolyadicExpression) || !(constant instanceof Boolean) || DataFlowInspectionBase.isFlagCheck(place) || !reportedAnchors.add(place)) continue;
            this.reportConstantCondition(holder, visitor, place, (Boolean)constant);
        }
    }

    private static void reportOptionalOfNullableImprovements(ProblemsHolder holder, Set<PsiElement> reportedAnchors, Instruction[] instructions) {
        for (Instruction instruction : instructions) {
            PsiExpression[] args;
            if (!(instruction instanceof MethodCallInstruction) || (args = ((MethodCallInstruction)instruction).getArgs()).length != 1) continue;
            PsiExpression expr = args[0];
            if (((MethodCallInstruction)instruction).isOptionalAlwaysNullProblem()) {
                if (!reportedAnchors.add(expr)) continue;
                holder.registerProblem((PsiElement)expr, "Passing <code>null</code> argument to <code>Optional</code>", DfaOptionalSupport.createReplaceOptionalOfNullableWithEmptyFix(expr));
                continue;
            }
            if (!((MethodCallInstruction)instruction).isOptionalAlwaysNotNullProblem() || !reportedAnchors.add(expr)) continue;
            holder.registerProblem((PsiElement)expr, "Passing a non-null argument to <code>Optional</code>", DfaOptionalSupport.createReplaceOptionalOfNullableWithOfFix());
        }
    }

    private static void reportConstantReferenceValues(ProblemsHolder holder, StandardInstructionVisitor visitor, Set<PsiElement> reportedAnchors) {
        for (Pair<PsiReferenceExpression, DfaConstValue> pair : visitor.getConstantReferenceValues()) {
            PsiReferenceExpression ref = (PsiReferenceExpression)pair.first;
            if (ref.getParent() instanceof PsiReferenceExpression || !reportedAnchors.add(ref)) continue;
            Object value = ((DfaConstValue)pair.second).getValue();
            PsiVariable constant = ((DfaConstValue)pair.second).getConstant();
            String presentableName = constant != null ? constant.getName() : String.valueOf(value);
            String exprText = String.valueOf(value);
            if (presentableName == null || exprText == null) continue;
            holder.registerProblem((PsiElement)ref, "Value <code>#ref</code> #loc is always '" + presentableName + "'", new ReplaceWithConstantValueFix(presentableName, exprText));
        }
    }

    private void reportNullableArgumentsPassedToNonAnnotated(DataFlowInstructionVisitor visitor, ProblemsHolder holder, Set<PsiElement> reportedAnchors) {
        for (PsiElement expr : visitor.getProblems(NullabilityProblem.passingNullableArgumentToNonAnnotatedParameter)) {
            PsiParameter[] parameters;
            PsiMethod psiMethod;
            PsiElement gParent;
            int idx;
            if (reportedAnchors.contains(expr)) continue;
            String text2 = DataFlowInspectionBase.isNullLiteralExpression(expr) ? "Passing <code>null</code> argument to non annotated parameter" : "Argument <code>#ref</code> #loc might be null but passed to non annotated parameter";
            List<LocalQuickFix> fixes = this.createNPEFixes((PsiExpression)expr, (PsiExpression)expr, holder.isOnTheFly());
            PsiElement parent = expr.getParent();
            if (!(parent instanceof PsiExpressionList) || (idx = ArrayUtilRt.find(((PsiExpressionList)parent).getExpressions(), expr)) <= -1 || !((gParent = parent.getParent()) instanceof PsiCallExpression) || (psiMethod = ((PsiCallExpression)gParent).resolveMethod()) == null || !psiMethod.getManager().isInProject(psiMethod) || !AnnotationUtil.isAnnotatingApplicable(psiMethod) || idx >= (parameters = psiMethod.getParameterList().getParameters()).length) continue;
            fixes.add(new AddNullableAnnotationFix(parameters[idx]));
            holder.registerProblem(expr, text2, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            reportedAnchors.add(expr);
        }
    }

    private void reportCallMayProduceNpe(ProblemsHolder holder, PsiMethodCallExpression callExpression, boolean onTheFly) {
        PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
        List<LocalQuickFix> fixes = this.createNPEFixes(methodExpression.getQualifierExpression(), callExpression, onTheFly);
        ContainerUtil.addIfNotNull(fixes, ReplaceWithObjectsEqualsFix.createFix(callExpression, methodExpression));
        PsiElement toHighlight = DataFlowInspectionBase.getElementToHighlight(callExpression);
        holder.registerProblem(toHighlight, InspectionsBundle.message("dataflow.message.npe.method.invocation", new Object[0]), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
    }

    private void reportFieldAccessMayProduceNpe(ProblemsHolder holder, PsiElement elementToAssert, @NotNull PsiExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase", "reportFieldAccessMayProduceNpe"));
        }
        LocalQuickFix[] fix = this.createNPEFixes((PsiExpression)elementToAssert, expression, holder.isOnTheFly()).toArray(LocalQuickFix.EMPTY_ARRAY);
        if (expression instanceof PsiArrayAccessExpression) {
            holder.registerProblem((PsiElement)expression, InspectionsBundle.message("dataflow.message.npe.array.access", new Object[0]), fix);
        } else {
            assert (elementToAssert != null);
            holder.registerProblem(elementToAssert, expression.textMatches("null") ? InspectionsBundle.message("dataflow.message.npe.field.access.sure", new Object[0]) : InspectionsBundle.message("dataflow.message.npe.field.access", new Object[0]), fix);
        }
    }

    private static void reportCastMayFail(ProblemsHolder holder, TypeCastInstruction instruction) {
        PsiTypeCastExpression typeCast = instruction.getCastExpression();
        PsiExpression operand = typeCast.getOperand();
        PsiTypeElement castType = typeCast.getCastType();
        assert (castType != null);
        assert (operand != null);
        holder.registerProblem((PsiElement)castType, InspectionsBundle.message("dataflow.message.cce", operand.getText()), new LocalQuickFix[0]);
    }

    private void handleBranchingInstruction(ProblemsHolder holder, StandardInstructionVisitor visitor, Set<Instruction> trueSet, Set<Instruction> falseSet, HashSet<PsiElement> reportedAnchors, BranchingInstruction instruction, boolean onTheFly) {
        PsiElement psiAnchor = instruction.getPsiAnchor();
        if (instruction instanceof InstanceofInstruction && visitor.isInstanceofRedundant((InstanceofInstruction)instruction)) {
            if (visitor.canBeNull((BinopInstruction)instruction)) {
                holder.registerProblem(psiAnchor, InspectionsBundle.message("dataflow.message.redundant.instanceof", new Object[0]), new RedundantInstanceofFix());
            } else {
                LocalQuickFix[] localQuickFixArray;
                LocalQuickFix localQuickFix = DataFlowInspectionBase.createSimplifyBooleanExpressionFix(psiAnchor, true);
                String string = InspectionsBundle.message(DataFlowInspectionBase.isAtRHSOfBooleanAnd(psiAnchor) ? "dataflow.message.constant.condition.when.reached" : "dataflow.message.constant.condition", Boolean.toString(true));
                if (localQuickFix == null) {
                    localQuickFixArray = null;
                } else {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[0] = localQuickFix;
                }
                holder.registerProblem(psiAnchor, string, localQuickFixArray);
            }
        } else if (psiAnchor instanceof PsiSwitchLabelStatement) {
            if (falseSet.contains(instruction)) {
                holder.registerProblem(psiAnchor, InspectionsBundle.message("dataflow.message.unreachable.switch.label", new Object[0]), new LocalQuickFix[0]);
            }
        } else if (psiAnchor != null && !reportedAnchors.contains(psiAnchor) && !DataFlowInspectionBase.isFlagCheck(psiAnchor)) {
            boolean evaluatesToTrue = trueSet.contains(instruction);
            PsiElement parent = psiAnchor.getParent();
            if (parent instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)parent).getLExpression() == psiAnchor) {
                holder.registerProblem(psiAnchor, InspectionsBundle.message("dataflow.message.pointless.assignment.expression", Boolean.toString(evaluatesToTrue)), this.createConditionalAssignmentFixes(evaluatesToTrue, (PsiAssignmentExpression)parent, onTheFly));
            } else {
                this.reportConstantCondition(holder, visitor, psiAnchor, evaluatesToTrue);
            }
            reportedAnchors.add(psiAnchor);
        }
    }

    private void reportConstantCondition(ProblemsHolder holder, StandardInstructionVisitor visitor, PsiElement psiAnchor, boolean evaluatesToTrue) {
        if (!this.skipReportingConstantCondition(visitor, psiAnchor, evaluatesToTrue)) {
            if (psiAnchor.getParent() instanceof PsiForeachStatement) {
                if (!evaluatesToTrue) {
                    return;
                }
                boolean array = psiAnchor instanceof PsiExpression && ((PsiExpression)psiAnchor).getType() instanceof PsiArrayType;
                holder.registerProblem(psiAnchor, array ? InspectionsBundle.message("dataflow.message.loop.on.empty.array", new Object[0]) : InspectionsBundle.message("dataflow.message.loop.on.empty.collection", new Object[0]), new LocalQuickFix[0]);
            } else {
                LocalQuickFix[] localQuickFixArray;
                LocalQuickFix fix = DataFlowInspectionBase.createSimplifyBooleanExpressionFix(psiAnchor, evaluatesToTrue);
                String message = InspectionsBundle.message(DataFlowInspectionBase.isAtRHSOfBooleanAnd(psiAnchor) ? "dataflow.message.constant.condition.when.reached" : "dataflow.message.constant.condition", Boolean.toString(evaluatesToTrue));
                if (fix == null) {
                    localQuickFixArray = null;
                } else {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[0] = fix;
                }
                holder.registerProblem(psiAnchor, message, localQuickFixArray);
            }
        }
    }

    protected LocalQuickFix[] createConditionalAssignmentFixes(boolean evaluatesToTrue, PsiAssignmentExpression parent, boolean onTheFly) {
        return LocalQuickFix.EMPTY_ARRAY;
    }

    private boolean skipReportingConstantCondition(StandardInstructionVisitor visitor, PsiElement psiAnchor, boolean evaluatesToTrue) {
        return this.DONT_REPORT_TRUE_ASSERT_STATEMENTS && DataFlowInspectionBase.isAssertionEffectively(psiAnchor, evaluatesToTrue) || visitor.silenceConstantCondition(psiAnchor);
    }

    private void reportNullableArguments(DataFlowInstructionVisitor visitor, ProblemsHolder holder, Set<PsiElement> reportedAnchors) {
        for (PsiElement expr : visitor.getProblems(NullabilityProblem.passingNullableToNotNullParameter)) {
            if (!reportedAnchors.add(expr)) continue;
            String text2 = DataFlowInspectionBase.isNullLiteralExpression(expr) ? InspectionsBundle.message("dataflow.message.passing.null.argument", new Object[0]) : InspectionsBundle.message("dataflow.message.passing.nullable.argument", new Object[0]);
            List<LocalQuickFix> fixes = this.createNPEFixes((PsiExpression)expr, (PsiExpression)expr, holder.isOnTheFly());
            holder.registerProblem(expr, text2, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        }
    }

    private static void reportNullableAssignments(DataFlowInstructionVisitor visitor, ProblemsHolder holder, Set<PsiElement> reportedAnchors) {
        for (PsiElement expr : visitor.getProblems(NullabilityProblem.assigningToNotNull)) {
            if (!reportedAnchors.add(expr)) continue;
            String text2 = DataFlowInspectionBase.isNullLiteralExpression(expr) ? InspectionsBundle.message("dataflow.message.assigning.null", new Object[0]) : InspectionsBundle.message("dataflow.message.assigning.nullable", new Object[0]);
            holder.registerProblem(expr, text2, new LocalQuickFix[0]);
        }
    }

    private static void reportUnboxedNullables(DataFlowInstructionVisitor visitor, ProblemsHolder holder, Set<PsiElement> reportedAnchors) {
        for (PsiElement expr : visitor.getProblems(NullabilityProblem.unboxingNullable)) {
            if (!reportedAnchors.add(expr)) continue;
            holder.registerProblem(expr, InspectionsBundle.message("dataflow.message.unboxing", new Object[0]), new LocalQuickFix[0]);
        }
    }

    @Nullable
    private static PsiMethod getScopeMethod(PsiElement block) {
        PsiElement parent = block.getParent();
        if (parent instanceof PsiMethod) {
            return (PsiMethod)parent;
        }
        if (parent instanceof PsiLambdaExpression) {
            return LambdaUtil.getFunctionalInterfaceMethod(((PsiLambdaExpression)parent).getFunctionalInterfaceType());
        }
        return null;
    }

    private void reportNullableReturns(DataFlowInstructionVisitor visitor, ProblemsHolder holder, Set<PsiElement> reportedAnchors, @NotNull PsiElement block) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase", "reportNullableReturns"));
        }
        PsiMethod method = DataFlowInspectionBase.getScopeMethod(block);
        if (method == null || NullableStuffInspectionBase.isNullableNotInferred(method, true)) {
            return;
        }
        PsiAnnotation notNullAnno = NullableNotNullManager.getInstance(method.getProject()).getNotNullAnnotation(method, true);
        if (notNullAnno == null && (!this.SUGGEST_NULLABLE_ANNOTATIONS || block.getParent() instanceof PsiLambdaExpression)) {
            return;
        }
        PsiType returnType = method.getReturnType();
        if (block instanceof PsiExpression && block.getParent() instanceof PsiLambdaExpression && PsiType.VOID.equals(returnType)) {
            return;
        }
        if (returnType == null || returnType.equalsToText("java.lang.Void")) {
            return;
        }
        for (PsiElement statement : visitor.getProblems(NullabilityProblem.nullableReturn)) {
            LocalQuickFix[] localQuickFixArray;
            String text2;
            assert (statement instanceof PsiExpression);
            PsiExpression expr = (PsiExpression)statement;
            if (!reportedAnchors.add(expr)) continue;
            if (notNullAnno != null) {
                String presentable = NullableStuffInspectionBase.getPresentableAnnoName(notNullAnno);
                String text3 = DataFlowInspectionBase.isNullLiteralExpression(expr) ? InspectionsBundle.message("dataflow.message.return.null.from.notnull", presentable) : InspectionsBundle.message("dataflow.message.return.nullable.from.notnull", presentable);
                holder.registerProblem((PsiElement)expr, text3, new LocalQuickFix[0]);
                continue;
            }
            if (!AnnotationUtil.isAnnotatingApplicable(statement)) continue;
            NullableNotNullManager manager = NullableNotNullManager.getInstance(expr.getProject());
            String defaultNullable = manager.getDefaultNullable();
            String presentableNullable = StringUtil.getShortName(defaultNullable);
            String string = text2 = DataFlowInspectionBase.isNullLiteralExpression(expr) ? InspectionsBundle.message("dataflow.message.return.null.from.notnullable", presentableNullable) : InspectionsBundle.message("dataflow.message.return.nullable.from.notnullable", presentableNullable);
            if (PsiTreeUtil.getParentOfType((PsiElement)expr, PsiMethod.class, PsiLambdaExpression.class) instanceof PsiLambdaExpression) {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            } else {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = new AnnotateMethodFix(defaultNullable, ArrayUtil.toStringArray(manager.getNotNulls())){

                    @Override
                    public int shouldAnnotateBaseMethod(PsiMethod method, PsiMethod superMethod, Project project) {
                        return 1;
                    }
                };
            }
            LocalQuickFix[] fixes = localQuickFixArray;
            holder.registerProblem((PsiElement)expr, text2, fixes);
        }
    }

    private static boolean isAssertionEffectively(PsiElement psiAnchor, boolean evaluatesToTrue) {
        PsiElement parent = psiAnchor.getParent();
        if (parent instanceof PsiAssertStatement) {
            return evaluatesToTrue;
        }
        if (parent instanceof PsiIfStatement && psiAnchor == ((PsiIfStatement)parent).getCondition()) {
            PsiStatement[] statements;
            PsiStatement thenBranch = ((PsiIfStatement)parent).getThenBranch();
            if (thenBranch instanceof PsiThrowStatement) {
                return !evaluatesToTrue;
            }
            if (thenBranch instanceof PsiBlockStatement && (statements = ((PsiBlockStatement)thenBranch).getCodeBlock().getStatements()).length == 1 && statements[0] instanceof PsiThrowStatement) {
                return !evaluatesToTrue;
            }
        }
        return false;
    }

    private static boolean isAtRHSOfBooleanAnd(PsiElement expr) {
        PsiElement cur = expr;
        while (cur != null && !(cur instanceof PsiMember)) {
            PsiElement parent = cur.getParent();
            if (parent instanceof PsiBinaryExpression && cur == ((PsiBinaryExpression)parent).getROperand()) {
                return true;
            }
            cur = parent;
        }
        return false;
    }

    private static boolean isFlagCheck(PsiElement element) {
        PsiExpression topExpression;
        Object scope = PsiTreeUtil.getParentOfType(element, PsiStatement.class, PsiVariable.class);
        PsiExpression psiExpression = scope instanceof PsiIfStatement ? ((PsiIfStatement)scope).getCondition() : (topExpression = scope instanceof PsiVariable ? ((PsiVariable)scope).getInitializer() : null);
        if (!PsiTreeUtil.isAncestor(topExpression, element, false)) {
            return false;
        }
        return StreamEx.ofTree((Object)topExpression, e -> StreamEx.of((Object[])e.getChildren())).anyMatch(DataFlowInspectionBase::isCompileTimeFlagCheck);
    }

    private static boolean isCompileTimeFlagCheck(PsiElement element) {
        PsiBinaryExpression binOp;
        if (element instanceof PsiBinaryExpression && ComparisonUtils.isComparisonOperation((binOp = (PsiBinaryExpression)element).getOperationTokenType())) {
            PsiBinaryExpression subOp;
            PsiExpression comparedWith = null;
            if (ExpressionUtils.isLiteral(binOp.getROperand())) {
                comparedWith = binOp.getLOperand();
            } else if (ExpressionUtils.isLiteral(binOp.getLOperand())) {
                comparedWith = binOp.getROperand();
            }
            comparedWith = PsiUtil.skipParenthesizedExprDown(comparedWith);
            if (DataFlowInspectionBase.isConstantOfType(comparedWith, PsiType.INT, PsiType.LONG)) {
                return true;
            }
            if (comparedWith instanceof PsiBinaryExpression && (subOp = (PsiBinaryExpression)comparedWith).getOperationTokenType().equals(JavaTokenType.AND)) {
                PsiExpression left = PsiUtil.skipParenthesizedExprDown(subOp.getLOperand());
                PsiExpression right = PsiUtil.skipParenthesizedExprDown(subOp.getROperand());
                if (DataFlowInspectionBase.isConstantOfType(left, PsiType.INT, PsiType.LONG) || DataFlowInspectionBase.isConstantOfType(right, PsiType.INT, PsiType.LONG)) {
                    return true;
                }
            }
        }
        return DataFlowInspectionBase.isConstantOfType(element, PsiType.BOOLEAN);
    }

    private static boolean isConstantOfType(PsiElement element, PsiPrimitiveType ... types) {
        PsiElement resolved;
        PsiElement psiElement = resolved = element instanceof PsiReferenceExpression ? ((PsiReferenceExpression)element).resolve() : null;
        if (!(resolved instanceof PsiField)) {
            return false;
        }
        PsiField field = (PsiField)resolved;
        return field.hasModifierProperty("final") && field.hasModifierProperty("static") && ArrayUtil.contains(field.getType(), types);
    }

    private static boolean isNullLiteralExpression(PsiElement expr) {
        if (expr instanceof PsiLiteralExpression) {
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)expr;
            return PsiType.NULL.equals(literalExpression.getType());
        }
        return false;
    }

    @Nullable
    private static LocalQuickFix createSimplifyBooleanExpressionFix(PsiElement element, final boolean value) {
        SimplifyBooleanExpressionFix fix = DataFlowInspectionBase.createIntention(element, value);
        if (fix == null) {
            return null;
        }
        final String text2 = fix.getText();
        return new LocalQuickFix(){

            @Override
            @NotNull
            public String getName() {
                String string = text2;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase$3", "getName"));
                }
                return string;
            }

            @Override
            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase$3", "applyFix"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase$3", "applyFix"));
                }
                PsiElement psiElement = descriptor.getPsiElement();
                if (psiElement == null) {
                    return;
                }
                SimplifyBooleanExpressionFix fix = DataFlowInspectionBase.createIntention(psiElement, value);
                if (fix == null) {
                    return;
                }
                try {
                    LOG.assertTrue(psiElement.isValid());
                    fix.applyFix();
                }
                catch (IncorrectOperationException e) {
                    LOG.error(e);
                }
            }

            @Override
            @NotNull
            public String getFamilyName() {
                String string = InspectionsBundle.message("inspection.data.flow.simplify.boolean.expression.quickfix", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase$3", "getFamilyName"));
                }
                return string;
            }
        };
    }

    @NotNull
    protected static LocalQuickFix createSimplifyToAssignmentFix() {
        SimplifyToAssignmentFix simplifyToAssignmentFix = new SimplifyToAssignmentFix();
        if (simplifyToAssignmentFix == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase", "createSimplifyToAssignmentFix"));
        }
        return simplifyToAssignmentFix;
    }

    private static SimplifyBooleanExpressionFix createIntention(PsiElement element, boolean value) {
        if (!(element instanceof PsiExpression)) {
            return null;
        }
        if (PsiTreeUtil.findChildOfType(element, PsiAssignmentExpression.class) != null) {
            return null;
        }
        PsiExpression expression = (PsiExpression)element;
        while (element.getParent() instanceof PsiExpression) {
            element = element.getParent();
        }
        SimplifyBooleanExpressionFix fix = new SimplifyBooleanExpressionFix(expression, value);
        if (!fix.isAvailable() || SimplifyBooleanExpressionFix.canBeSimplified((PsiExpression)element)) {
            return null;
        }
        return fix;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message("inspection.data.flow.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.BUGS_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase", "getShortName"));
        }
        return SHORT_NAME;
    }

    private static class DataFlowInstructionVisitor
    extends StandardInstructionVisitor {
        private final MultiMap<NullabilityProblem, PsiElement> myProblems = new MultiMap();
        private final Map<Pair<NullabilityProblem, PsiElement>, StateInfo> myStateInfos = ContainerUtil.newHashMap();
        private final Set<Instruction> myCCEInstructions = ContainerUtil.newHashSet();
        private final Map<MethodCallInstruction, Boolean> myFailingCalls = new HashMap<MethodCallInstruction, Boolean>();
        private final Map<PsiMethodCallExpression, ThreeState> myOptionalCalls = new HashMap<PsiMethodCallExpression, ThreeState>();
        private final Map<PsiMethodCallExpression, ThreeState> myBooleanCalls = new HashMap<PsiMethodCallExpression, ThreeState>();
        private final Map<PsiMethodReferenceExpression, DfaValue> myMethodReferenceResults = new HashMap<PsiMethodReferenceExpression, DfaValue>();
        private final Map<PsiArrayAccessExpression, ThreeState> myOutOfBoundsArrayAccesses = new HashMap<PsiArrayAccessExpression, ThreeState>();
        private final List<PsiExpression> myOptionalQualifiers = new ArrayList<PsiExpression>();
        private boolean myAlwaysReturnsNotNull = true;

        private DataFlowInstructionVisitor() {
        }

        @Override
        protected void onInstructionProducesCCE(TypeCastInstruction instruction) {
            this.myCCEInstructions.add(instruction);
        }

        Collection<PsiElement> getProblems(NullabilityProblem kind) {
            return ContainerUtil.filter(this.myProblems.get(kind), psiElement -> {
                StateInfo info = this.myStateInfos.get(Pair.create(kind, psiElement));
                return info.normalNpe || info.ephemeralNpe && !info.normalOk;
            });
        }

        Map<PsiMethodCallExpression, ThreeState> getOptionalCalls() {
            return this.myOptionalCalls;
        }

        Map<PsiMethodCallExpression, ThreeState> getBooleanCalls() {
            return this.myBooleanCalls;
        }

        Map<PsiMethodReferenceExpression, DfaValue> getMethodReferenceResults() {
            return this.myMethodReferenceResults;
        }

        Stream<PsiArrayAccessExpression> outOfBoundsArrayAccesses() {
            return StreamEx.ofKeys(this.myOutOfBoundsArrayAccesses, ThreeState.YES::equals);
        }

        List<PsiExpression> getOptionalQualifiers() {
            return this.myOptionalQualifiers;
        }

        Collection<PsiCall> getAlwaysFailingCalls() {
            return StreamEx.ofKeys(this.myFailingCalls, v -> v).map(MethodCallInstruction::getCallExpression).toList();
        }

        boolean isAlwaysReturnsNotNull() {
            return this.myAlwaysReturnsNotNull;
        }

        @Override
        public DfaInstructionState[] visitMethodCall(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
            PsiMethodCallExpression call = ObjectUtils.tryCast(instruction.getCallExpression(), PsiMethodCallExpression.class);
            if (call != null) {
                String methodName = call.getMethodExpression().getReferenceName();
                PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown(call.getMethodExpression().getQualifierExpression());
                if (qualifier != null && TypeUtils.isOptional(qualifier.getType())) {
                    if ("isPresent".equals(methodName) && qualifier instanceof PsiMethodCallExpression) {
                        this.myOptionalQualifiers.add(qualifier);
                    } else if (DfaOptionalSupport.isOptionalGetMethodName(methodName)) {
                        Boolean fact = memState.getValueFact(DfaFactType.OPTIONAL_PRESENCE, memState.peek());
                        ThreeState state = fact == null ? ThreeState.UNSURE : ThreeState.fromBoolean(fact);
                        this.myOptionalCalls.merge(call, state, ThreeState::merge);
                    }
                }
            }
            DfaInstructionState[] states = super.visitMethodCall(instruction, runner, memState);
            if (DataFlowInstructionVisitor.hasNonTrivialFailingContracts(instruction)) {
                DfaConstValue fail = runner.getFactory().getConstFactory().getContractFail();
                boolean allFail = Arrays.stream(states).allMatch(s -> s.getMemoryState().peek() == fail);
                this.myFailingCalls.merge(instruction, allFail, Boolean::logicalAnd);
            }
            this.handleBooleanCalls(instruction, states);
            return states;
        }

        void handleBooleanCalls(MethodCallInstruction instruction, DfaInstructionState[] states) {
            if (!DataFlowInstructionVisitor.hasNonTrivialBooleanContracts(instruction)) {
                return;
            }
            PsiMethod method = instruction.getTargetMethod();
            if (method == null || !ControlFlowAnalyzer.isPure(method)) {
                return;
            }
            PsiMethodCallExpression call = ObjectUtils.tryCast(instruction.getCallExpression(), PsiMethodCallExpression.class);
            if (call == null || this.myBooleanCalls.get(call) == ThreeState.UNSURE) {
                return;
            }
            PsiElement parent = call.getParent();
            if (parent instanceof PsiExpressionStatement) {
                return;
            }
            if (parent instanceof PsiLambdaExpression && PsiType.VOID.equals(LambdaUtil.getFunctionalInterfaceReturnType((PsiLambdaExpression)parent))) {
                return;
            }
            for (DfaInstructionState s : states) {
                Object value;
                DfaValue val = s.getMemoryState().peek();
                ThreeState state = ThreeState.UNSURE;
                if (val instanceof DfaConstValue && (value = ((DfaConstValue)val).getValue()) instanceof Boolean) {
                    state = ThreeState.fromBoolean((Boolean)value);
                }
                this.myBooleanCalls.merge(call, state, ThreeState::merge);
            }
        }

        @Override
        protected void processArrayAccess(PsiArrayAccessExpression expression, boolean alwaysOutOfBounds) {
            this.myOutOfBoundsArrayAccesses.merge(expression, ThreeState.fromBoolean(alwaysOutOfBounds), ThreeState::merge);
        }

        @Override
        protected void processMethodReferenceResult(PsiMethodReferenceExpression methodRef, List<? extends MethodContract> contracts2, DfaValue res) {
            if (contracts2.stream().anyMatch(c -> !c.isTrivial())) {
                this.myMethodReferenceResults.merge(methodRef, res, (a, b) -> a == b ? a : DfaUnknownValue.getInstance());
            }
        }

        private static boolean hasNonTrivialFailingContracts(MethodCallInstruction instruction) {
            List<MethodContract> contracts2 = instruction.getContracts();
            return !contracts2.isEmpty() && contracts2.stream().anyMatch(contract -> contract.getReturnValue() == MethodContract.ValueConstraint.THROW_EXCEPTION && !contract.isTrivial());
        }

        private static boolean hasNonTrivialBooleanContracts(MethodCallInstruction instruction) {
            List<MethodContract> contracts2 = instruction.getContracts();
            return !contracts2.isEmpty() && contracts2.stream().anyMatch(contract -> (contract.getReturnValue() == MethodContract.ValueConstraint.FALSE_VALUE || contract.getReturnValue() == MethodContract.ValueConstraint.TRUE_VALUE) && !contract.isTrivial());
        }

        @Override
        protected boolean checkNotNullable(DfaMemoryState state, DfaValue value, NullabilityProblem problem, PsiElement anchor) {
            boolean ok;
            if (problem == NullabilityProblem.nullableReturn && !state.isNotNull(value)) {
                this.myAlwaysReturnsNotNull = false;
            }
            if (!(ok = super.checkNotNullable(state, value, problem, anchor)) && anchor != null) {
                this.myProblems.putValue(problem, anchor);
            }
            Pair<NullabilityProblem, PsiElement> key = Pair.create(problem, anchor);
            StateInfo info = this.myStateInfos.computeIfAbsent(key, k -> new StateInfo());
            if (state.isEphemeral() && !ok) {
                info.ephemeralNpe = true;
            } else if (!state.isEphemeral()) {
                if (ok) {
                    info.normalOk = true;
                } else {
                    info.normalNpe = true;
                }
            }
            return ok;
        }

        private static class StateInfo {
            boolean ephemeralNpe;
            boolean normalNpe;
            boolean normalOk;

            private StateInfo() {
            }
        }
    }
}

