/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.openapi.module.LoadedModuleDescription;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleDescription;
import com.intellij.openapi.module.ModuleGrouperBase;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/module/ExplicitModuleGrouper;", "Lcom/intellij/openapi/module/ModuleGrouperBase;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/intellij/openapi/module/ModifiableModuleModel;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/ModifiableModuleModel;)V", "getGroupPath", "", "", "module", "Lcom/intellij/openapi/module/Module;", "description", "Lcom/intellij/openapi/module/ModuleDescription;", "getGroupPathByModuleName", "name", "getModuleAsGroupPath", "", "getShortenedNameByFullModuleName", "projectModel-api"})
final class ExplicitModuleGrouper
extends ModuleGrouperBase {
    @Override
    @NotNull
    public List<String> getGroupPath(@NotNull Module module) {
        List<String> list;
        String[] path;
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        String[] stringArray = path = this.getModel() != null ? this.getModel().getModuleGroupPath(module) : ModuleManager.getInstance(this.getProject()).getModuleGroupPath(module);
        if (path != null) {
            List<String> list2 = Arrays.asList(Arrays.copyOf(path, path.length));
            list = list2;
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"Arrays.asList(*path)");
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<String> getGroupPath(@NotNull ModuleDescription description) {
        List<String> list;
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        ModuleDescription moduleDescription = description;
        if (moduleDescription instanceof LoadedModuleDescription) {
            Module module = ((LoadedModuleDescription)description).getModule();
            Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"description.module");
            list = this.getGroupPath(module);
        } else if (moduleDescription instanceof UnloadedModuleDescription) {
            List<String> list2 = ((UnloadedModuleDescription)description).getGroupPath();
            list = list2;
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"description.groupPath");
        } else {
            throw (Throwable)new IllegalArgumentException(description.getClass().getName());
        }
        return list;
    }

    @Override
    @NotNull
    public String getShortenedNameByFullModuleName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return name;
    }

    @Override
    @NotNull
    public List<String> getGroupPathByModuleName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return CollectionsKt.emptyList();
    }

    @Nullable
    public Void getModuleAsGroupPath(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return null;
    }

    @Nullable
    public Void getModuleAsGroupPath(@NotNull ModuleDescription description) {
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        return null;
    }

    public ExplicitModuleGrouper(@NotNull Project project, @Nullable ModifiableModuleModel model) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        super(project, model);
    }
}

