/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.compiler.CompilerDirectHierarchyInfo;
import com.intellij.compiler.CompilerReferenceService;
import com.intellij.concurrency.JobLauncher;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.impl.java.stubs.index.JavaAnonymousClassBaseRefOccurenceIndex;
import com.intellij.psi.impl.java.stubs.index.JavaSuperClassNameOccurenceIndex;
import com.intellij.psi.impl.search.HighlightingCaches;
import com.intellij.psi.impl.search.JavaClassInheritorsSearcher;
import com.intellij.psi.impl.search.StubHierarchyInheritorSearcher;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class JavaDirectInheritorsSearcher
implements QueryExecutor<PsiClass, DirectClassInheritorsSearch.SearchParameters> {
    @Override
    public boolean execute(@NotNull DirectClassInheritorsSearch.SearchParameters parameters, @NotNull Processor<PsiClass> consumer) {
        SearchScope useScope;
        SearchScope scope;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "execute"));
        }
        PsiClass baseClass = JavaDirectInheritorsSearcher.getClassToSearch(parameters);
        assert (parameters.isCheckInheritance());
        Project project = PsiUtilCore.getProjectInReadAction(baseClass);
        if (JavaClassInheritorsSearcher.isJavaLangObject(baseClass)) {
            SearchScope useScope2 = ReadAction.compute(baseClass::getUseScope);
            return AllClassesSearch.search(useScope2, project).forEach(psiClass -> {
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$execute$0"));
                }
                ProgressManager.checkCanceled();
                if (psiClass.isInterface()) {
                    return consumer.process((PsiClass)psiClass);
                }
                PsiClass superClass = psiClass.getSuperClass();
                return superClass == null || !JavaClassInheritorsSearcher.isJavaLangObject(superClass) || consumer.process((PsiClass)psiClass);
            });
        }
        CompilerDirectHierarchyInfo info = JavaDirectInheritorsSearcher.performSearchUsingCompilerIndices(parameters, parameters.getScope(), project);
        if (info == null) {
            scope = parameters.getScope();
            useScope = ReadAction.compute(baseClass::getUseScope);
        } else {
            if (!JavaDirectInheritorsSearcher.processInheritorCandidates(info.getHierarchyChildren(), consumer, parameters.includeAnonymous())) {
                return false;
            }
            scope = ReadAction.compute(() -> {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$execute$1"));
                }
                return parameters.getScope().intersectWith(info.getDirtyScope());
            });
            useScope = ReadAction.compute(() -> baseClass.getUseScope().intersectWith(info.getDirtyScope()));
        }
        PsiClass[] cache = JavaDirectInheritorsSearcher.getOrCalculateDirectSubClasses(project, baseClass, useScope);
        if (cache.length == 0) {
            return true;
        }
        VirtualFile baseClassJarFile = null;
        int groupStart = 0;
        boolean sameJarClassFound = false;
        String currentFQN = null;
        boolean[] isOutOfScope = new boolean[cache.length];
        for (int i2 = 0; i2 <= cache.length; ++i2) {
            String fqn;
            PsiClass subClass;
            ProgressManager.checkCanceled();
            PsiClass psiClass2 = subClass = i2 == cache.length ? null : cache[i2];
            if (subClass instanceof PsiAnonymousClass && !parameters.includeAnonymous()) {
                return true;
            }
            if (i2 != cache.length && !JavaDirectInheritorsSearcher.isInScope(scope, subClass)) {
                isOutOfScope[i2] = true;
                continue;
            }
            String string = fqn = i2 == cache.length ? null : ReadAction.compute(subClass::getQualifiedName);
            if (currentFQN != null && Comparing.equal(fqn, currentFQN)) {
                boolean fromSameJar;
                VirtualFile currentJarFile = JavaDirectInheritorsSearcher.getJarFile(subClass);
                if (baseClassJarFile == null) {
                    baseClassJarFile = JavaDirectInheritorsSearcher.getJarFile(baseClass);
                }
                if (!(fromSameJar = Comparing.equal(currentJarFile, baseClassJarFile))) continue;
                if (!consumer.process(subClass)) {
                    return false;
                }
                sameJarClassFound = true;
                continue;
            }
            currentFQN = fqn;
            if (!sameJarClassFound) {
                for (int g = groupStart; g < i2; ++g) {
                    PsiClass subClassCandidate;
                    ProgressManager.checkCanceled();
                    if (isOutOfScope[g] || consumer.process(subClassCandidate = cache[g])) continue;
                    return false;
                }
            }
            groupStart = i2;
            sameJarClassFound = false;
        }
        return true;
    }

    private static PsiClass getClassToSearch(@NotNull DirectClassInheritorsSearch.SearchParameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "getClassToSearch"));
        }
        return ReadAction.compute(() -> {
            if (parameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$getClassToSearch$3"));
            }
            return (PsiClass)PsiUtil.preferCompiledElement(parameters.getClassToProcess());
        });
    }

    private static boolean isInScope(@NotNull SearchScope scope, @NotNull PsiClass subClass) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "isInScope"));
        }
        if (subClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "isInScope"));
        }
        return ReadAction.compute(() -> {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$isInScope$4"));
            }
            if (subClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$isInScope$4"));
            }
            return PsiSearchScopeUtil.isInScope(scope, (PsiElement)subClass);
        });
    }

    @NotNull
    private static PsiClass[] getOrCalculateDirectSubClasses(@NotNull Project project, @NotNull PsiClass baseClass, @NotNull SearchScope useScope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "getOrCalculateDirectSubClasses"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "getOrCalculateDirectSubClasses"));
        }
        if (useScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "useScope", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "getOrCalculateDirectSubClasses"));
        }
        ConcurrentMap<PsiClass, PsiClass[]> map = HighlightingCaches.getInstance((Project)project).DIRECT_SUB_CLASSES;
        PsiClass[] cache = (PsiClass[])map.get(baseClass);
        if (cache != null) {
            if (cache == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "getOrCalculateDirectSubClasses"));
            }
            return cache;
        }
        String baseClassName = ReadAction.compute(baseClass::getName);
        if (StringUtil.isEmpty(baseClassName)) {
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "getOrCalculateDirectSubClasses"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        cache = JavaDirectInheritorsSearcher.calculateDirectSubClasses(project, baseClass, baseClassName, useScope);
        if (ReadAction.compute(baseClass::isPhysical).booleanValue()) {
            cache = ConcurrencyUtil.cacheOrGet(map, baseClass, cache);
        }
        if (cache == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "getOrCalculateDirectSubClasses"));
        }
        return cache;
    }

    private static <T> boolean processConcurrentlyIfTooMany(@NotNull Collection<T> collection, @NotNull Processor<? super T> processor) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "processConcurrentlyIfTooMany"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "processConcurrentlyIfTooMany"));
        }
        int size = collection.size();
        if (size == 0) {
            return true;
        }
        if (size > 100) {
            return JobLauncher.getInstance().invokeConcurrentlyUnderProgress(new ArrayList<T>(collection), ProgressIndicatorProvider.getGlobalProgressIndicator(), true, processor);
        }
        return ContainerUtil.process(collection, processor);
    }

    @NotNull
    private static PsiClass[] calculateDirectSubClasses(@NotNull Project project, @NotNull PsiClass baseClass, @NotNull String baseClassName, @NotNull SearchScope useScope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "calculateDirectSubClasses"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "calculateDirectSubClasses"));
        }
        if (baseClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClassName", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "calculateDirectSubClasses"));
        }
        if (useScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "useScope", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "calculateDirectSubClasses"));
        }
        DumbService dumbService = DumbService.getInstance(project);
        GlobalSearchScope globalUseScope = dumbService.runReadActionInSmartMode(() -> {
            if (useScope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "useScope", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$calculateDirectSubClasses$5"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$calculateDirectSubClasses$5"));
            }
            return StubHierarchyInheritorSearcher.restrictScope(GlobalSearchScopeUtil.toGlobalSearchScope(useScope, project));
        });
        Collection candidates = dumbService.runReadActionInSmartMode(() -> {
            if (baseClassName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClassName", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$calculateDirectSubClasses$6"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$calculateDirectSubClasses$6"));
            }
            return JavaSuperClassNameOccurenceIndex.getInstance().get(baseClassName, project, globalUseScope);
        });
        HashMap classesWithFqn = new HashMap();
        JavaDirectInheritorsSearcher.processConcurrentlyIfTooMany(candidates, referenceList -> {
            if (baseClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$calculateDirectSubClasses$8"));
            }
            ProgressManager.checkCanceled();
            ApplicationManager.getApplication().runReadAction(() -> {
                if (baseClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$null$7"));
                }
                PsiClass candidate = (PsiClass)referenceList.getParent();
                boolean isInheritor = candidate.isInheritor(baseClass, false);
                if (isInheritor) {
                    String fqn = candidate.getQualifiedName();
                    Map map = classesWithFqn;
                    synchronized (map) {
                        Object value = classesWithFqn.get(fqn);
                        if (value == null) {
                            classesWithFqn.put(fqn, candidate);
                        } else if (value instanceof PsiClass) {
                            ArrayList<PsiClass> list = new ArrayList<PsiClass>();
                            list.add((PsiClass)value);
                            list.add(candidate);
                            classesWithFqn.put(fqn, list);
                        } else {
                            List list = (List)value;
                            list.add(candidate);
                        }
                    }
                }
            });
            return true;
        });
        ArrayList<PsiClass> result = new ArrayList<PsiClass>();
        for (Object value : classesWithFqn.values()) {
            if (value instanceof PsiClass) {
                result.add((PsiClass)value);
                continue;
            }
            List list = (List)value;
            result.addAll(list);
        }
        Collection anonymousCandidates = dumbService.runReadActionInSmartMode(() -> {
            if (baseClassName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClassName", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$calculateDirectSubClasses$9"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$calculateDirectSubClasses$9"));
            }
            return JavaAnonymousClassBaseRefOccurenceIndex.getInstance().get(baseClassName, project, globalUseScope);
        });
        JavaDirectInheritorsSearcher.processConcurrentlyIfTooMany(anonymousCandidates, candidate -> {
            if (baseClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$calculateDirectSubClasses$11"));
            }
            boolean isInheritor = dumbService.runReadActionInSmartMode(() -> {
                if (baseClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$null$10"));
                }
                return candidate.isInheritor(baseClass, false);
            });
            if (isInheritor) {
                List list = result;
                synchronized (list) {
                    result.add((PsiClass)candidate);
                }
            }
            return true;
        });
        boolean isEnum = ReadAction.compute(baseClass::isEnum);
        if (isEnum) {
            PsiField[] fields;
            for (PsiField field : fields = ReadAction.compute(baseClass::getFields)) {
                ProgressManager.checkCanceled();
                if (!(field instanceof PsiEnumConstant)) continue;
                PsiEnumConstantInitializer initializingClass = ReadAction.compute(((PsiEnumConstant)field)::getInitializingClass);
                if (initializingClass == null) continue;
                result.add(initializingClass);
            }
        }
        PsiClass[] psiClassArray = result.isEmpty() ? PsiClass.EMPTY_ARRAY : result.toArray(new PsiClass[result.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "calculateDirectSubClasses"));
        }
        return psiClassArray;
    }

    private static VirtualFile getJarFile(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "getJarFile"));
        }
        return ReadAction.compute(() -> {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$getJarFile$12"));
            }
            return PsiUtil.getJarFile(aClass);
        });
    }

    private static CompilerDirectHierarchyInfo performSearchUsingCompilerIndices(@NotNull DirectClassInheritorsSearch.SearchParameters parameters, @NotNull SearchScope useScope, @NotNull Project project) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "performSearchUsingCompilerIndices"));
        }
        if (useScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "useScope", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "performSearchUsingCompilerIndices"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "performSearchUsingCompilerIndices"));
        }
        if (!(useScope instanceof GlobalSearchScope)) {
            return null;
        }
        SearchScope scope = parameters.getScope();
        if (!(scope instanceof GlobalSearchScope)) {
            return null;
        }
        CompilerReferenceService compilerReferenceService = CompilerReferenceService.getInstance(project);
        return compilerReferenceService.getDirectInheritors(JavaDirectInheritorsSearcher.getClassToSearch(parameters), (GlobalSearchScope)useScope, (GlobalSearchScope)scope, JavaFileType.INSTANCE);
    }

    private static boolean processInheritorCandidates(@NotNull Stream<PsiElement> classStream, @NotNull Processor<PsiClass> consumer, boolean acceptAnonymous) {
        if (classStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classStream", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "processInheritorCandidates"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "processInheritorCandidates"));
        }
        if (!acceptAnonymous) {
            classStream = classStream.filter(c -> !(c instanceof PsiAnonymousClass));
        }
        return ContainerUtil.process(classStream.iterator(), e -> {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$processInheritorCandidates$14"));
            }
            ProgressManager.checkCanceled();
            PsiClass c = (PsiClass)e;
            return consumer.process(c);
        });
    }
}

