/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.impl.search.JavaSourceFilterScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StringStubIndexExtension;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class JavaModuleNameIndex
extends StringStubIndexExtension<PsiJavaModule> {
    private static final JavaModuleNameIndex ourInstance = new JavaModuleNameIndex();
    private static final Pattern MULTI_RESOLVE_VERSION = Pattern.compile("/META-INF/versions/([^/]+)/module-info.class");

    public static JavaModuleNameIndex getInstance() {
        return ourInstance;
    }

    @Override
    public int getVersion() {
        return super.getVersion() + (FileBasedIndex.ourEnableTracingOfKeyHashToVirtualFileMapping ? 2 : 0);
    }

    @Override
    @NotNull
    public StubIndexKey<String, PsiJavaModule> getKey() {
        StubIndexKey<String, PsiJavaModule> stubIndexKey = JavaStubIndexKeys.MODULE_NAMES;
        if (stubIndexKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/index/JavaModuleNameIndex", "getKey"));
        }
        return stubIndexKey;
    }

    @Override
    public Collection<PsiJavaModule> get(@NotNull String name, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/java/stubs/index/JavaModuleNameIndex", "get"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/java/stubs/index/JavaModuleNameIndex", "get"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/java/stubs/index/JavaModuleNameIndex", "get"));
        }
        Collection<PsiJavaModule> modules = StubIndex.getElements(this.getKey(), name, project, new JavaSourceFilterScope(scope), PsiJavaModule.class);
        if (modules.size() > 1) {
            modules = JavaModuleNameIndex.filterVersions(project, modules);
        }
        return modules;
    }

    private static Collection<PsiJavaModule> filterVersions(Project project, Collection<PsiJavaModule> modules) {
        HashMap<VirtualFile, PsiJavaModule> filter = ContainerUtil.newHashMap();
        HashSet screened = ContainerUtil.newHashSet();
        ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance(project);
        for (PsiJavaModule module2 : modules) {
            VirtualFile classRoot;
            VirtualFile file = module2.getContainingFile().getVirtualFile();
            if (!index.isInLibraryClasses(file) || (classRoot = index.getClassRootForFile(file)) == null) continue;
            PsiJavaModule previous = (PsiJavaModule)filter.get(classRoot);
            if (previous == null) {
                filter.put(classRoot, module2);
                continue;
            }
            if (StringUtil.compareVersionNumbers(JavaModuleNameIndex.fileVersion(file), JavaModuleNameIndex.fileVersion(previous.getContainingFile().getVirtualFile())) < 0) {
                filter.put(classRoot, module2);
                screened.add(previous);
                continue;
            }
            screened.add(module2);
        }
        return screened.isEmpty() ? modules : (Collection)modules.stream().filter(module -> !screened.contains(module)).collect(Collectors.toList());
    }

    private static String fileVersion(VirtualFile file) {
        Matcher matcher = MULTI_RESOLVE_VERSION.matcher(file.getPath());
        return matcher.find() ? matcher.group(1) : "0";
    }

    @Override
    public boolean traceKeyHashToVirtualFileMapping() {
        return FileBasedIndex.ourEnableTracingOfKeyHashToVirtualFileMapping;
    }
}

