/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.html.dtd;

import com.intellij.html.RelaxedHtmlNSDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.SimpleFieldCache;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.html.dtd.HtmlElementDescriptorImpl;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.TypeDescriptor;
import com.intellij.xml.impl.schema.XmlNSTypeDescriptorProvider;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlNSDescriptorImpl
implements XmlNSDescriptor,
DumbAware,
XmlNSTypeDescriptorProvider {
    private final XmlNSDescriptor myDelegate;
    private final boolean myRelaxed;
    private final boolean myCaseSensitive;
    private static final SimpleFieldCache<Map<String, XmlElementDescriptor>, HtmlNSDescriptorImpl> myCachedDeclsCache = new SimpleFieldCache<Map<String, XmlElementDescriptor>, HtmlNSDescriptorImpl>(){

        @Override
        protected Map<String, XmlElementDescriptor> compute(HtmlNSDescriptorImpl htmlNSDescriptor) {
            return htmlNSDescriptor.doBuildCachedMap();
        }

        @Override
        protected Map<String, XmlElementDescriptor> getValue(HtmlNSDescriptorImpl htmlNSDescriptor) {
            return htmlNSDescriptor.myCachedDecls;
        }

        @Override
        protected void putValue(Map<String, XmlElementDescriptor> map, HtmlNSDescriptorImpl htmlNSDescriptor) {
            htmlNSDescriptor.myCachedDecls = map;
        }
    };
    private volatile Map<String, XmlElementDescriptor> myCachedDecls;

    public HtmlNSDescriptorImpl(XmlNSDescriptor _delegate) {
        this(_delegate, _delegate instanceof RelaxedHtmlNSDescriptor, false);
    }

    public HtmlNSDescriptorImpl(XmlNSDescriptor _delegate, boolean relaxed, boolean caseSensitive) {
        this.myDelegate = _delegate;
        this.myRelaxed = relaxed;
        this.myCaseSensitive = caseSensitive;
    }

    public static XmlAttributeDescriptor[] getCommonAttributeDescriptors(XmlTag context) {
        XmlNSDescriptor nsDescriptor;
        XmlNSDescriptor xmlNSDescriptor = nsDescriptor = context != null ? context.getNSDescriptor(context.getNamespace(), false) : null;
        if (nsDescriptor instanceof HtmlNSDescriptorImpl) {
            XmlElementDescriptor descriptor = ((HtmlNSDescriptorImpl)nsDescriptor).getElementDescriptorByName("div");
            XmlElementDescriptor xmlElementDescriptor = descriptor = descriptor == null ? ((HtmlNSDescriptorImpl)nsDescriptor).getElementDescriptorByName("span") : descriptor;
            if (descriptor != null) {
                return descriptor.getAttributesDescriptors(context);
            }
        }
        return XmlAttributeDescriptor.EMPTY;
    }

    private Map<String, XmlElementDescriptor> buildDeclarationMap() {
        return myCachedDeclsCache.get(this);
    }

    private HashMap<String, XmlElementDescriptor> doBuildCachedMap() {
        XmlElementDescriptor[] elements;
        HashMap<String, XmlElementDescriptor> decls = new HashMap<String, XmlElementDescriptor>();
        for (XmlElementDescriptor element : elements = this.myDelegate == null ? XmlElementDescriptor.EMPTY_ARRAY : this.myDelegate.getRootElementsDescriptors(null)) {
            decls.put(element.getName(), new HtmlElementDescriptorImpl(element, this.myRelaxed, this.myCaseSensitive));
        }
        return decls;
    }

    @Override
    public XmlElementDescriptor getElementDescriptor(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/psi/impl/source/html/dtd/HtmlNSDescriptorImpl", "getElementDescriptor"));
        }
        XmlElementDescriptor xmlElementDescriptor = this.getElementDescriptorByName(tag.getLocalName());
        if (xmlElementDescriptor == null && this.myRelaxed) {
            xmlElementDescriptor = this.myDelegate.getElementDescriptor(tag);
        }
        return xmlElementDescriptor;
    }

    private XmlElementDescriptor getElementDescriptorByName(String name) {
        if (!this.myCaseSensitive) {
            name = name.toLowerCase();
        }
        return this.buildDeclarationMap().get(name);
    }

    @Override
    @NotNull
    public XmlElementDescriptor[] getRootElementsDescriptors(@Nullable XmlDocument document) {
        XmlElementDescriptor[] xmlElementDescriptorArray = this.myDelegate == null ? XmlElementDescriptor.EMPTY_ARRAY : this.myDelegate.getRootElementsDescriptors(document);
        if (xmlElementDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/html/dtd/HtmlNSDescriptorImpl", "getRootElementsDescriptors"));
        }
        return xmlElementDescriptorArray;
    }

    @Override
    @Nullable
    public XmlFile getDescriptorFile() {
        return this.myDelegate == null ? null : this.myDelegate.getDescriptorFile();
    }

    @Override
    public PsiElement getDeclaration() {
        return this.myDelegate == null ? null : this.myDelegate.getDeclaration();
    }

    @Override
    public String getName(PsiElement context) {
        return this.myDelegate == null ? "" : this.myDelegate.getName(context);
    }

    @Override
    public String getName() {
        return this.myDelegate == null ? "" : this.myDelegate.getName();
    }

    @Override
    public void init(PsiElement element) {
        this.myDelegate.init(element);
    }

    @Override
    @NotNull
    public Object[] getDependences() {
        Object[] objectArray = this.myDelegate == null ? ArrayUtil.EMPTY_OBJECT_ARRAY : this.myDelegate.getDependences();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/html/dtd/HtmlNSDescriptorImpl", "getDependences"));
        }
        return objectArray;
    }

    @Override
    public TypeDescriptor getTypeDescriptor(String name, XmlTag context) {
        return this.myDelegate instanceof XmlNSTypeDescriptorProvider ? ((XmlNSTypeDescriptorProvider)((Object)this.myDelegate)).getTypeDescriptor(name, context) : null;
    }

    @Override
    public TypeDescriptor getTypeDescriptor(XmlTag descriptorTag) {
        return this.myDelegate instanceof XmlNSTypeDescriptorProvider ? ((XmlNSTypeDescriptorProvider)((Object)this.myDelegate)).getTypeDescriptor(descriptorTag) : null;
    }
}

