/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SmartList;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.containers.ChangeBufferingList;
import com.intellij.util.indexing.containers.IdSet;
import com.intellij.util.indexing.containers.IntIdsIterator;
import com.intellij.util.indexing.impl.DebugAssertions;
import com.intellij.util.indexing.impl.FileId2ValueMapping;
import com.intellij.util.indexing.impl.InvertedIndexValueIterator;
import com.intellij.util.indexing.impl.UpdatableValueContainer;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectObjectProcedure;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ValueContainerImpl<Value>
extends UpdatableValueContainer<Value>
implements Cloneable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.indexing.impl.ValueContainerImpl");
    private static final Object myNullValue = new Object();
    private Object myInputIdMapping;
    private Object myInputIdMappingValue;
    static final ThreadLocal<IndexId> ourDebugIndexInfo = new ThreadLocal();
    private static final EmptyValueIterator emptyIterator = new EmptyValueIterator();
    private static final ValueContainer.IntIterator EMPTY_ITERATOR = new IntIdsIterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public int next() {
            return 0;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean hasAscendingOrder() {
            return true;
        }

        @Override
        public IntIdsIterator createCopyInInitialState() {
            return this;
        }
    };
    static final int NUMBER_OF_VALUES_THRESHOLD = 20;
    private static final ValueContainer.IntPredicate EMPTY_PREDICATE = new ValueContainer.IntPredicate(){

        @Override
        public boolean contains(int id) {
            return false;
        }
    };

    ValueContainerImpl() {
    }

    @Override
    public void addValue(int inputId, Value value) {
        Object fileSetObject = this.getFileSetObject(value);
        if (fileSetObject == null) {
            this.attachFileSetForNewValue(value, inputId);
        } else if (fileSetObject instanceof Integer) {
            ChangeBufferingList list = new ChangeBufferingList();
            list.add((Integer)fileSetObject);
            list.add(inputId);
            this.resetFileSetForValue(value, list);
        } else {
            ((ChangeBufferingList)fileSetObject).add(inputId);
        }
    }

    private void resetFileSetForValue(Value value, Object fileSet) {
        if (value == null) {
            value = myNullValue;
        }
        if (!(this.myInputIdMapping instanceof THashMap)) {
            this.myInputIdMappingValue = fileSet;
        } else {
            ((THashMap)this.myInputIdMapping).put(value, fileSet);
        }
    }

    @Override
    public int size() {
        return this.myInputIdMapping != null ? (this.myInputIdMapping instanceof THashMap ? ((THashMap)this.myInputIdMapping).size() : 1) : 0;
    }

    @Override
    public void removeAssociatedValue(int inputId) {
        if (this.myInputIdMapping == null) {
            return;
        }
        SmartList<Object> fileSetObjects = null;
        SmartList valueObjects = null;
        ValueContainer.ValueIterator valueIterator = this.getValueIterator();
        while (valueIterator.hasNext()) {
            Object value = valueIterator.next();
            if (!valueIterator.getValueAssociationPredicate().contains(inputId)) continue;
            if (fileSetObjects == null) {
                fileSetObjects = new SmartList<Object>();
                valueObjects = new SmartList();
            } else if (DebugAssertions.DEBUG) {
                LOG.error("Expected only one value per-inputId for " + ourDebugIndexInfo.get(), String.valueOf(fileSetObjects.get(0)), String.valueOf(value));
            }
            fileSetObjects.add(valueIterator.getFileSetObject());
            valueObjects.add(value);
        }
        if (fileSetObjects != null) {
            int len = valueObjects.size();
            for (int i2 = 0; i2 < len; ++i2) {
                this.removeValue(inputId, fileSetObjects.get(i2), valueObjects.get(i2));
            }
        }
    }

    void removeValue(int inputId, Value value) {
        this.removeValue(inputId, this.getFileSetObject(value), value);
    }

    private void removeValue(int inputId, Object fileSet, Value value) {
        if (fileSet == null) {
            return;
        }
        if (fileSet instanceof ChangeBufferingList) {
            ChangeBufferingList changesList = (ChangeBufferingList)fileSet;
            changesList.remove(inputId);
            if (!changesList.isEmpty()) {
                return;
            }
        } else if (fileSet instanceof Integer && (Integer)fileSet != inputId) {
            return;
        }
        if (!(this.myInputIdMapping instanceof THashMap)) {
            this.myInputIdMapping = null;
            this.myInputIdMappingValue = null;
        } else {
            THashMap mapping = (THashMap)this.myInputIdMapping;
            mapping.remove(value);
            if (mapping.size() == 1) {
                this.myInputIdMapping = mapping.keySet().iterator().next();
                this.myInputIdMappingValue = mapping.get(this.myInputIdMapping);
            }
        }
    }

    @Override
    @NotNull
    public InvertedIndexValueIterator<Value> getValueIterator() {
        if (this.myInputIdMapping != null) {
            if (!(this.myInputIdMapping instanceof THashMap)) {
                InvertedIndexValueIterator invertedIndexValueIterator = new InvertedIndexValueIterator<Value>(){
                    private Value value;
                    {
                        this.value = ValueContainerImpl.this.myInputIdMapping;
                    }

                    @Override
                    @NotNull
                    public ValueContainer.IntIterator getInputIdsIterator() {
                        ValueContainer.IntIterator intIterator = ValueContainerImpl.getIntIteratorOutOfFileSetObject(this.getFileSetObject());
                        if (intIterator == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/impl/ValueContainerImpl$1", "getInputIdsIterator"));
                        }
                        return intIterator;
                    }

                    @Override
                    @NotNull
                    public ValueContainer.IntPredicate getValueAssociationPredicate() {
                        ValueContainer.IntPredicate intPredicate = ValueContainerImpl.getPredicateOutOfFileSetObject(this.getFileSetObject());
                        if (intPredicate == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/impl/ValueContainerImpl$1", "getValueAssociationPredicate"));
                        }
                        return intPredicate;
                    }

                    @Override
                    public Object getFileSetObject() {
                        return ValueContainerImpl.this.myInputIdMappingValue;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.value != null;
                    }

                    @Override
                    public Value next() {
                        Object next = this.value;
                        if (next == myNullValue) {
                            next = null;
                        }
                        this.value = null;
                        return next;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
                if (invertedIndexValueIterator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/impl/ValueContainerImpl", "getValueIterator"));
                }
                return invertedIndexValueIterator;
            }
            InvertedIndexValueIterator invertedIndexValueIterator = new InvertedIndexValueIterator<Value>(){
                private Value current;
                private Object currentValue;
                private final THashMap<Value, Object> myMapping;
                private final Iterator<Value> iterator;
                {
                    this.myMapping = (THashMap)ValueContainerImpl.this.myInputIdMapping;
                    this.iterator = this.myMapping.keySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public Value next() {
                    Object next = this.current = this.iterator.next();
                    this.currentValue = this.myMapping.get(next);
                    if (next == myNullValue) {
                        next = null;
                    }
                    return next;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                @NotNull
                public ValueContainer.IntIterator getInputIdsIterator() {
                    ValueContainer.IntIterator intIterator = ValueContainerImpl.getIntIteratorOutOfFileSetObject(this.getFileSetObject());
                    if (intIterator == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/impl/ValueContainerImpl$2", "getInputIdsIterator"));
                    }
                    return intIterator;
                }

                @Override
                @NotNull
                public ValueContainer.IntPredicate getValueAssociationPredicate() {
                    ValueContainer.IntPredicate intPredicate = ValueContainerImpl.getPredicateOutOfFileSetObject(this.getFileSetObject());
                    if (intPredicate == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/impl/ValueContainerImpl$2", "getValueAssociationPredicate"));
                    }
                    return intPredicate;
                }

                @Override
                public Object getFileSetObject() {
                    if (this.current == null) {
                        throw new IllegalStateException();
                    }
                    return this.currentValue;
                }
            };
            if (invertedIndexValueIterator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/impl/ValueContainerImpl", "getValueIterator"));
            }
            return invertedIndexValueIterator;
        }
        EmptyValueIterator emptyValueIterator = emptyIterator;
        if (emptyValueIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/impl/ValueContainerImpl", "getValueIterator"));
        }
        return emptyValueIterator;
    }

    @NotNull
    private static ValueContainer.IntPredicate getPredicateOutOfFileSetObject(@Nullable Object input) {
        if (input == null) {
            ValueContainer.IntPredicate intPredicate = EMPTY_PREDICATE;
            if (intPredicate == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/impl/ValueContainerImpl", "getPredicateOutOfFileSetObject"));
            }
            return intPredicate;
        }
        if (input instanceof Integer) {
            final int singleId = (Integer)input;
            ValueContainer.IntPredicate intPredicate = new ValueContainer.IntPredicate(){

                @Override
                public boolean contains(int id) {
                    return id == singleId;
                }
            };
            if (intPredicate == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/impl/ValueContainerImpl", "getPredicateOutOfFileSetObject"));
            }
            return intPredicate;
        }
        ValueContainer.IntPredicate intPredicate = ((ChangeBufferingList)input).intPredicate();
        if (intPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/impl/ValueContainerImpl", "getPredicateOutOfFileSetObject"));
        }
        return intPredicate;
    }

    @NotNull
    private static ValueContainer.IntIterator getIntIteratorOutOfFileSetObject(@Nullable Object input) {
        if (input == null) {
            ValueContainer.IntIterator intIterator = EMPTY_ITERATOR;
            if (intIterator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/impl/ValueContainerImpl", "getIntIteratorOutOfFileSetObject"));
            }
            return intIterator;
        }
        if (input instanceof Integer) {
            SingleValueIterator singleValueIterator = new SingleValueIterator((Integer)input);
            if (singleValueIterator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/impl/ValueContainerImpl", "getIntIteratorOutOfFileSetObject"));
            }
            return singleValueIterator;
        }
        IntIdsIterator intIdsIterator = ((ChangeBufferingList)input).intIterator();
        if (intIdsIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/impl/ValueContainerImpl", "getIntIteratorOutOfFileSetObject"));
        }
        return intIdsIterator;
    }

    private Object getFileSetObject(Value value) {
        if (this.myInputIdMapping == null) {
            return null;
        }
        Object object = value = value != null ? value : myNullValue;
        if (this.myInputIdMapping == value || this.myInputIdMapping.equals(value)) {
            return this.myInputIdMappingValue;
        }
        if (!(this.myInputIdMapping instanceof THashMap)) {
            return null;
        }
        return ((THashMap)this.myInputIdMapping).get(value);
    }

    public ValueContainerImpl<Value> clone() {
        try {
            ValueContainerImpl clone = (ValueContainerImpl)super.clone();
            if (this.myInputIdMapping instanceof THashMap) {
                clone.myInputIdMapping = this.mapCopy((THashMap)this.myInputIdMapping);
            } else if (this.myInputIdMappingValue instanceof ChangeBufferingList) {
                clone.myInputIdMappingValue = ((ChangeBufferingList)this.myInputIdMappingValue).clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public ValueContainerImpl<Value> copy() {
        ValueContainerImpl<Value> container = new ValueContainerImpl<Value>();
        if (this.myInputIdMapping instanceof THashMap) {
            THashMap mapping = (THashMap)this.myInputIdMapping;
            final THashMap newMapping = new THashMap(mapping.size());
            container.myInputIdMapping = newMapping;
            mapping.forEachEntry(new TObjectObjectProcedure<Value, Object>(){

                public boolean execute(Value key, Object val) {
                    if (val instanceof ChangeBufferingList) {
                        newMapping.put(key, ((ChangeBufferingList)val).clone());
                    } else {
                        newMapping.put(key, val);
                    }
                    return true;
                }
            });
        } else {
            container.myInputIdMapping = this.myInputIdMapping;
            container.myInputIdMappingValue = this.myInputIdMappingValue instanceof ChangeBufferingList ? ((ChangeBufferingList)this.myInputIdMappingValue).clone() : this.myInputIdMappingValue;
        }
        ValueContainerImpl<Value> valueContainerImpl = container;
        if (valueContainerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/impl/ValueContainerImpl", "copy"));
        }
        return valueContainerImpl;
    }

    @Nullable
    private ChangeBufferingList ensureFileSetCapacityForValue(Value value, int count) {
        if (count <= 1) {
            return null;
        }
        Object fileSetObject = this.getFileSetObject(value);
        if (fileSetObject != null) {
            if (fileSetObject instanceof Integer) {
                ChangeBufferingList list = new ChangeBufferingList(count + 1);
                list.add((Integer)fileSetObject);
                this.resetFileSetForValue(value, list);
                return list;
            }
            if (fileSetObject instanceof ChangeBufferingList) {
                ChangeBufferingList list = (ChangeBufferingList)fileSetObject;
                list.ensureCapacity(count);
                return list;
            }
            return null;
        }
        ChangeBufferingList fileSet = new ChangeBufferingList(count);
        this.attachFileSetForNewValue(value, fileSet);
        return fileSet;
    }

    private void attachFileSetForNewValue(Value value, Object fileSet) {
        Object object = value = value != null ? value : myNullValue;
        if (this.myInputIdMapping != null) {
            if (!(this.myInputIdMapping instanceof THashMap)) {
                Object oldMapping = this.myInputIdMapping;
                this.myInputIdMapping = new THashMap(2);
                ((THashMap)this.myInputIdMapping).put(oldMapping, this.myInputIdMappingValue);
                this.myInputIdMappingValue = null;
            }
            ((THashMap)this.myInputIdMapping).put(value, fileSet);
        } else {
            this.myInputIdMapping = value;
            this.myInputIdMappingValue = fileSet;
        }
    }

    @Override
    public void saveTo(DataOutput out, DataExternalizer<Value> externalizer) throws IOException {
        DataInputOutputUtil.writeINT(out, this.size());
        ValueContainer.ValueIterator valueIterator = this.getValueIterator();
        while (valueIterator.hasNext()) {
            Object value = valueIterator.next();
            externalizer.save(out, value);
            Object fileSetObject = valueIterator.getFileSetObject();
            if (fileSetObject instanceof Integer) {
                DataInputOutputUtil.writeINT(out, (Integer)fileSetObject);
                continue;
            }
            ChangeBufferingList originalInput = (ChangeBufferingList)fileSetObject;
            IntIdsIterator intIterator = originalInput.sortedIntIterator();
            if (DebugAssertions.DEBUG) {
                DebugAssertions.assertTrue(intIterator.hasAscendingOrder());
            }
            if (intIterator.size() == 1) {
                DataInputOutputUtil.writeINT(out, intIterator.next());
                continue;
            }
            DataInputOutputUtil.writeINT(out, -intIterator.size());
            IdSet checkSet = originalInput.getCheckSet();
            if (checkSet != null && checkSet.size() != intIterator.size()) {
                boolean a = true;
                assert (false);
            }
            int prev = 0;
            while (intIterator.hasNext()) {
                int fileId = intIterator.next();
                if (checkSet != null && !checkSet.contains(fileId)) {
                    boolean a = true;
                    assert (false);
                }
                DataInputOutputUtil.writeINT(out, fileId - prev);
                prev = fileId;
            }
        }
    }

    public void readFrom(DataInputStream stream, DataExternalizer<Value> externalizer) throws IOException {
        FileId2ValueMapping<Value> mapping = null;
        while (stream.available() > 0) {
            int valueCount = DataInputOutputUtil.readINT(stream);
            if (valueCount < 0) {
                boolean doCompact;
                int inputId = -valueCount;
                if (mapping == null && this.size() > 20) {
                    mapping = new FileId2ValueMapping<Value>(this);
                }
                if (mapping != null) {
                    doCompact = mapping.removeFileId(inputId);
                } else {
                    this.removeAssociatedValue(inputId);
                    doCompact = true;
                }
                if (!doCompact) continue;
                this.setNeedsCompacting(true);
                continue;
            }
            for (int valueIdx = 0; valueIdx < valueCount; ++valueIdx) {
                Value value = externalizer.read(stream);
                int idCountOrSingleValue = DataInputOutputUtil.readINT(stream);
                if (idCountOrSingleValue > 0) {
                    this.addValue(idCountOrSingleValue, value);
                    if (mapping == null) continue;
                    mapping.associateFileIdToValue(idCountOrSingleValue, value);
                    continue;
                }
                idCountOrSingleValue = -idCountOrSingleValue;
                ChangeBufferingList changeBufferingList = this.ensureFileSetCapacityForValue(value, idCountOrSingleValue);
                int prev = 0;
                for (int i2 = 0; i2 < idCountOrSingleValue; ++i2) {
                    int id = DataInputOutputUtil.readINT(stream);
                    if (changeBufferingList != null) {
                        changeBufferingList.add(prev + id);
                    } else {
                        this.addValue(prev + id, value);
                    }
                    if (mapping != null) {
                        mapping.associateFileIdToValue(prev + id, value);
                    }
                    prev += id;
                }
            }
        }
    }

    private THashMap<Value, Object> mapCopy(THashMap<Value, Object> map) {
        if (map == null) {
            return null;
        }
        final THashMap cloned = map.clone();
        cloned.forEachEntry(new TObjectObjectProcedure<Value, Object>(){

            public boolean execute(Value key, Object val) {
                if (val instanceof ChangeBufferingList) {
                    cloned.put(key, ((ChangeBufferingList)val).clone());
                }
                return true;
            }
        });
        return cloned;
    }

    private static class SingleValueIterator
    implements IntIdsIterator {
        private final int myValue;
        private boolean myValueRead = false;

        private SingleValueIterator(int value) {
            this.myValue = value;
        }

        @Override
        public boolean hasNext() {
            return !this.myValueRead;
        }

        @Override
        public int next() {
            int next = this.myValue;
            this.myValueRead = true;
            return next;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean hasAscendingOrder() {
            return true;
        }

        @Override
        public IntIdsIterator createCopyInInitialState() {
            return new SingleValueIterator(this.myValue);
        }
    }

    static class EmptyValueIterator<Value>
    extends EmptyIterator<Value>
    implements InvertedIndexValueIterator<Value> {
        EmptyValueIterator() {
        }

        @Override
        @NotNull
        public ValueContainer.IntIterator getInputIdsIterator() {
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public ValueContainer.IntPredicate getValueAssociationPredicate() {
            throw new IllegalStateException();
        }

        @Override
        public Object getFileSetObject() {
            throw new IllegalStateException();
        }
    }
}

