/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.assignment;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.NotNull;

public class AssignmentUsedAsConditionInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("assignment.used.as.condition.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/assignment/AssignmentUsedAsConditionInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("assignment.used.as.condition.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/assignment/AssignmentUsedAsConditionInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new AssignmentUsedAsConditionFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssignmentUsedAsConditionVisitor();
    }

    private static class AssignmentUsedAsConditionVisitor
    extends BaseInspectionVisitor {
        private AssignmentUsedAsConditionVisitor() {
        }

        @Override
        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/assignment/AssignmentUsedAsConditionInspection$AssignmentUsedAsConditionVisitor", "visitAssignmentExpression"));
            }
            super.visitAssignmentExpression(expression);
            if (expression.getRExpression() == null || !(expression.getLExpression() instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement parent = expression.getParent();
            if (!PsiUtil.isCondition(expression, parent)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }
    }

    private static class AssignmentUsedAsConditionFix
    extends InspectionGadgetsFix {
        private AssignmentUsedAsConditionFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("assignment.used.as.condition.replace.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/assignment/AssignmentUsedAsConditionInspection$AssignmentUsedAsConditionFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiAssignmentExpression expression = (PsiAssignmentExpression)descriptor.getPsiElement();
            PsiExpression leftExpression = expression.getLExpression();
            PsiExpression rightExpression = expression.getRExpression();
            assert (rightExpression != null);
            String newExpression = leftExpression.getText() + "==" + rightExpression.getText();
            PsiReplacementUtil.replaceExpression(expression, newExpression);
        }
    }
}

