/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.assignment;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceAssignmentWithOperatorAssignmentInspection
extends BaseInspection {
    public boolean ignoreLazyOperators = true;
    public boolean ignoreObscureOperators = false;

    @Override
    @NotNull
    public String getID() {
        if ("AssignmentReplaceableWithOperatorAssignment" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/assignment/ReplaceAssignmentWithOperatorAssignmentInspection", "getID"));
        }
        return "AssignmentReplaceableWithOperatorAssignment";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("assignment.replaceable.with.operator.assignment.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/assignment/ReplaceAssignmentWithOperatorAssignmentInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiExpression lhs = (PsiExpression)infos[0];
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)infos[1];
        String string = InspectionGadgetsBundle.message("assignment.replaceable.with.operator.assignment.problem.descriptor", ReplaceAssignmentWithOperatorAssignmentInspection.calculateReplacementExpression(lhs, polyadicExpression));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/assignment/ReplaceAssignmentWithOperatorAssignmentInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel(this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("assignment.replaceable.with.operator.assignment.ignore.conditional.operators.option", new Object[0]), "ignoreLazyOperators");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("assignment.replaceable.with.operator.assignment.ignore.obscure.operators.option", new Object[0]), "ignoreObscureOperators");
        return optionsPanel;
    }

    static String calculateReplacementExpression(PsiExpression lhs, PsiPolyadicExpression polyadicExpression) {
        PsiExpression[] operands = polyadicExpression.getOperands();
        PsiJavaToken sign = polyadicExpression.getTokenBeforeOperand(operands[1]);
        String signText = sign.getText();
        if ("&&".equals(signText)) {
            signText = "&";
        } else if ("||".equals(signText)) {
            signText = "|";
        }
        StringBuilder text2 = new StringBuilder(lhs.getText());
        text2.append(' ');
        text2.append(signText);
        text2.append("= ");
        boolean addToken = false;
        for (int i2 = 1; i2 < operands.length; ++i2) {
            PsiExpression operand = operands[i2];
            if (addToken) {
                PsiJavaToken token = polyadicExpression.getTokenBeforeOperand(operand);
                text2.append(' ');
                if (token != null) {
                    text2.append(token.getText());
                }
                text2.append(' ');
            } else {
                addToken = true;
            }
            text2.append(operand.getText());
        }
        return text2.toString();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ReplaceAssignmentWithOperatorAssignmentFix((PsiPolyadicExpression)infos[1]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReplaceAssignmentWithOperatorAssignmentVisitor();
    }

    private class ReplaceAssignmentWithOperatorAssignmentVisitor
    extends BaseInspectionVisitor {
        private ReplaceAssignmentWithOperatorAssignmentVisitor() {
        }

        @Override
        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
            if (assignment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/siyeh/ig/assignment/ReplaceAssignmentWithOperatorAssignmentInspection$ReplaceAssignmentWithOperatorAssignmentVisitor", "visitAssignmentExpression"));
            }
            super.visitAssignmentExpression(assignment);
            IElementType assignmentTokenType = assignment.getOperationTokenType();
            if (!assignmentTokenType.equals(JavaTokenType.EQ)) {
                return;
            }
            PsiExpression lhs = assignment.getLExpression();
            PsiExpression rhs = ParenthesesUtils.stripParentheses(assignment.getRExpression());
            if (rhs instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)rhs;
                PsiType castType = typeCastExpression.getType();
                if (castType == null || !castType.equals(lhs.getType())) {
                    return;
                }
                rhs = ParenthesesUtils.stripParentheses(typeCastExpression.getOperand());
            }
            if (!(rhs instanceof PsiPolyadicExpression)) {
                return;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)rhs;
            PsiExpression[] operands = polyadicExpression.getOperands();
            if (operands.length < 2) {
                return;
            }
            if (operands.length > 2 && !ParenthesesUtils.isAssociativeOperation(polyadicExpression)) {
                return;
            }
            for (PsiExpression operand : operands) {
                if (operand != null) continue;
                return;
            }
            IElementType expressionTokenType = polyadicExpression.getOperationTokenType();
            if (JavaTokenType.EQEQ.equals(expressionTokenType) || JavaTokenType.NE.equals(expressionTokenType)) {
                return;
            }
            if (ReplaceAssignmentWithOperatorAssignmentInspection.this.ignoreLazyOperators && (JavaTokenType.ANDAND.equals(expressionTokenType) || JavaTokenType.OROR.equals(expressionTokenType))) {
                return;
            }
            if (ReplaceAssignmentWithOperatorAssignmentInspection.this.ignoreObscureOperators && (JavaTokenType.XOR.equals(expressionTokenType) || JavaTokenType.PERC.equals(expressionTokenType))) {
                return;
            }
            if (!EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(lhs, operands[0])) {
                return;
            }
            this.registerError((PsiElement)assignment, lhs, polyadicExpression);
        }
    }

    private static class ReplaceAssignmentWithOperatorAssignmentFix
    extends InspectionGadgetsFix {
        private final String m_name;

        private ReplaceAssignmentWithOperatorAssignmentFix(PsiPolyadicExpression expression) {
            PsiJavaToken sign = expression.getTokenBeforeOperand(expression.getOperands()[1]);
            String signText = sign.getText();
            if ("&&".equals(signText)) {
                signText = "&";
            } else if ("||".equals(signText)) {
                signText = "|";
            }
            this.m_name = InspectionGadgetsBundle.message("assignment.replaceable.with.operator.replace.quickfix", signText);
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Simplify" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/assignment/ReplaceAssignmentWithOperatorAssignmentInspection$ReplaceAssignmentWithOperatorAssignmentFix", "getFamilyName"));
            }
            return "Simplify";
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.m_name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/assignment/ReplaceAssignmentWithOperatorAssignmentInspection$ReplaceAssignmentWithOperatorAssignmentFix", "getName"));
            }
            return string;
        }

        @Override
        public void doFix(@NotNull Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/siyeh/ig/assignment/ReplaceAssignmentWithOperatorAssignmentInspection$ReplaceAssignmentWithOperatorAssignmentFix", "doFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiAssignmentExpression)) {
                return;
            }
            PsiAssignmentExpression expression = (PsiAssignmentExpression)element;
            PsiExpression lhs = expression.getLExpression();
            PsiExpression rhs = ParenthesesUtils.stripParentheses(expression.getRExpression());
            if (rhs instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)rhs;
                PsiType castType = typeCastExpression.getType();
                if (castType == null || !castType.equals(lhs.getType())) {
                    return;
                }
                rhs = ParenthesesUtils.stripParentheses(typeCastExpression.getOperand());
            }
            if (!(rhs instanceof PsiPolyadicExpression)) {
                return;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)rhs;
            String newExpression = ReplaceAssignmentWithOperatorAssignmentInspection.calculateReplacementExpression(lhs, polyadicExpression);
            PsiReplacementUtil.replaceExpression(expression, newExpression);
        }
    }
}

