/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class FloatingPointEqualityInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("floating.point.equality.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/FloatingPointEqualityInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("floating.point.equality.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/FloatingPointEqualityInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new FloatingPointEqualityComparisonVisitor();
    }

    private static class FloatingPointEqualityComparisonVisitor
    extends BaseInspectionVisitor {
        private FloatingPointEqualityComparisonVisitor() {
        }

        @Override
        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/numeric/FloatingPointEqualityInspection$FloatingPointEqualityComparisonVisitor", "visitBinaryExpression"));
            }
            super.visitBinaryExpression(expression);
            PsiExpression rhs = expression.getROperand();
            if (rhs == null) {
                return;
            }
            if (!ComparisonUtils.isEqualityComparison(expression)) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            if (!TypeUtils.hasFloatingPointType(lhs) && !TypeUtils.hasFloatingPointType(rhs)) {
                return;
            }
            if (FloatingPointEqualityComparisonVisitor.isInfinityOrZero(lhs) || FloatingPointEqualityComparisonVisitor.isInfinityOrZero(rhs)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        private static boolean isInfinityOrZero(PsiExpression expression) {
            Object value = ExpressionUtils.computeConstantExpression(expression);
            if (value instanceof Double) {
                Double aDouble = (Double)value;
                double v = aDouble;
                return Double.isInfinite(v) || v == 0.0;
            }
            if (value instanceof Float) {
                Float aFloat = (Float)value;
                float v = aFloat.floatValue();
                return Float.isInfinite(v) || v == 0.0f;
            }
            if (value instanceof Integer) {
                Integer integer = (Integer)value;
                return integer == 0;
            }
            if (value instanceof Long) {
                Long aLong = (Long)value;
                return aLong == 0L;
            }
            return false;
        }
    }
}

