/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.dataFlow.instructions.CheckReturnValueInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ConditionalGotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ReturnInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class ContractChecker
extends DataFlowRunner {
    private final PsiMethod myMethod;
    private final StandardMethodContract myContract;
    private final Set<PsiElement> myViolations = ContainerUtil.newHashSet();
    private final Set<PsiElement> myNonViolations = ContainerUtil.newHashSet();
    private final Set<PsiElement> myFailures = ContainerUtil.newHashSet();

    private ContractChecker(PsiMethod method, StandardMethodContract contract) {
        super(false, true);
        this.myMethod = method;
        this.myContract = contract;
    }

    static Map<PsiElement, String> checkContractClause(PsiMethod method, StandardMethodContract contract, boolean ignoreAssertions) {
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return Collections.emptyMap();
        }
        ContractChecker checker = new ContractChecker(method, contract);
        PsiParameter[] parameters = method.getParameterList().getParameters();
        DfaMemoryState initialState = checker.createMemoryState();
        DfaValueFactory factory = checker.getFactory();
        for (int i2 = 0; i2 < contract.arguments.length; ++i2) {
            MethodContract.ValueConstraint constraint = contract.arguments[i2];
            DfaConstValue comparisonValue = constraint.getComparisonValue(factory);
            if (comparisonValue == null) continue;
            boolean negated = constraint.shouldUseNonEqComparison();
            DfaVariableValue dfaParam = factory.getVarFactory().createVariableValue(parameters[i2], false);
            initialState.applyCondition(factory.createCondition(dfaParam, DfaRelationValue.RelationType.equivalence(!negated), comparisonValue));
        }
        checker.analyzeMethod(body, new StandardInstructionVisitor(), ignoreAssertions, Collections.singletonList(initialState));
        return checker.getErrors();
    }

    @Override
    @NotNull
    protected DfaInstructionState[] acceptInstruction(@NotNull InstructionVisitor visitor, @NotNull DfaInstructionState instructionState) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/codeInspection/dataFlow/ContractChecker", "acceptInstruction"));
        }
        if (instructionState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instructionState", "com/intellij/codeInspection/dataFlow/ContractChecker", "acceptInstruction"));
        }
        DfaMemoryState memState = instructionState.getMemoryState();
        if (memState.isEphemeral()) {
            if (DfaInstructionState.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractChecker", "acceptInstruction"));
            }
            return DfaInstructionState.EMPTY_ARRAY;
        }
        Instruction instruction = instructionState.getInstruction();
        if (instruction instanceof CheckReturnValueInstruction) {
            PsiElement anchor = ((CheckReturnValueInstruction)instruction).getReturn();
            DfaValue retValue = memState.pop();
            if (this.breaksContract(retValue, this.myContract.returnValue, memState)) {
                this.myViolations.add(anchor);
            } else {
                this.myNonViolations.add(anchor);
            }
            DfaInstructionState[] dfaInstructionStateArray = InstructionVisitor.nextInstruction(instruction, this, memState);
            if (dfaInstructionStateArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractChecker", "acceptInstruction"));
            }
            return dfaInstructionStateArray;
        }
        if (instruction instanceof ReturnInstruction && ((ReturnInstruction)instruction).isViaException() && this.myContract.returnValue != MethodContract.ValueConstraint.NOT_NULL_VALUE) {
            ContainerUtil.addIfNotNull(this.myFailures, ((ReturnInstruction)instruction).getAnchor());
        }
        if (instruction instanceof MethodCallInstruction && ((MethodCallInstruction)instruction).getMethodType() == MethodCallInstruction.MethodType.REGULAR_METHOD_CALL && this.myContract.returnValue == MethodContract.ValueConstraint.THROW_EXCEPTION) {
            ContainerUtil.addIfNotNull(this.myFailures, ((MethodCallInstruction)instruction).getCallExpression());
            if (DfaInstructionState.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractChecker", "acceptInstruction"));
            }
            return DfaInstructionState.EMPTY_ARRAY;
        }
        if (instruction instanceof ConditionalGotoInstruction && memState.peek() == DfaUnknownValue.getInstance()) {
            if (DfaInstructionState.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractChecker", "acceptInstruction"));
            }
            return DfaInstructionState.EMPTY_ARRAY;
        }
        DfaInstructionState[] dfaInstructionStateArray = super.acceptInstruction(visitor, instructionState);
        if (dfaInstructionStateArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractChecker", "acceptInstruction"));
        }
        return dfaInstructionStateArray;
    }

    private Map<PsiElement, String> getErrors() {
        HashMap<PsiElement, String> errors = ContainerUtil.newHashMap();
        for (PsiElement element : this.myViolations) {
            if (this.myNonViolations.contains(element)) continue;
            errors.put(element, "Contract clause '" + this.myContract + "' is violated");
        }
        if (this.myContract.returnValue != MethodContract.ValueConstraint.THROW_EXCEPTION) {
            for (PsiElement element : this.myFailures) {
                errors.put(element, "Contract clause '" + this.myContract + "' is violated: exception might be thrown instead of returning " + (Object)((Object)this.myContract.returnValue));
            }
        } else if (this.myFailures.isEmpty() && errors.isEmpty()) {
            PsiIdentifier nameIdentifier = this.myMethod.getNameIdentifier();
            errors.put(nameIdentifier != null ? nameIdentifier : this.myMethod, "Contract clause '" + this.myContract + "' is violated: no exception is thrown");
        }
        return errors;
    }

    private boolean breaksContract(DfaValue retValue, MethodContract.ValueConstraint constraint, DfaMemoryState state) {
        switch (constraint) {
            case NULL_VALUE: {
                return state.isNotNull(retValue);
            }
            case NOT_NULL_VALUE: {
                return state.isNull(retValue);
            }
            case TRUE_VALUE: {
                return ContractChecker.isEquivalentTo(retValue, this.getFactory().getConstFactory().getFalse(), state);
            }
            case FALSE_VALUE: {
                return ContractChecker.isEquivalentTo(retValue, this.getFactory().getConstFactory().getTrue(), state);
            }
            case THROW_EXCEPTION: {
                return true;
            }
        }
        return false;
    }

    private static boolean isEquivalentTo(DfaValue val, DfaConstValue constValue, DfaMemoryState state) {
        return val == constValue || val instanceof DfaVariableValue && constValue == state.getConstantValue((DfaVariableValue)val);
    }
}

