/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unneededThrows;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaBatchInspectionTool;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.AllOverridingMethodsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantThrows
extends GlobalJavaBatchInspectionTool {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.unneededThrows.RedundantThrows");
    private static final String DISPLAY_NAME = InspectionsBundle.message("inspection.redundant.throws.display.name", new Object[0]);
    @NonNls
    private static final String SHORT_NAME = "RedundantThrows";

    @Override
    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor processor) {
        if (refEntity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/unneededThrows/RedundantThrows", "checkElement"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/unneededThrows/RedundantThrows", "checkElement"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/unneededThrows/RedundantThrows", "checkElement"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "com/intellij/codeInspection/unneededThrows/RedundantThrows", "checkElement"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInspection/unneededThrows/RedundantThrows", "checkElement"));
        }
        if (refEntity instanceof RefMethod) {
            RefMethod refMethod = (RefMethod)refEntity;
            if (refMethod.isSyntheticJSP()) {
                return null;
            }
            if (refMethod.hasSuperMethods()) {
                return null;
            }
            if (refMethod.isEntry()) {
                return null;
            }
            PsiClass[] unThrown = refMethod.getUnThrownExceptions();
            if (unThrown == null) {
                return null;
            }
            PsiMethod psiMethod = (PsiMethod)refMethod.getElement();
            PsiClassType[] throwsList = psiMethod.getThrowsList().getReferencedTypes();
            PsiJavaCodeReferenceElement[] throwsRefs = psiMethod.getThrowsList().getReferenceElements();
            ArrayList<ProblemDescriptor> problems = null;
            PsiManager psiManager = psiMethod.getManager();
            for (int i2 = 0; i2 < throwsList.length; ++i2) {
                PsiClassType throwsType = throwsList[i2];
                String throwsClassName = throwsType.getClassName();
                PsiJavaCodeReferenceElement throwsRef = throwsRefs[i2];
                if (ExceptionUtil.isUncheckedException(throwsType) || RedundantThrows.declaredInRemotableMethod(psiMethod, throwsType)) continue;
                for (PsiClass s : unThrown) {
                    PsiClass throwsResolvedType = throwsType.resolve();
                    if (!psiManager.areElementsEquivalent(s, throwsResolvedType)) continue;
                    if (problems == null) {
                        problems = new ArrayList<ProblemDescriptor>(1);
                    }
                    if (refMethod.isAbstract() || refMethod.getOwnerClass().isInterface()) {
                        problems.add(manager.createProblemDescriptor((PsiElement)throwsRef, InspectionsBundle.message("inspection.redundant.throws.problem.descriptor", "<code>#ref</code>"), new MyQuickFix(processor, throwsClassName), ProblemHighlightType.LIKE_UNUSED_SYMBOL, false));
                        continue;
                    }
                    if (!refMethod.getDerivedMethods().isEmpty()) {
                        problems.add(manager.createProblemDescriptor((PsiElement)throwsRef, InspectionsBundle.message("inspection.redundant.throws.problem.descriptor1", "<code>#ref</code>"), new MyQuickFix(processor, throwsClassName), ProblemHighlightType.LIKE_UNUSED_SYMBOL, false));
                        continue;
                    }
                    problems.add(manager.createProblemDescriptor((PsiElement)throwsRef, InspectionsBundle.message("inspection.redundant.throws.problem.descriptor2", "<code>#ref</code>"), new MyQuickFix(processor, throwsClassName), ProblemHighlightType.LIKE_UNUSED_SYMBOL, false));
                }
            }
            if (problems != null) {
                return problems.toArray(new CommonProblemDescriptor[problems.size()]);
            }
        }
        return null;
    }

    private static boolean declaredInRemotableMethod(PsiMethod psiMethod, PsiClassType throwsType) {
        if (!throwsType.equalsToText("java.rmi.RemoteException")) {
            return false;
        }
        PsiClass aClass = psiMethod.getContainingClass();
        if (aClass == null) {
            return false;
        }
        PsiClass remote = JavaPsiFacade.getInstance(aClass.getProject()).findClass("java.rmi.Remote", GlobalSearchScope.allScope(aClass.getProject()));
        return remote != null && aClass.isInheritor(remote, true);
    }

    @Override
    protected boolean queryExternalUsagesRequests(@NotNull RefManager manager, final @NotNull GlobalJavaInspectionContext globalContext, final @NotNull ProblemDescriptionsProcessor processor) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/unneededThrows/RedundantThrows", "queryExternalUsagesRequests"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "com/intellij/codeInspection/unneededThrows/RedundantThrows", "queryExternalUsagesRequests"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInspection/unneededThrows/RedundantThrows", "queryExternalUsagesRequests"));
        }
        manager.iterate(new RefJavaVisitor(){

            @Override
            public void visitElement(@NotNull RefEntity refEntity) {
                if (refEntity == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/unneededThrows/RedundantThrows$1", "visitElement"));
                }
                if (processor.getDescriptions(refEntity) != null) {
                    refEntity.accept(new RefJavaVisitor(){

                        @Override
                        public void visitMethod(final @NotNull RefMethod refMethod) {
                            if (refMethod == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refMethod", "com/intellij/codeInspection/unneededThrows/RedundantThrows$1$1", "visitMethod"));
                            }
                            globalContext.enqueueDerivedMethodsProcessor(refMethod, new GlobalJavaInspectionContext.DerivedMethodsProcessor(){

                                @Override
                                public boolean process(PsiMethod derivedMethod) {
                                    processor.ignoreElement(refMethod);
                                    return true;
                                }
                            });
                        }
                    });
                }
            }
        });
        return false;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = DISPLAY_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unneededThrows/RedundantThrows", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.DECLARATION_REDUNDANCY;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unneededThrows/RedundantThrows", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unneededThrows/RedundantThrows", "getShortName"));
        }
        return SHORT_NAME;
    }

    @Override
    @Nullable
    public QuickFix getQuickFix(String hint) {
        return new MyQuickFix(null, hint);
    }

    @Override
    @Nullable
    public String getHint(@NotNull QuickFix fix) {
        if (fix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fix", "com/intellij/codeInspection/unneededThrows/RedundantThrows", "getHint"));
        }
        return fix instanceof MyQuickFix ? ((MyQuickFix)fix).myHint : null;
    }

    private static class MyQuickFix
    implements LocalQuickFix {
        private final ProblemDescriptionsProcessor myProcessor;
        private final String myHint;

        public MyQuickFix(ProblemDescriptionsProcessor processor, String hint) {
            this.myProcessor = processor;
            this.myHint = hint;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message("inspection.redundant.throws.remove.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unneededThrows/RedundantThrows$MyQuickFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/unneededThrows/RedundantThrows$MyQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/unneededThrows/RedundantThrows$MyQuickFix", "applyFix"));
            }
            if (this.myProcessor != null) {
                RefMethod refMethod;
                CommonProblemDescriptor[] problems;
                RefElement refElement = (RefElement)this.myProcessor.getElement(descriptor);
                if (refElement instanceof RefMethod && refElement.isValid() && (problems = this.myProcessor.getDescriptions(refMethod = (RefMethod)refElement)) != null) {
                    this.removeExcessiveThrows(refMethod, null, problems);
                }
            } else {
                PsiMethod psiMethod = PsiTreeUtil.getParentOfType(descriptor.getPsiElement(), PsiMethod.class);
                if (psiMethod != null) {
                    this.removeExcessiveThrows(null, psiMethod, new CommonProblemDescriptor[]{descriptor});
                }
            }
        }

        private void removeExcessiveThrows(@Nullable RefMethod refMethod, @Nullable PsiModifierListOwner element, CommonProblemDescriptor[] problems) {
            try {
                PsiMethod psiMethod;
                if (element == null) {
                    LOG.assertTrue(refMethod != null);
                    psiMethod = (PsiMethod)refMethod.getElement();
                } else {
                    psiMethod = (PsiMethod)element;
                }
                if (psiMethod == null) {
                    return;
                }
                Project project = psiMethod.getProject();
                PsiManager psiManager = PsiManager.getInstance(project);
                ArrayList<PsiJavaCodeReferenceElement> refsToDelete = new ArrayList<PsiJavaCodeReferenceElement>();
                block2: for (CommonProblemDescriptor problem : problems) {
                    PsiClassType[] classTypes;
                    PsiElement psiElement = ((ProblemDescriptor)problem).getPsiElement();
                    if (psiElement instanceof PsiJavaCodeReferenceElement) {
                        PsiJavaCodeReferenceElement classRef = (PsiJavaCodeReferenceElement)psiElement;
                        PsiClassType psiType = JavaPsiFacade.getInstance(psiManager.getProject()).getElementFactory().createType(classRef);
                        MyQuickFix.removeException(refMethod, psiType, refsToDelete, psiMethod);
                        continue;
                    }
                    PsiReferenceList throwsList = psiMethod.getThrowsList();
                    for (PsiClassType classType : classTypes = throwsList.getReferencedTypes()) {
                        String text2 = classType.getClassName();
                        if (!Comparing.strEqual(this.myHint, text2)) continue;
                        MyQuickFix.removeException(refMethod, classType, refsToDelete, psiMethod);
                        continue block2;
                    }
                }
                if (!FileModificationService.getInstance().preparePsiElementsForWrite(refsToDelete)) {
                    return;
                }
                for (PsiJavaCodeReferenceElement aRefsToDelete : refsToDelete) {
                    if (!aRefsToDelete.isValid()) continue;
                    aRefsToDelete.delete();
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error(e);
            }
        }

        private static void removeException(RefMethod refMethod, PsiType exceptionType, List<PsiJavaCodeReferenceElement> refsToDelete, PsiMethod psiMethod) {
            PsiManager psiManager = psiMethod.getManager();
            PsiJavaCodeReferenceElement[] refs = psiMethod.getThrowsList().getReferenceElements();
            for (PsiJavaCodeReferenceElement ref : refs) {
                PsiClassType refType = JavaPsiFacade.getInstance(psiManager.getProject()).getElementFactory().createType(ref);
                if (!exceptionType.isAssignableFrom(refType)) continue;
                refsToDelete.add(ref);
            }
            if (refMethod != null) {
                for (RefMethod refDerived : refMethod.getDerivedMethods()) {
                    PsiModifierListOwner method = refDerived.getElement();
                    if (method == null) continue;
                    MyQuickFix.removeException(refDerived, exceptionType, refsToDelete, (PsiMethod)method);
                }
            } else {
                Query<Pair<PsiMethod, PsiMethod>> query = AllOverridingMethodsSearch.search(psiMethod.getContainingClass());
                query.forEach(pair -> {
                    if (pair.first == psiMethod) {
                        MyQuickFix.removeException(null, exceptionType, refsToDelete, (PsiMethod)pair.second);
                    }
                    return true;
                });
            }
        }
    }
}

