/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.Platform;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class CommandLineUtil {
    private static final char INESCAPABLE_QUOTE = '\uefef';
    private static final Pattern WIN_BACKSLASHES_PRECEDING_QUOTE = Pattern.compile("(\\\\+)(?=\"|$)");
    private static final Pattern WIN_CARET_SPECIAL = Pattern.compile("[&<>()@^|!%]");
    private static final Pattern WIN_QUOTE_SPECIAL = Pattern.compile("[ \t\"*?\\[{}~()']");
    private static final Pattern WIN_QUIET_COMMAND = Pattern.compile("((?:@\\s*)++)(.*)", 2);
    private static final char Q = '\"';
    private static final String QQ = "\"\"";
    public static boolean VERBOSE_COMMAND_LINE_MODE;

    @NotNull
    public static String specialQuote(@NotNull String parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/execution/CommandLineUtil", "specialQuote"));
        }
        String string = CommandLineUtil.quote(parameter, '\uefef');
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/CommandLineUtil", "specialQuote"));
        }
        return string;
    }

    @NotNull
    public static List<String> toCommandLine(@NotNull List<String> command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/execution/CommandLineUtil", "toCommandLine"));
        }
        assert (!command.isEmpty());
        List<String> list = CommandLineUtil.toCommandLine(command.get(0), command.subList(1, command.size()));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/CommandLineUtil", "toCommandLine"));
        }
        return list;
    }

    @NotNull
    public static List<String> toCommandLine(@NotNull String command, @NotNull List<String> parameters) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/execution/CommandLineUtil", "toCommandLine"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/execution/CommandLineUtil", "toCommandLine"));
        }
        List<String> list = CommandLineUtil.toCommandLine(command, parameters, Platform.current());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/CommandLineUtil", "toCommandLine"));
        }
        return list;
    }

    @NotNull
    public static List<String> toCommandLine(@NotNull String command, @NotNull List<String> parameters, @NotNull Platform platform) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/execution/CommandLineUtil", "toCommandLine"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/execution/CommandLineUtil", "toCommandLine"));
        }
        if (platform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platform", "com/intellij/execution/CommandLineUtil", "toCommandLine"));
        }
        ArrayList<String> commandLine = ContainerUtil.newArrayListWithCapacity(parameters.size() + 1);
        commandLine.add(FileUtilRt.toSystemDependentName(command, platform.fileSeparator));
        if (platform != Platform.WINDOWS) {
            for (String parameter : parameters) {
                if (CommandLineUtil.isQuoted(parameter, '\uefef')) {
                    parameter = CommandLineUtil.quote(StringUtil.unquoteString(parameter, '\uefef'), '\"');
                }
                commandLine.add(parameter);
            }
        } else {
            CommandLineUtil.addToWindowsCommandLine(parameters, commandLine);
        }
        ArrayList<String> arrayList = commandLine;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/CommandLineUtil", "toCommandLine"));
        }
        return arrayList;
    }

    private static void addToWindowsCommandLine(@NotNull List<String> parameters, @NotNull List<String> commandLine) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/execution/CommandLineUtil", "addToWindowsCommandLine"));
        }
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/CommandLineUtil", "addToWindowsCommandLine"));
        }
        String command = commandLine.get(0);
        boolean isCmdParam = CommandLineUtil.isWinShell(command);
        int cmdInvocationDepth = CommandLineUtil.isWinShellScript(command) ? 2 : (isCmdParam ? 1 : 0);
        QuoteFlag quoteFlag = new QuoteFlag(command);
        for (int i2 = 0; i2 < parameters.size(); ++i2) {
            boolean inescapableQuoting;
            String parameter = parameters.get(i2);
            boolean bl = inescapableQuoting = !(parameter = StringUtil.unquoteString(parameter, '\uefef')).equals(parameters.get(i2));
            if (parameter.isEmpty()) {
                commandLine.add(QQ);
                continue;
            }
            if (isCmdParam && parameter.startsWith("/") && parameter.length() == 2) {
                commandLine.add(parameter);
                continue;
            }
            String parameterPrefix = "";
            if (isCmdParam) {
                Matcher m = WIN_QUIET_COMMAND.matcher(parameter);
                if (m.matches()) {
                    parameterPrefix = m.group(1);
                    parameter = m.group(2);
                }
                if (parameter.equalsIgnoreCase("echo")) {
                    String parametersJoin = StringUtil.join(ContainerUtil.subList(parameters, i2), " ");
                    parameter = CommandLineUtil.escapeParameter(parametersJoin, quoteFlag.toggle(), cmdInvocationDepth, false);
                    commandLine.add(parameter);
                    break;
                }
                if (!parameter.equalsIgnoreCase("call") && ((isCmdParam = CommandLineUtil.isWinShell(parameter)) || CommandLineUtil.isWinShellScript(parameter))) {
                    ++cmdInvocationDepth;
                }
            }
            parameter = cmdInvocationDepth > 0 && !isCmdParam || inescapableQuoting ? CommandLineUtil.escapeParameter(parameter, quoteFlag, cmdInvocationDepth, !inescapableQuoting) : CommandLineUtil.backslashEscapeQuotes(parameter);
            commandLine.add(parameterPrefix + parameter);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeParameterOnWindows(@NotNull String s, boolean isWinShell) {
        boolean hadLineBreaks;
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/execution/CommandLineUtil", "escapeParameterOnWindows"));
        }
        boolean bl = hadLineBreaks = !s.equals(s = StringUtil.convertLineSeparators(s, ""));
        if (s.isEmpty()) {
            if (QQ == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/CommandLineUtil", "escapeParameterOnWindows"));
            }
            return QQ;
        }
        String ret = isWinShell ? CommandLineUtil.escapeParameter(s, new QuoteFlag(hadLineBreaks), 1, true) : CommandLineUtil.backslashEscapeQuotes(s);
        String string = hadLineBreaks ? CommandLineUtil.quote(ret, '\"') : ret;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/CommandLineUtil", "escapeParameterOnWindows"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    private static String escapeParameter(@NotNull String s, @NotNull QuoteFlag quoteFlag, int cmdInvocationDepth, boolean escapeQuotingInside) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/execution/CommandLineUtil", "escapeParameter"));
        }
        if (quoteFlag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quoteFlag", "com/intellij/execution/CommandLineUtil", "escapeParameter"));
        }
        StringBuilder sb = new StringBuilder();
        String escapingCarets = StringUtil.repeatSymbol('^', (1 << cmdInvocationDepth) - 1);
        String string = (escapeQuotingInside ? CommandLineUtil.quoteEscape(sb, s, quoteFlag, escapingCarets) : CommandLineUtil.caretEscape(sb, s, quoteFlag, escapingCarets)).toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/CommandLineUtil", "escapeParameter"));
        }
        return string;
    }

    @NotNull
    private static StringBuilder caretEscape(@NotNull StringBuilder sb, @NotNull String s, @NotNull QuoteFlag quoteFlag, @NotNull String escapingCarets) {
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/execution/CommandLineUtil", "caretEscape"));
        }
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/execution/CommandLineUtil", "caretEscape"));
        }
        if (quoteFlag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quoteFlag", "com/intellij/execution/CommandLineUtil", "caretEscape"));
        }
        if (escapingCarets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "escapingCarets", "com/intellij/execution/CommandLineUtil", "caretEscape"));
        }
        quoteFlag.toggle();
        sb.append('\"');
        int lastPos = 0;
        Matcher m = WIN_CARET_SPECIAL.matcher(s);
        while (m.find()) {
            quoteFlag.consume(s, lastPos, m.start());
            sb.append(s, lastPos, m.start());
            if (!quoteFlag.isEnabled()) {
                sb.append(escapingCarets);
            }
            sb.append(m.group());
            lastPos = m.end();
        }
        quoteFlag.consume(s, lastPos, s.length());
        sb.append(s, lastPos, s.length());
        quoteFlag.toggle();
        StringBuilder stringBuilder = sb.append('\"');
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/CommandLineUtil", "caretEscape"));
        }
        return stringBuilder;
    }

    @NotNull
    private static StringBuilder quoteEscape(@NotNull StringBuilder sb, @NotNull String s, @NotNull QuoteFlag quoteFlag, @NotNull String escapingCarets) {
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/execution/CommandLineUtil", "quoteEscape"));
        }
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/execution/CommandLineUtil", "quoteEscape"));
        }
        if (quoteFlag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quoteFlag", "com/intellij/execution/CommandLineUtil", "quoteEscape"));
        }
        if (escapingCarets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "escapingCarets", "com/intellij/execution/CommandLineUtil", "quoteEscape"));
        }
        int lastPos = 0;
        Matcher m = WIN_CARET_SPECIAL.matcher(s);
        while (m.find()) {
            quoteFlag.consume(s, lastPos, m.start());
            CommandLineUtil.appendQuoted(sb, s.substring(lastPos, m.start()));
            String specialText = m.group();
            boolean isCaret = specialText.equals("^");
            if (isCaret) {
                specialText = escapingCarets + specialText;
            }
            if (isCaret == quoteFlag.isEnabled()) {
                CommandLineUtil.appendQuoted(sb, specialText);
            } else {
                sb.append(specialText);
            }
            lastPos = m.end();
        }
        quoteFlag.consume(s, lastPos, s.length());
        CommandLineUtil.appendQuoted(sb, s.substring(lastPos));
        if (!CommandLineUtil.isQuoted(sb, '\"') && StringUtil.indexOfAny(sb, " \t") >= 0) {
            if (sb.charAt(0) != '\"') {
                sb.insert(0, QQ);
            }
            if (sb.charAt(sb.length() - 1) != '\"') {
                sb.append(QQ);
            }
        }
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/CommandLineUtil", "quoteEscape"));
        }
        return stringBuilder;
    }

    private static StringBuilder appendQuoted(@NotNull StringBuilder sb, @NotNull String s) {
        int numTrailingBackslashes;
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/execution/CommandLineUtil", "appendQuoted"));
        }
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/execution/CommandLineUtil", "appendQuoted"));
        }
        if (s.isEmpty()) {
            return sb;
        }
        if (WIN_CARET_SPECIAL.matcher(s = CommandLineUtil.backslashEscapeQuotes(s)).find()) {
            s = CommandLineUtil.quote(s, '\"');
        }
        if ((numTrailingBackslashes = CommandLineUtil.removeClosingQuote(sb)) < 0) {
            return sb.append(s);
        }
        if (WIN_BACKSLASHES_PRECEDING_QUOTE.matcher(s = StringUtil.unquoteString(s, '\"')).matches()) {
            StringUtil.repeatSymbol(sb, '\\', numTrailingBackslashes);
        }
        return sb.append(s).append('\"');
    }

    @NotNull
    @Contract(pure=true)
    private static String backslashEscapeQuotes(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/execution/CommandLineUtil", "backslashEscapeQuotes"));
        }
        assert (!s.isEmpty());
        String result = WIN_BACKSLASHES_PRECEDING_QUOTE.matcher(s).replaceAll("$1$1").replace("\"", "\\\"");
        if (!result.equals(s) || WIN_QUOTE_SPECIAL.matcher(s).find()) {
            result = CommandLineUtil.quote(result, '\"');
        }
        String string = result;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/CommandLineUtil", "backslashEscapeQuotes"));
        }
        return string;
    }

    private static int removeClosingQuote(@NotNull StringBuilder sb) {
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/execution/CommandLineUtil", "removeClosingQuote"));
        }
        if (sb.length() < 2 || sb.charAt(sb.length() - 1) != '\"') {
            return -1;
        }
        sb.setLength(sb.length() - 1);
        int numTrailingBackslashes = sb.length() - StringUtil.trimTrailing(sb, '\\').length();
        StringUtil.repeatSymbol(sb, '\\', numTrailingBackslashes / 2);
        if (numTrailingBackslashes % 2 == 1) {
            StringUtil.repeatSymbol(sb, '\\', numTrailingBackslashes / 2 + 1);
            sb.append('\"');
            return -1;
        }
        return numTrailingBackslashes / 2;
    }

    private static boolean isWinShell(@NotNull String command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/execution/CommandLineUtil", "isWinShell"));
        }
        return "cmd".equalsIgnoreCase(command) || "cmd.exe".equalsIgnoreCase(command);
    }

    private static boolean isWinShellScript(@NotNull String command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/execution/CommandLineUtil", "isWinShellScript"));
        }
        return CommandLineUtil.endsWithIgnoreCase(command, ".cmd") || CommandLineUtil.endsWithIgnoreCase(command, ".bat");
    }

    private static boolean endsWithIgnoreCase(@NotNull String str, @NotNull String suffix) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/execution/CommandLineUtil", "endsWithIgnoreCase"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/execution/CommandLineUtil", "endsWithIgnoreCase"));
        }
        return str.regionMatches(true, str.length() - suffix.length(), suffix, 0, suffix.length());
    }

    @NotNull
    private static String quote(@NotNull String s, char ch) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/execution/CommandLineUtil", "quote"));
        }
        String string = !CommandLineUtil.isQuoted(s, ch) ? ch + s + ch : s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/CommandLineUtil", "quote"));
        }
        return string;
    }

    private static boolean isQuoted(@NotNull CharSequence s, char ch) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/execution/CommandLineUtil", "isQuoted"));
        }
        return s.length() >= 2 && s.charAt(0) == ch && s.charAt(s.length() - 1) == ch;
    }

    @NotNull
    public static String extractPresentableName(@NotNull String commandLine) {
        List<String> args;
        String execName;
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/CommandLineUtil", "extractPresentableName"));
        }
        String executable = commandLine.trim();
        List<String> words = StringUtil.splitHonorQuotes(executable, ' ');
        if (words.isEmpty()) {
            execName = executable;
            args = Collections.emptyList();
        } else {
            execName = words.get(0);
            args = words.subList(1, words.size());
        }
        if (VERBOSE_COMMAND_LINE_MODE) {
            String string = StringUtil.shortenPathWithEllipsis(execName + " " + StringUtil.join(args, " "), 250);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/CommandLineUtil", "extractPresentableName"));
            }
            return string;
        }
        String string = new File(StringUtil.unquoteString(execName)).getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/CommandLineUtil", "extractPresentableName"));
        }
        return string;
    }

    public static boolean hasWinShellSpecialChars(String parameter) {
        return WIN_CARET_SPECIAL.matcher(parameter).find();
    }

    private static class QuoteFlag {
        private boolean myValue;

        public QuoteFlag(boolean value) {
            this.myValue = value;
        }

        private QuoteFlag(@NotNull CharSequence s) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/execution/CommandLineUtil$QuoteFlag", "<init>"));
            }
            this.consume(s);
        }

        public boolean isEnabled() {
            return this.myValue;
        }

        @NotNull
        public QuoteFlag toggle() {
            this.myValue = !this.myValue;
            QuoteFlag quoteFlag = this;
            if (quoteFlag == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/CommandLineUtil$QuoteFlag", "toggle"));
            }
            return quoteFlag;
        }

        @NotNull
        public QuoteFlag consume(@NotNull CharSequence s) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/execution/CommandLineUtil$QuoteFlag", "consume"));
            }
            QuoteFlag quoteFlag = this.consume(s, 0, s.length());
            if (quoteFlag == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/CommandLineUtil$QuoteFlag", "consume"));
            }
            return quoteFlag;
        }

        @NotNull
        public QuoteFlag consume(@NotNull CharSequence s, int start, int end) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/execution/CommandLineUtil$QuoteFlag", "consume"));
            }
            this.myValue ^= StringUtil.countChars(s, '\"', start, end, false) % 2 != 0;
            QuoteFlag quoteFlag = this;
            if (quoteFlag == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/CommandLineUtil$QuoteFlag", "consume"));
            }
            return quoteFlag;
        }
    }
}

