/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusFactory;
import com.intellij.util.pico.DefaultPicoContainer;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;

public class MockComponentManager
extends UserDataHolderBase
implements ComponentManager {
    private final MessageBus myMessageBus;
    private final MutablePicoContainer myPicoContainer;
    private final Map<Class, Object> myComponents;
    private final Set<Object> myDisposableComponents;
    private boolean myDisposed;

    public MockComponentManager(@Nullable PicoContainer parent, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/mock/MockComponentManager", "<init>"));
        }
        this.myMessageBus = MessageBusFactory.newMessageBus(this);
        this.myComponents = new HashMap<Class, Object>();
        this.myDisposableComponents = ContainerUtil.newConcurrentSet();
        this.myPicoContainer = new DefaultPicoContainer(parent){

            @Override
            @Nullable
            public Object getComponentInstance(Object componentKey) {
                if (MockComponentManager.this.myDisposed) {
                    throw new IllegalStateException("Cannot get " + componentKey + " from already disposed " + this);
                }
                Object o = super.getComponentInstance(componentKey);
                MockComponentManager.this.registerComponentInDisposer(o);
                return o;
            }
        };
        this.myPicoContainer.registerComponentInstance((Object)this);
        Disposer.register(parentDisposable, this);
    }

    private void registerComponentInDisposer(@Nullable Object o) {
        if (o instanceof Disposable && o != this && this.myDisposableComponents.add(o)) {
            Disposer.register(this, (Disposable)o);
        }
    }

    @Override
    public BaseComponent getComponent(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/mock/MockComponentManager", "getComponent"));
        }
        return null;
    }

    public <T> void registerService(@NotNull Class<T> serviceInterface, @NotNull Class<? extends T> serviceImplementation) {
        if (serviceInterface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceInterface", "com/intellij/mock/MockComponentManager", "registerService"));
        }
        if (serviceImplementation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceImplementation", "com/intellij/mock/MockComponentManager", "registerService"));
        }
        this.myPicoContainer.unregisterComponent((Object)serviceInterface.getName());
        this.myPicoContainer.registerComponentImplementation((Object)serviceInterface.getName(), serviceImplementation);
    }

    public <T> void registerService(@NotNull Class<T> serviceImplementation) {
        if (serviceImplementation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceImplementation", "com/intellij/mock/MockComponentManager", "registerService"));
        }
        this.registerService(serviceImplementation, (T)serviceImplementation);
    }

    public <T> void registerService(@NotNull Class<T> serviceInterface, @NotNull T serviceImplementation) {
        if (serviceInterface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceInterface", "com/intellij/mock/MockComponentManager", "registerService"));
        }
        if (serviceImplementation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceImplementation", "com/intellij/mock/MockComponentManager", "registerService"));
        }
        this.myPicoContainer.registerComponentInstance((Object)serviceInterface.getName(), serviceImplementation);
        this.registerComponentInDisposer(serviceImplementation);
    }

    public <T> void addComponent(@NotNull Class<T> interfaceClass, @NotNull T instance) {
        if (interfaceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interfaceClass", "com/intellij/mock/MockComponentManager", "addComponent"));
        }
        if (instance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "com/intellij/mock/MockComponentManager", "addComponent"));
        }
        this.myComponents.put(interfaceClass, instance);
        this.registerComponentInDisposer(instance);
    }

    @Override
    @Nullable
    public <T> T getComponent(@NotNull Class<T> interfaceClass) {
        if (interfaceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interfaceClass", "com/intellij/mock/MockComponentManager", "getComponent"));
        }
        Object o = this.myPicoContainer.getComponentInstance(interfaceClass);
        return (T)(o != null ? o : this.myComponents.get(interfaceClass));
    }

    @Override
    public <T> T getComponent(@NotNull Class<T> interfaceClass, T defaultImplementation) {
        if (interfaceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interfaceClass", "com/intellij/mock/MockComponentManager", "getComponent"));
        }
        return this.getComponent(interfaceClass);
    }

    @Override
    public boolean hasComponent(@NotNull Class interfaceClass) {
        if (interfaceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interfaceClass", "com/intellij/mock/MockComponentManager", "hasComponent"));
        }
        return false;
    }

    @Override
    @NotNull
    public <T> T[] getComponents(@NotNull Class<T> baseClass) {
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/mock/MockComponentManager", "getComponents"));
        }
        List list = this.myPicoContainer.getComponentInstancesOfType(baseClass);
        Object[] objectArray = list.toArray((Object[])Array.newInstance(baseClass, 0));
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockComponentManager", "getComponents"));
        }
        return objectArray;
    }

    @NotNull
    public MutablePicoContainer getPicoContainer() {
        MutablePicoContainer mutablePicoContainer = this.myPicoContainer;
        if (mutablePicoContainer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockComponentManager", "getPicoContainer"));
        }
        return mutablePicoContainer;
    }

    @Override
    @NotNull
    public MessageBus getMessageBus() {
        MessageBus messageBus = this.myMessageBus;
        if (messageBus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockComponentManager", "getMessageBus"));
        }
        return messageBus;
    }

    @Override
    public boolean isDisposed() {
        return this.myDisposed;
    }

    @Override
    public void dispose() {
        this.myMessageBus.dispose();
        this.myDisposed = true;
    }

    @Override
    @NotNull
    public <T> T[] getExtensions(@NotNull ExtensionPointName<T> extensionPointName) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointName", "com/intellij/mock/MockComponentManager", "getExtensions"));
        }
        throw new UnsupportedOperationException("getExtensions()");
    }

    @Override
    @NotNull
    public Condition<?> getDisposed() {
        Condition condition = Conditions.alwaysFalse();
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockComponentManager", "getDisposed"));
        }
        return condition;
    }
}

