/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.processing;

import com.intellij.openapi.diff.ex.DiffFragment;
import com.intellij.openapi.diff.impl.ComparisonPolicy;
import com.intellij.openapi.diff.impl.string.DiffString;
import com.intellij.util.diff.FilesTooBigForDiffException;
import org.jetbrains.annotations.NotNull;

public interface DiffPolicy {
    public static final DiffPolicy LINES_WO_FORMATTING = new LineBlocks(ComparisonPolicy.IGNORE_SPACE);
    public static final DiffPolicy DEFAULT_LINES = new LineBlocks(ComparisonPolicy.DEFAULT);

    @NotNull
    public DiffFragment[] buildFragments(@NotNull DiffString var1, @NotNull DiffString var2) throws FilesTooBigForDiffException;

    @NotNull
    public DiffFragment[] buildFragments(@NotNull String var1, @NotNull String var2) throws FilesTooBigForDiffException;

    public static class ByChar
    implements DiffPolicy {
        private final ComparisonPolicy myComparisonPolicy;

        public ByChar(ComparisonPolicy comparisonPolicy) {
            this.myComparisonPolicy = comparisonPolicy;
        }

        @Override
        @NotNull
        public DiffFragment[] buildFragments(@NotNull String text1, @NotNull String text2) throws FilesTooBigForDiffException {
            if (text1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/openapi/diff/impl/processing/DiffPolicy$ByChar", "buildFragments"));
            }
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/openapi/diff/impl/processing/DiffPolicy$ByChar", "buildFragments"));
            }
            DiffFragment[] diffFragmentArray = this.buildFragments(DiffString.create(text1), DiffString.create(text2));
            if (diffFragmentArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/processing/DiffPolicy$ByChar", "buildFragments"));
            }
            return diffFragmentArray;
        }

        @Override
        @NotNull
        public DiffFragment[] buildFragments(@NotNull DiffString text1, @NotNull DiffString text2) throws FilesTooBigForDiffException {
            if (text1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/openapi/diff/impl/processing/DiffPolicy$ByChar", "buildFragments"));
            }
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/openapi/diff/impl/processing/DiffPolicy$ByChar", "buildFragments"));
            }
            DiffFragment[] diffFragmentArray = this.myComparisonPolicy.buildFragments(ByChar.splitByChar(text1), ByChar.splitByChar(text2));
            if (diffFragmentArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/processing/DiffPolicy$ByChar", "buildFragments"));
            }
            return diffFragmentArray;
        }

        private static DiffString[] splitByChar(@NotNull DiffString text2) {
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/diff/impl/processing/DiffPolicy$ByChar", "splitByChar"));
            }
            DiffString[] result = new DiffString[text2.length()];
            for (int i2 = 0; i2 < result.length; ++i2) {
                result[i2] = text2.substring(i2, i2 + 1);
            }
            return result;
        }
    }

    public static class LineBlocks
    implements DiffPolicy {
        private final ComparisonPolicy myComparisonPolicy;

        public LineBlocks(ComparisonPolicy comparisonPolicy) {
            this.myComparisonPolicy = comparisonPolicy;
        }

        @Override
        @NotNull
        public DiffFragment[] buildFragments(@NotNull String text1, @NotNull String text2) throws FilesTooBigForDiffException {
            if (text1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/openapi/diff/impl/processing/DiffPolicy$LineBlocks", "buildFragments"));
            }
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/openapi/diff/impl/processing/DiffPolicy$LineBlocks", "buildFragments"));
            }
            DiffFragment[] diffFragmentArray = this.buildFragments(DiffString.create(text1), DiffString.create(text2));
            if (diffFragmentArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/processing/DiffPolicy$LineBlocks", "buildFragments"));
            }
            return diffFragmentArray;
        }

        @Override
        @NotNull
        public DiffFragment[] buildFragments(@NotNull DiffString text1, @NotNull DiffString text2) throws FilesTooBigForDiffException {
            if (text1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/openapi/diff/impl/processing/DiffPolicy$LineBlocks", "buildFragments"));
            }
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/openapi/diff/impl/processing/DiffPolicy$LineBlocks", "buildFragments"));
            }
            DiffString[] strings1 = text1.tokenize();
            DiffString[] strings2 = text2.tokenize();
            DiffFragment[] diffFragmentArray = this.myComparisonPolicy.buildDiffFragmentsFromLines(strings1, strings2);
            if (diffFragmentArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/processing/DiffPolicy$LineBlocks", "buildFragments"));
            }
            return diffFragmentArray;
        }
    }
}

