/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.util.text.AddonlyIntSet;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.TIntProcedure;

public class TrigramBuilder {
    private TrigramBuilder() {
    }

    public static boolean processTrigrams(CharSequence text2, TrigramProcessor consumer) {
        AddonlyIntSet set = new AddonlyIntSet();
        int index = 0;
        char[] fileTextArray = CharArrayUtil.fromSequenceWithoutCopying(text2);
        while (index != text2.length()) {
            char c;
            char c2 = c = fileTextArray != null ? fileTextArray[index] : text2.charAt(index);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || Character.isJavaIdentifierPart(c))) {
                ++index;
                continue;
            }
            int identifierStart = index;
            while (++index != text2.length()) {
                char c3;
                char c4 = c3 = fileTextArray != null ? fileTextArray[index] : text2.charAt(index);
                if (c3 >= 'a' && c3 <= 'z' || c3 >= 'A' && c3 <= 'Z' || c3 >= '0' && c3 <= '9' || Character.isJavaIdentifierPart(c3)) continue;
                break;
            }
            int tc1 = 0;
            int tc2 = 0;
            int i2 = identifierStart;
            int iters = 0;
            while (i2 < index) {
                char c5 = StringUtil.toLowerCase(fileTextArray != null ? fileTextArray[i2] : text2.charAt(i2));
                int tc3 = (tc2 << 8) + c5;
                tc2 = (tc1 << 8) + c5;
                tc1 = c5;
                if (iters >= 2) {
                    set.add(tc3);
                }
                ++i2;
                ++iters;
            }
        }
        return consumer.consumeTrigramsCount(set.size()) && set.forEach(consumer);
    }

    public static abstract class TrigramProcessor
    implements TIntProcedure {
        public boolean consumeTrigramsCount(int count) {
            return true;
        }
    }
}

