/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.java.stubs.index.JavaAnnotationIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class AnnotatedElementsSearcher
implements QueryExecutor<PsiModifierListOwner, AnnotatedElementsSearch.Parameters> {
    @Override
    public boolean execute(@NotNull AnnotatedElementsSearch.Parameters p, @NotNull Processor<PsiModifierListOwner> consumer) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/psi/impl/search/AnnotatedElementsSearcher", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/AnnotatedElementsSearcher", "execute"));
        }
        PsiClass annClass = p.getAnnotationClass();
        if (!annClass.isAnnotationType()) {
            throw new IllegalArgumentException("Annotation type should be passed to annotated members search but got: " + annClass);
        }
        String annotationFQN = ReadAction.compute(() -> annClass.getQualifiedName());
        if (annotationFQN == null) {
            throw new IllegalArgumentException("FQN is null for " + annClass);
        }
        PsiManager psiManager = ReadAction.compute(() -> annClass.getManager());
        SearchScope useScope = p.getScope();
        Class[] types = p.getTypes();
        for (PsiAnnotation ann : AnnotatedElementsSearcher.getAnnotationCandidates(annClass, useScope, psiManager.getProject())) {
            PsiModifierListOwner candidate = ReadAction.compute(() -> {
                if (p == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/psi/impl/search/AnnotatedElementsSearcher", "lambda$execute$2"));
                }
                PsiElement parent = ann.getContext();
                if (!(parent instanceof PsiModifierList)) {
                    return null;
                }
                PsiElement owner = parent.getParent();
                if (!AnnotatedElementsSearcher.isInstanceof(owner, types)) {
                    return null;
                }
                if (p.isApproximate()) {
                    return (PsiModifierListOwner)owner;
                }
                PsiJavaCodeReferenceElement ref = ann.getNameReferenceElement();
                if (ref == null || !psiManager.areElementsEquivalent(ref.resolve(), annClass)) {
                    return null;
                }
                return (PsiModifierListOwner)owner;
            });
            if (candidate == null || consumer.process(candidate)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static Collection<PsiAnnotation> getAnnotationCandidates(@NotNull PsiClass annClass, @NotNull SearchScope useScope, @NotNull Project project) {
        if (annClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annClass", "com/intellij/psi/impl/search/AnnotatedElementsSearcher", "getAnnotationCandidates"));
        }
        if (useScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "useScope", "com/intellij/psi/impl/search/AnnotatedElementsSearcher", "getAnnotationCandidates"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/AnnotatedElementsSearcher", "getAnnotationCandidates"));
        }
        Collection collection = ReadAction.compute(() -> {
            if (useScope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "useScope", "com/intellij/psi/impl/search/AnnotatedElementsSearcher", "lambda$getAnnotationCandidates$3"));
            }
            if (annClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annClass", "com/intellij/psi/impl/search/AnnotatedElementsSearcher", "lambda$getAnnotationCandidates$3"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/AnnotatedElementsSearcher", "lambda$getAnnotationCandidates$3"));
            }
            if (useScope instanceof GlobalSearchScope) {
                return JavaAnnotationIndex.getInstance().get(annClass.getName(), project, (GlobalSearchScope)useScope);
            }
            ArrayList<PsiAnnotation> result = new ArrayList<PsiAnnotation>();
            for (PsiElement element : ((LocalSearchScope)useScope).getScope()) {
                result.addAll(PsiTreeUtil.findChildrenOfType(element, PsiAnnotation.class));
            }
            return result;
        });
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/AnnotatedElementsSearcher", "getAnnotationCandidates"));
        }
        return collection;
    }

    public static boolean isInstanceof(PsiElement owner, @NotNull Class<? extends PsiModifierListOwner>[] types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/psi/impl/search/AnnotatedElementsSearcher", "isInstanceof"));
        }
        for (Class<? extends PsiModifierListOwner> type : types) {
            if (!type.isInstance(owner)) continue;
            return true;
        }
        return false;
    }
}

