/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.portability;

import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.portability.mediatype.ApplicationMediaType;
import com.siyeh.ig.portability.mediatype.AudioMediaType;
import com.siyeh.ig.portability.mediatype.ImageMediaType;
import com.siyeh.ig.portability.mediatype.MessageMediaType;
import com.siyeh.ig.portability.mediatype.ModelMediaType;
import com.siyeh.ig.portability.mediatype.MultipartMediaType;
import com.siyeh.ig.portability.mediatype.TextMediaType;
import com.siyeh.ig.portability.mediatype.VideoMediaType;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class HardcodedFileSeparatorsInspection
extends BaseInspection {
    private static final char BACKSLASH = '\\';
    private static final char SLASH = '/';
    @NonNls
    private static final Pattern DATE_FORMAT_PATTERN = Pattern.compile("\\b[dDmM]+/[dDmM]+(/[yY]+)?");
    @NonNls
    private static final String EXAMPLE_MIME_MEDIA_TYPE_PATTERN = "example/\\p{Alnum}+(?:[.\\-\\\\+]\\p{Alnum}+)*";
    @NonNls
    private static final Pattern URL_PATTERN = Pattern.compile("^[a-z][a-z0-9+\\-:]+://.*$");
    private static final Set<String> mimeTypes = new HashSet<String>();
    private static final Set<String> timeZoneIds;
    public boolean m_recognizeExampleMediaType = false;

    @Override
    @NotNull
    public String getID() {
        if ("HardcodedFileSeparator" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/portability/HardcodedFileSeparatorsInspection", "getID"));
        }
        return "HardcodedFileSeparator";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("hardcoded.file.separator.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/portability/HardcodedFileSeparatorsInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("hardcoded.file.separator.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/portability/HardcodedFileSeparatorsInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("hardcoded.file.separator.include.option", new Object[0]), this, "m_recognizeExampleMediaType");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new HardcodedFileSeparatorsVisitor();
    }

    static {
        for (ImageMediaType imageMediaType : ImageMediaType.values()) {
            mimeTypes.add(imageMediaType.toString());
        }
        for (Enum enum_ : ApplicationMediaType.values()) {
            mimeTypes.add(((ApplicationMediaType)enum_).toString());
        }
        for (Enum enum_ : AudioMediaType.values()) {
            mimeTypes.add(((AudioMediaType)enum_).toString());
        }
        for (Enum enum_ : MessageMediaType.values()) {
            mimeTypes.add(((MessageMediaType)enum_).toString());
        }
        for (Enum enum_ : ModelMediaType.values()) {
            mimeTypes.add(((ModelMediaType)enum_).toString());
        }
        for (Enum enum_ : MultipartMediaType.values()) {
            mimeTypes.add(((MultipartMediaType)enum_).toString());
        }
        for (Enum enum_ : TextMediaType.values()) {
            mimeTypes.add(((TextMediaType)enum_).toString());
        }
        for (Enum enum_ : VideoMediaType.values()) {
            mimeTypes.add(((VideoMediaType)enum_).toString());
        }
        timeZoneIds = new HashSet<String>();
        ContainerUtil.addAll(timeZoneIds, TimeZone.getAvailableIDs());
    }

    private class HardcodedFileSeparatorsVisitor
    extends BaseInspectionVisitor {
        private HardcodedFileSeparatorsVisitor() {
        }

        @Override
        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/portability/HardcodedFileSeparatorsInspection$HardcodedFileSeparatorsVisitor", "visitLiteralExpression"));
            }
            super.visitLiteralExpression(expression);
            PsiType type = expression.getType();
            if (TypeUtils.isJavaLangString(type)) {
                PsiNewExpression newExpression;
                PsiMethodCallExpression methodCallExpression;
                PsiElement grandParent;
                String value = (String)expression.getValue();
                if (!this.isHardcodedFilenameString(value)) {
                    return;
                }
                PsiElement parent = ParenthesesUtils.getParentSkipParentheses(expression);
                if (parent != null && ((grandParent = parent.getParent()) instanceof PsiMethodCallExpression ? MethodCallUtils.isCallToRegexMethod(methodCallExpression = (PsiMethodCallExpression)grandParent) || MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Class", null, "getResource", null) || MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Class", null, "getResourceAsStream", null) : grandParent instanceof PsiNewExpression && TypeUtils.expressionHasTypeOrSubtype((PsiExpression)(newExpression = (PsiNewExpression)grandParent), "javax.swing.ImageIcon"))) {
                    return;
                }
                this.registerErrorAtOffset((PsiElement)expression, 1, expression.getTextLength() - 2, new Object[0]);
            } else if (type != null && type.equals(PsiType.CHAR)) {
                Character value = (Character)expression.getValue();
                if (value == null) {
                    return;
                }
                char unboxedValue = value.charValue();
                if (unboxedValue == '\\' || unboxedValue == '/') {
                    this.registerErrorAtOffset((PsiElement)expression, 1, expression.getTextLength() - 2, new Object[0]);
                }
            }
        }

        private boolean isHardcodedFilenameString(String string) {
            if (string == null) {
                return false;
            }
            if (string.indexOf(47) == -1 && string.indexOf(92) == -1) {
                return false;
            }
            char startChar = string.charAt(0);
            if (Character.isLetter(startChar) && string.charAt(1) == ':') {
                return true;
            }
            if (this.isXMLString(string)) {
                return false;
            }
            if (this.isDateFormatString(string)) {
                return false;
            }
            if (this.isURLString(string)) {
                return false;
            }
            if (this.isMediaTypeString(string)) {
                return false;
            }
            return !this.isTimeZoneIdString(string);
        }

        private boolean isXMLString(String string) {
            return string.contains("</") || string.contains("/>");
        }

        private boolean isDateFormatString(String string) {
            if (string.length() < 3) {
                return false;
            }
            int strLength = string.length();
            char startChar = string.charAt(0);
            char endChar = string.charAt(strLength - 1);
            if (startChar == '/' || endChar == '/') {
                return false;
            }
            if (Character.isLetter(startChar) && string.charAt(1) == ':') {
                return false;
            }
            Matcher dateFormatMatcher = DATE_FORMAT_PATTERN.matcher(string);
            return dateFormatMatcher.find();
        }

        private boolean isURLString(String string) {
            Matcher urlMatcher = URL_PATTERN.matcher(string);
            return urlMatcher.find();
        }

        private boolean isMediaTypeString(String string) {
            if (HardcodedFileSeparatorsInspection.this.m_recognizeExampleMediaType && string.matches(HardcodedFileSeparatorsInspection.EXAMPLE_MIME_MEDIA_TYPE_PATTERN)) {
                return true;
            }
            return mimeTypes.contains(string);
        }

        private boolean isTimeZoneIdString(String string) {
            return timeZoneIds.contains(string);
        }
    }
}

