/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.HintedReferenceHost;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SharedPsiElementImplUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.SharedPsiElementImplUtil");

    private SharedPsiElementImplUtil() {
    }

    @Nullable
    public static PsiReference findReferenceAt(PsiElement thisElement, int offset, @Nullable Language lang) {
        PsiElement element;
        if (thisElement == null) {
            return null;
        }
        PsiElement psiElement = element = lang != null ? thisElement.getContainingFile().getViewProvider().findElementAt(offset, lang) : thisElement.findElementAt(offset);
        if (element == null || element instanceof OuterLanguageElement) {
            return null;
        }
        offset = thisElement.getTextRange().getStartOffset() + offset - element.getTextRange().getStartOffset();
        ArrayList<PsiReference> referencesList = new ArrayList<PsiReference>();
        while (element != null) {
            SharedPsiElementImplUtil.addReferences(offset, element, referencesList);
            if (element instanceof PsiFile || element instanceof HintedReferenceHost && !((HintedReferenceHost)element).shouldAskParentForReferences(new PsiReferenceService.Hints(null, offset))) break;
            offset = element.getStartOffsetInParent() + offset;
            element = element.getParent();
        }
        if (referencesList.isEmpty()) {
            return null;
        }
        if (referencesList.size() == 1) {
            return (PsiReference)referencesList.get(0);
        }
        return new PsiMultiReference(referencesList.toArray(new PsiReference[referencesList.size()]), ((PsiReference)referencesList.get(referencesList.size() - 1)).getElement());
    }

    @Nullable
    public static PsiReference findReferenceAt(PsiElement thisElement, int offset) {
        return SharedPsiElementImplUtil.findReferenceAt(thisElement, offset, null);
    }

    private static void addReferences(int offset, PsiElement element, Collection<PsiReference> outReferences) {
        PsiReference[] references = element instanceof HintedReferenceHost ? ((HintedReferenceHost)element).getReferences(new PsiReferenceService.Hints(null, offset)) : element.getReferences();
        for (PsiReference reference : references) {
            if (reference == null) {
                LOG.error("Null reference returned from " + element + " of " + element.getClass());
                continue;
            }
            for (TextRange range : ReferenceRange.getRanges(reference)) {
                LOG.assertTrue(range != null, reference);
                if (!range.containsOffset(offset)) continue;
                outReferences.add(reference);
            }
        }
    }

    @NotNull
    public static PsiReference[] getReferences(PsiElement thisElement) {
        PsiReference ref = thisElement.getReference();
        if (ref == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/SharedPsiElementImplUtil", "getReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{ref};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/SharedPsiElementImplUtil", "getReferences"));
        }
        return psiReferenceArray;
    }

    @Nullable
    public static PsiElement getNextSibling(PsiElement element) {
        if (element instanceof PsiFile) {
            FileViewProvider viewProvider = ((PsiFile)element).getViewProvider();
            element = viewProvider.getPsi(viewProvider.getBaseLanguage());
        }
        if (element == null) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent == null) {
            return null;
        }
        PsiElement[] children = parent.getChildren();
        int index = SharedPsiElementImplUtil.getChildIndex(children, element);
        return 0 <= index && index < children.length - 1 ? children[index + 1] : null;
    }

    @Nullable
    public static PsiElement getPrevSibling(PsiElement element) {
        if (element instanceof PsiFile) {
            FileViewProvider viewProvider = ((PsiFile)element).getViewProvider();
            element = viewProvider.getPsi(viewProvider.getBaseLanguage());
        }
        if (element == null) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent == null) {
            return null;
        }
        PsiElement[] children = parent.getChildren();
        int index = SharedPsiElementImplUtil.getChildIndex(children, element);
        return index > 0 ? children[index - 1] : null;
    }

    private static int getChildIndex(PsiElement[] children, PsiElement child) {
        for (int i = 0; i < children.length; ++i) {
            PsiElement candidate = children[i];
            if (candidate != child) continue;
            return i;
        }
        LOG.error("Cannot find element among its parent' children. element: '" + child + "'; parent: '" + child.getParent() + "'; children: " + Arrays.asList(children) + ";  file:" + child.getContainingFile());
        return -1;
    }
}

