/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class JBSwingUtilities {
    private static final boolean LEGACY_JDK = !SystemInfo.isJavaVersionAtLeast("1.8");
    private static final List<PairFunction<JComponent, Graphics2D, Graphics2D>> ourGlobalTransform = ContainerUtil.createEmptyCOWList();

    public static boolean isLeftMouseButton(MouseEvent anEvent) {
        return LEGACY_JDK ? (anEvent.getModifiersEx() & 0x400) > 0 : SwingUtilities.isLeftMouseButton(anEvent);
    }

    public static boolean isMiddleMouseButton(MouseEvent anEvent) {
        return LEGACY_JDK ? (anEvent.getModifiersEx() & 0x800) > 0 : SwingUtilities.isMiddleMouseButton(anEvent);
    }

    public static boolean isRightMouseButton(MouseEvent anEvent) {
        return LEGACY_JDK ? (anEvent.getModifiersEx() & 0x1000) > 0 : SwingUtilities.isRightMouseButton(anEvent);
    }

    public static Disposable addGlobalCGTransform(final PairFunction<JComponent, Graphics2D, Graphics2D> fun) {
        ourGlobalTransform.add(fun);
        return new Disposable(){

            @Override
            public void dispose() {
                ourGlobalTransform.remove(fun);
            }
        };
    }

    @NotNull
    public static Graphics2D runGlobalCGTransform(@NotNull JComponent c, @NotNull Graphics g) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/ui/JBSwingUtilities", "runGlobalCGTransform"));
        }
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/util/ui/JBSwingUtilities", "runGlobalCGTransform"));
        }
        Graphics2D gg = (Graphics2D)g;
        for (PairFunction<JComponent, Graphics2D, Graphics2D> transform : ourGlobalTransform) {
            gg = ObjectUtils.notNull(transform.fun(c, gg));
        }
        Graphics2D graphics2D = gg;
        if (graphics2D == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/JBSwingUtilities", "runGlobalCGTransform"));
        }
        return graphics2D;
    }
}

