/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.MergeModuleStatementsFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergePackageAccessibilityStatementsFix
extends MergeModuleStatementsFix<PsiPackageAccessibilityStatement> {
    private static final Logger LOG = Logger.getInstance(MergePackageAccessibilityStatementsFix.class);
    private final String myPackageName;
    private final PsiPackageAccessibilityStatement.Role myRole;

    protected MergePackageAccessibilityStatementsFix(@NotNull PsiJavaModule javaModule, @NotNull String packageName, @NotNull PsiPackageAccessibilityStatement.Role role) {
        if (javaModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaModule", "com/intellij/codeInsight/daemon/impl/quickfix/MergePackageAccessibilityStatementsFix", "<init>"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/codeInsight/daemon/impl/quickfix/MergePackageAccessibilityStatementsFix", "<init>"));
        }
        if (role == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "role", "com/intellij/codeInsight/daemon/impl/quickfix/MergePackageAccessibilityStatementsFix", "<init>"));
        }
        super(javaModule);
        this.myPackageName = packageName;
        this.myRole = role;
    }

    @Override
    @Nls
    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("java.9.merge.module.statements.fix.name", this.getKeyword(), this.myPackageName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/MergePackageAccessibilityStatementsFix", "getText"));
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("java.9.merge.module.statements.fix.family.name", this.getKeyword());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/MergePackageAccessibilityStatementsFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String getReplacementText(@NotNull List<PsiPackageAccessibilityStatement> statementsToMerge) {
        if (statementsToMerge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statementsToMerge", "com/intellij/codeInsight/daemon/impl/quickfix/MergePackageAccessibilityStatementsFix", "getReplacementText"));
        }
        List<String> moduleNames = MergePackageAccessibilityStatementsFix.getModuleNames(statementsToMerge);
        if (!moduleNames.isEmpty()) {
            String string = this.getKeyword() + " " + this.myPackageName + " " + "to" + " " + MergePackageAccessibilityStatementsFix.joinUniqueNames(moduleNames) + ";";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/MergePackageAccessibilityStatementsFix", "getReplacementText"));
            }
            return string;
        }
        String string = this.getKeyword() + " " + this.myPackageName + ";";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/MergePackageAccessibilityStatementsFix", "getReplacementText"));
        }
        return string;
    }

    @NotNull
    private static List<String> getModuleNames(@NotNull List<PsiPackageAccessibilityStatement> statements) {
        if (statements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statements", "com/intellij/codeInsight/daemon/impl/quickfix/MergePackageAccessibilityStatementsFix", "getModuleNames"));
        }
        ArrayList<String> result = new ArrayList<String>();
        for (PsiPackageAccessibilityStatement statement : statements) {
            List<String> moduleNames = statement.getModuleNames();
            if (moduleNames.isEmpty()) {
                List<String> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/MergePackageAccessibilityStatementsFix", "getModuleNames"));
                }
                return list;
            }
            result.addAll(moduleNames);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/MergePackageAccessibilityStatementsFix", "getModuleNames"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected List<PsiPackageAccessibilityStatement> getStatementsToMerge(@NotNull PsiJavaModule javaModule) {
        if (javaModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaModule", "com/intellij/codeInsight/daemon/impl/quickfix/MergePackageAccessibilityStatementsFix", "getStatementsToMerge"));
        }
        List list = ((StreamEx)StreamEx.of(MergePackageAccessibilityStatementsFix.getStatements(javaModule, this.myRole).iterator()).filter(statement -> this.myPackageName.equals(statement.getPackageName()))).toList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/MergePackageAccessibilityStatementsFix", "getStatementsToMerge"));
        }
        return list;
    }

    @Nullable
    public static MergeModuleStatementsFix createFix(@Nullable PsiPackageAccessibilityStatement statement) {
        String packageName;
        PsiElement parent;
        if (statement != null && (parent = statement.getParent()) instanceof PsiJavaModule && (packageName = statement.getPackageName()) != null) {
            return new MergePackageAccessibilityStatementsFix((PsiJavaModule)parent, packageName, statement.getRole());
        }
        return null;
    }

    @NotNull
    private static Iterable<PsiPackageAccessibilityStatement> getStatements(@NotNull PsiJavaModule javaModule, @NotNull PsiPackageAccessibilityStatement.Role role) {
        if (javaModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaModule", "com/intellij/codeInsight/daemon/impl/quickfix/MergePackageAccessibilityStatementsFix", "getStatements"));
        }
        if (role == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "role", "com/intellij/codeInsight/daemon/impl/quickfix/MergePackageAccessibilityStatementsFix", "getStatements"));
        }
        switch (role) {
            case OPENS: {
                Iterable<PsiPackageAccessibilityStatement> iterable = javaModule.getOpens();
                if (iterable == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/MergePackageAccessibilityStatementsFix", "getStatements"));
                }
                return iterable;
            }
            case EXPORTS: {
                Iterable<PsiPackageAccessibilityStatement> iterable = javaModule.getExports();
                if (iterable == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/MergePackageAccessibilityStatementsFix", "getStatements"));
                }
                return iterable;
            }
        }
        LOG.error("Unexpected role " + (Object)((Object)role));
        List<PsiPackageAccessibilityStatement> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/MergePackageAccessibilityStatementsFix", "getStatements"));
        }
        return list;
    }

    @NotNull
    private String getKeyword() {
        switch (this.myRole) {
            case OPENS: {
                if ("opens" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/MergePackageAccessibilityStatementsFix", "getKeyword"));
                }
                return "opens";
            }
            case EXPORTS: {
                if ("exports" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/MergePackageAccessibilityStatementsFix", "getKeyword"));
                }
                return "exports";
            }
        }
        LOG.error("Unexpected role " + (Object)((Object)this.myRole));
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/MergePackageAccessibilityStatementsFix", "getKeyword"));
        }
        return "";
    }
}

