/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deprecation;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.DeprecationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeprecationInspection
extends BaseJavaBatchLocalInspectionTool {
    public static final String SHORT_NAME = "Deprecation";
    public static final String ID = "deprecation";
    public static final String DISPLAY_NAME = DeprecationUtil.DEPRECATION_DISPLAY_NAME;
    public static final String IGNORE_METHODS_OF_DEPRECATED_NAME = "IGNORE_METHODS_OF_DEPRECATED";
    public boolean IGNORE_INSIDE_DEPRECATED = true;
    public boolean IGNORE_ABSTRACT_DEPRECATED_OVERRIDES = true;
    public boolean IGNORE_IMPORT_STATEMENTS = true;
    public boolean IGNORE_METHODS_OF_DEPRECATED = true;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/deprecation/DeprecationInspection", "buildVisitor"));
        }
        DeprecationElementVisitor deprecationElementVisitor = new DeprecationElementVisitor(holder, this.IGNORE_INSIDE_DEPRECATED, this.IGNORE_ABSTRACT_DEPRECATED_OVERRIDES, this.IGNORE_IMPORT_STATEMENTS, this.IGNORE_METHODS_OF_DEPRECATED);
        if (deprecationElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/deprecation/DeprecationInspection", "buildVisitor"));
        }
        return deprecationElementVisitor;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = DISPLAY_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/deprecation/DeprecationInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/deprecation/DeprecationInspection", "getGroupDisplayName"));
        }
        return "";
    }

    @Override
    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/deprecation/DeprecationInspection", "getShortName"));
        }
        return SHORT_NAME;
    }

    @Override
    @NotNull
    public String getID() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/deprecation/DeprecationInspection", "getID"));
        }
        return ID;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel(this);
        panel.addCheckbox("Ignore inside deprecated members", "IGNORE_INSIDE_DEPRECATED");
        panel.addCheckbox("Ignore inside non-static imports", "IGNORE_IMPORT_STATEMENTS");
        panel.addCheckbox("<html>Ignore overrides of deprecated abstract methods from non-deprecated supers</html>", "IGNORE_ABSTRACT_DEPRECATED_OVERRIDES");
        panel.addCheckbox("Ignore members of deprecated classes", IGNORE_METHODS_OF_DEPRECATED_NAME);
        return panel;
    }

    private static boolean hasDefaultDeprecatedConstructor(PsiClass superClass) {
        if (superClass != null) {
            PsiMethod[] constructors;
            for (PsiMethod constructor : constructors = superClass.getConstructors()) {
                if (constructor.getParameterList().getParametersCount() != 0 || !constructor.isDeprecated()) continue;
                return true;
            }
        }
        return false;
    }

    private static void checkMethodOverridesDeprecated(MethodSignatureBackedByPsiMethod methodSignature, List<MethodSignatureBackedByPsiMethod> superMethodSignatures, boolean ignoreAbstractDeprecatedOverrides, ProblemsHolder holder) {
        PsiMethod method = methodSignature.getMethod();
        PsiIdentifier methodName = method.getNameIdentifier();
        if (methodName == null) {
            return;
        }
        for (MethodSignatureBackedByPsiMethod superMethodSignature : superMethodSignatures) {
            PsiMethod superMethod = superMethodSignature.getMethod();
            PsiClass aClass = superMethod.getContainingClass();
            if (aClass == null || ignoreAbstractDeprecatedOverrides && !aClass.isDeprecated() && superMethod.hasModifierProperty("abstract") || !superMethod.isDeprecated()) continue;
            String description = JavaErrorMessages.message("overrides.deprecated.method", HighlightMessageUtil.getSymbolName(aClass));
            holder.registerProblem((PsiElement)methodName, description, ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[0]);
        }
    }

    public static void checkDeprecated(PsiElement refElement, PsiElement elementToHighlight, @Nullable TextRange rangeInElement, ProblemsHolder holder) {
        DeprecationInspection.checkDeprecated(refElement, elementToHighlight, rangeInElement, false, false, true, holder);
    }

    private static void checkDeprecated(PsiElement refElement, PsiElement elementToHighlight, @Nullable TextRange rangeInElement, boolean ignoreInsideDeprecated, boolean ignoreImportStatements, boolean ignoreMethodsOfDeprecated, ProblemsHolder holder) {
        if (!(refElement instanceof PsiDocCommentOwner)) {
            return;
        }
        if (!((PsiDocCommentOwner)refElement).isDeprecated()) {
            if (!ignoreMethodsOfDeprecated) {
                DeprecationInspection.checkDeprecated(((PsiDocCommentOwner)refElement).getContainingClass(), elementToHighlight, rangeInElement, ignoreInsideDeprecated, ignoreImportStatements, false, holder);
            }
            return;
        }
        if (ignoreInsideDeprecated) {
            PsiElement parent = elementToHighlight;
            while ((parent = PsiTreeUtil.getParentOfType(parent, PsiDocCommentOwner.class, true)) != null) {
                if (!((PsiDocCommentOwner)parent).isDeprecated()) continue;
                return;
            }
        }
        if (ignoreImportStatements && PsiTreeUtil.getParentOfType(elementToHighlight, PsiImportStatementBase.class) != null) {
            return;
        }
        String description = JavaErrorMessages.message("deprecated.symbol", HighlightMessageUtil.getSymbolName(refElement));
        holder.registerProblem(elementToHighlight, description, ProblemHighlightType.LIKE_DEPRECATED, rangeInElement, new LocalQuickFix[0]);
    }

    private static class DeprecationElementVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;
        private final boolean myIgnoreInsideDeprecated;
        private final boolean myIgnoreAbstractDeprecatedOverrides;
        private final boolean myIgnoreImportStatements;
        private final boolean myIgnoreMethodsOfDeprecated;

        private DeprecationElementVisitor(ProblemsHolder holder, boolean ignoreInsideDeprecated, boolean ignoreAbstractDeprecatedOverrides, boolean ignoreImportStatements, boolean ignoreMethodsOfDeprecated) {
            this.myHolder = holder;
            this.myIgnoreInsideDeprecated = ignoreInsideDeprecated;
            this.myIgnoreAbstractDeprecatedOverrides = ignoreAbstractDeprecatedOverrides;
            this.myIgnoreImportStatements = ignoreImportStatements;
            this.myIgnoreMethodsOfDeprecated = ignoreMethodsOfDeprecated;
        }

        @Override
        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            PsiElement resolved = reference.advancedResolve(true).getElement();
            PsiElement refName = reference.getReferenceNameElement();
            DeprecationInspection.checkDeprecated(resolved, refName, null, this.myIgnoreInsideDeprecated, this.myIgnoreImportStatements, this.myIgnoreMethodsOfDeprecated, this.myHolder);
        }

        @Override
        public void visitImportStaticStatement(PsiImportStaticStatement statement) {
            PsiJavaCodeReferenceElement importReference = statement.getImportReference();
            if (importReference != null) {
                PsiElement refName = importReference.getReferenceNameElement();
                DeprecationInspection.checkDeprecated(importReference.resolve(), refName, null, this.myIgnoreInsideDeprecated, false, true, this.myHolder);
            }
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
            this.visitReferenceElement(expression);
        }

        @Override
        public void visitNewExpression(PsiNewExpression expression) {
            PsiClass aClass = null;
            PsiType type = expression.getType();
            if (type instanceof PsiClassType && (aClass = ((PsiClassType)type).resolveGenerics().getElement()) instanceof PsiAnonymousClass) {
                type = ((PsiAnonymousClass)aClass).getBaseClassType();
                aClass = ((PsiClassType)type).resolveGenerics().getElement();
            }
            if (aClass == null) {
                return;
            }
            PsiExpressionList list = expression.getArgumentList();
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance(expression.getProject()).getResolveHelper();
            if (list != null && aClass.getConstructors().length > 0) {
                PsiJavaCodeReferenceElement ref;
                PsiMethod constructor;
                JavaResolveResult[] results = resolveHelper.multiResolveConstructor((PsiClassType)type, list, list);
                MethodCandidateInfo result = null;
                if (results.length == 1) {
                    result = (MethodCandidateInfo)results[0];
                }
                PsiMethod psiMethod = constructor = result == null ? null : result.getElement();
                if (constructor != null && (ref = expression.getClassOrAnonymousClassReference()) != null) {
                    if (expression.getClassReference() == null && constructor.getParameterList().getParametersCount() == 0) {
                        return;
                    }
                    DeprecationInspection.checkDeprecated(constructor, ref, null, this.myIgnoreInsideDeprecated, this.myIgnoreImportStatements, true, this.myHolder);
                }
            }
        }

        @Override
        public void visitMethod(PsiMethod method) {
            MethodSignatureBackedByPsiMethod methodSignature = MethodSignatureBackedByPsiMethod.create(method, PsiSubstitutor.EMPTY);
            if (!method.isConstructor()) {
                List<MethodSignatureBackedByPsiMethod> superMethodSignatures = method.findSuperMethodSignaturesIncludingStatic(true);
                DeprecationInspection.checkMethodOverridesDeprecated(methodSignature, superMethodSignatures, this.myIgnoreAbstractDeprecatedOverrides, this.myHolder);
            } else {
                this.checkImplicitCallToSuper(method);
            }
        }

        private void checkImplicitCallToSuper(PsiMethod method) {
            PsiClass containingClass = method.getContainingClass();
            assert (containingClass != null);
            PsiClass superClass = containingClass.getSuperClass();
            if (DeprecationInspection.hasDefaultDeprecatedConstructor(superClass)) {
                PsiStatement[] statements;
                PsiExpressionList argumentList;
                if (superClass instanceof PsiAnonymousClass && (argumentList = ((PsiAnonymousClass)superClass).getArgumentList()) != null && argumentList.getExpressions().length > 0) {
                    return;
                }
                PsiCodeBlock body = method.getBody();
                if (!(body == null || (statements = body.getStatements()).length != 0 && JavaHighlightUtil.isSuperOrThisCall(statements[0], true, true))) {
                    this.registerDefaultConstructorProblem(superClass, method.getNameIdentifier(), false);
                }
            }
        }

        private void registerDefaultConstructorProblem(PsiClass superClass, PsiElement nameIdentifier, boolean asDeprecated) {
            ProblemHighlightType type = asDeprecated ? ProblemHighlightType.LIKE_DEPRECATED : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            this.myHolder.registerProblem(nameIdentifier, "Default constructor in " + superClass.getQualifiedName() + " is deprecated", type, new LocalQuickFix[0]);
        }

        @Override
        public void visitClass(PsiClass aClass) {
            PsiClass superClass;
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            PsiMethod[] currentConstructors = aClass.getConstructors();
            if (currentConstructors.length == 0 && DeprecationInspection.hasDefaultDeprecatedConstructor(superClass = aClass.getSuperClass())) {
                PsiExpressionList argumentList;
                boolean isAnonymous = aClass instanceof PsiAnonymousClass;
                if (isAnonymous && (argumentList = ((PsiAnonymousClass)aClass).getArgumentList()) != null && argumentList.getExpressions().length > 0) {
                    return;
                }
                PsiElement identifier = isAnonymous ? ((PsiAnonymousClass)aClass).getBaseClassReference() : aClass.getNameIdentifier();
                this.registerDefaultConstructorProblem(superClass, identifier, isAnonymous);
            }
        }

        @Override
        public void visitRequiresStatement(PsiRequiresStatement statement) {
            PsiJavaModuleReferenceElement refElement = statement.getReferenceElement();
            if (refElement != null) {
                PsiElement target;
                PsiPolyVariantReference ref = refElement.getReference();
                PsiElement psiElement = target = ref != null ? ref.resolve() : null;
                if (target instanceof PsiJavaModule && PsiImplUtil.isDeprecatedByAnnotation((PsiJavaModule)target)) {
                    String message = JavaErrorMessages.message("deprecated.symbol", HighlightMessageUtil.getSymbolName(target));
                    this.myHolder.registerProblem((PsiElement)refElement, message, ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[0]);
                }
            }
        }
    }
}

