/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.string;

import com.intellij.openapi.diff.LineTokenizerBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayCharSequence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffString
extends CharArrayCharSequence {
    @NotNull
    public static final DiffString EMPTY = new DiffString(new char[0], 0, 0);

    @Nullable
    public static DiffString createNullable(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return DiffString.create(string);
    }

    @NotNull
    public static DiffString create(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/openapi/diff/impl/string/DiffString", "create"));
        }
        if (string.isEmpty()) {
            DiffString diffString = EMPTY;
            if (diffString == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "create"));
            }
            return diffString;
        }
        DiffString diffString = DiffString.create(string.toCharArray());
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "create"));
        }
        return diffString;
    }

    @NotNull
    static DiffString create(@NotNull char[] data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/diff/impl/string/DiffString", "create"));
        }
        DiffString diffString = DiffString.create(data, 0, data.length);
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "create"));
        }
        return diffString;
    }

    @NotNull
    static DiffString create(@NotNull char[] data, int start, int length) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/diff/impl/string/DiffString", "create"));
        }
        if (length == 0) {
            DiffString diffString = EMPTY;
            if (diffString == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "create"));
            }
            return diffString;
        }
        DiffString.checkBounds(start, length, data.length);
        DiffString diffString = new DiffString(data, start, length);
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "create"));
        }
        return diffString;
    }

    private DiffString(@NotNull char[] data, int start, int length) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/diff/impl/string/DiffString", "<init>"));
        }
        super(data, start, start + length);
    }

    @Override
    public boolean isEmpty() {
        return this.length() == 0;
    }

    private char data(int index) {
        return this.charAt(index);
    }

    @NotNull
    public DiffString substring(int start) {
        DiffString diffString = this.substring(start, this.length());
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "substring"));
        }
        return diffString;
    }

    @NotNull
    public DiffString substring(int start, int end) {
        if (start == 0 && end == this.length()) {
            DiffString diffString = this;
            if (diffString == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "substring"));
            }
            return diffString;
        }
        DiffString.checkBounds(start, end - start, this.length());
        DiffString diffString = DiffString.create(this.myChars, this.myStart + start, end - start);
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "substring"));
        }
        return diffString;
    }

    @Override
    @NotNull
    public DiffString subSequence(int start, int end) {
        DiffString diffString = this.substring(start, end);
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "subSequence"));
        }
        return diffString;
    }

    @NotNull
    public DiffString copy() {
        DiffString diffString = DiffString.create(Arrays.copyOfRange(this.myChars, this.myStart, this.myStart + this.length()));
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "copy"));
        }
        return diffString;
    }

    public void copyData(@NotNull char[] dst, int start) {
        if (dst == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dst", "com/intellij/openapi/diff/impl/string/DiffString", "copyData"));
        }
        DiffString.checkBounds(start, this.length(), dst.length);
        System.arraycopy(this.myChars, this.myStart, dst, start, this.length());
    }

    @Nullable
    public static DiffString concatenateNullable(@Nullable DiffString s1, @Nullable DiffString s2) {
        if (s1 == null || s2 == null) {
            if (s1 != null) {
                return s1;
            }
            if (s2 != null) {
                return s2;
            }
            return null;
        }
        return DiffString.concatenate(s1, s2);
    }

    @NotNull
    public static DiffString concatenate(@NotNull DiffString s1, @NotNull DiffString s2) {
        if (s1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s1", "com/intellij/openapi/diff/impl/string/DiffString", "concatenate"));
        }
        if (s2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s2", "com/intellij/openapi/diff/impl/string/DiffString", "concatenate"));
        }
        if (s1.isEmpty()) {
            DiffString diffString = s2;
            if (diffString == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "concatenate"));
            }
            return diffString;
        }
        if (s2.isEmpty()) {
            DiffString diffString = s1;
            if (diffString == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "concatenate"));
            }
            return diffString;
        }
        if (s1.myChars == s2.myChars && s1.myStart + s1.length() == s2.myStart) {
            DiffString diffString = DiffString.create(s1.myChars, s1.myStart, s1.length() + s2.length());
            if (diffString == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "concatenate"));
            }
            return diffString;
        }
        char[] data = new char[s1.length() + s2.length()];
        System.arraycopy(s1.myChars, s1.myStart, data, 0, s1.length());
        System.arraycopy(s2.myChars, s2.myStart, data, s1.length(), s2.length());
        DiffString diffString = DiffString.create(data);
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "concatenate"));
        }
        return diffString;
    }

    public static boolean canInplaceConcatenate(@NotNull DiffString s1, @NotNull DiffString s2) {
        if (s1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s1", "com/intellij/openapi/diff/impl/string/DiffString", "canInplaceConcatenate"));
        }
        if (s2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s2", "com/intellij/openapi/diff/impl/string/DiffString", "canInplaceConcatenate"));
        }
        if (s1.isEmpty()) {
            return true;
        }
        if (s2.isEmpty()) {
            return true;
        }
        return s1.myChars == s2.myChars && s1.myStart + s1.length() == s2.myStart;
    }

    @NotNull
    public static DiffString concatenateCopying(@NotNull DiffString[] strings) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/openapi/diff/impl/string/DiffString", "concatenateCopying"));
        }
        DiffString diffString = DiffString.concatenateCopying(strings, 0, strings.length);
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "concatenateCopying"));
        }
        return diffString;
    }

    @NotNull
    public static DiffString concatenateCopying(@NotNull DiffString[] strings, int start, int length) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/openapi/diff/impl/string/DiffString", "concatenateCopying"));
        }
        DiffString.checkBounds(start, length, strings.length);
        int len = 0;
        for (int i2 = 0; i2 < length; ++i2) {
            DiffString string = strings[start + i2];
            len += string == null ? 0 : string.length();
        }
        if (len == 0) {
            DiffString diffString = EMPTY;
            if (diffString == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "concatenateCopying"));
            }
            return diffString;
        }
        char[] data = new char[len];
        int index = 0;
        for (int i3 = 0; i3 < length; ++i3) {
            DiffString string = strings[start + i3];
            if (string == null || string.isEmpty()) continue;
            System.arraycopy(string.myChars, string.myStart, data, index, string.length());
            index += string.length();
        }
        DiffString diffString = DiffString.create(data);
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "concatenateCopying"));
        }
        return diffString;
    }

    @NotNull
    public static DiffString concatenate(@NotNull DiffString s, char c) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/diff/impl/string/DiffString", "concatenate"));
        }
        if (s.myStart + s.length() < s.myChars.length && s.data(s.length()) == c) {
            DiffString diffString = DiffString.create(s.myChars, s.myStart, s.length() + 1);
            if (diffString == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "concatenate"));
            }
            return diffString;
        }
        char[] data = new char[s.length() + 1];
        System.arraycopy(s.myChars, s.myStart, data, 0, s.length());
        data[s.length()] = c;
        DiffString diffString = DiffString.create(data);
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "concatenate"));
        }
        return diffString;
    }

    @NotNull
    public static DiffString concatenate(char c, @NotNull DiffString s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/diff/impl/string/DiffString", "concatenate"));
        }
        if (s.myStart > 0 && s.data(-1) == c) {
            DiffString diffString = DiffString.create(s.myChars, s.myStart - 1, s.length() + 1);
            if (diffString == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "concatenate"));
            }
            return diffString;
        }
        char[] data = new char[s.length() + 1];
        System.arraycopy(s.myChars, s.myStart, data, 1, s.length());
        data[0] = c;
        DiffString diffString = DiffString.create(data);
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "concatenate"));
        }
        return diffString;
    }

    @NotNull
    public static DiffString concatenate(@NotNull DiffString[] strings) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/openapi/diff/impl/string/DiffString", "concatenate"));
        }
        DiffString diffString = DiffString.concatenate(strings, 0, strings.length);
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "concatenate"));
        }
        return diffString;
    }

    @NotNull
    public static DiffString concatenate(@NotNull DiffString[] strings, int start, int length) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/openapi/diff/impl/string/DiffString", "concatenate"));
        }
        DiffString.checkBounds(start, length, strings.length);
        char[] data = null;
        int startIndex = 0;
        int endIndex = 0;
        boolean linearized = true;
        for (int i2 = 0; i2 < length; ++i2) {
            DiffString string = strings[start + i2];
            if (string == null || string.isEmpty()) continue;
            if (data == null) {
                data = string.myChars;
                startIndex = string.myStart;
                endIndex = string.myStart + string.length();
                continue;
            }
            if (data != string.myChars || string.myStart != endIndex) {
                linearized = false;
                break;
            }
            endIndex += string.length();
        }
        if (linearized) {
            if (data == null) {
                DiffString diffString = EMPTY;
                if (diffString == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "concatenate"));
                }
                return diffString;
            }
            DiffString diffString = DiffString.create(data, startIndex, endIndex - startIndex);
            if (diffString == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "concatenate"));
            }
            return diffString;
        }
        DiffString diffString = DiffString.concatenateCopying(strings, start, length);
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "concatenate"));
        }
        return diffString;
    }

    @NotNull
    public DiffString append(char c) {
        DiffString diffString = DiffString.concatenate(this, c);
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "append"));
        }
        return diffString;
    }

    @NotNull
    public DiffString preappend(char c) {
        DiffString diffString = DiffString.concatenate(c, this);
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "preappend"));
        }
        return diffString;
    }

    public static boolean isWhiteSpace(char c) {
        return StringUtil.isWhiteSpace(c);
    }

    public boolean isEmptyOrSpaces() {
        if (this.isEmpty()) {
            return true;
        }
        for (int i2 = 0; i2 < this.length(); ++i2) {
            if (DiffString.isWhiteSpace(this.data(i2))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public DiffString trim() {
        int start;
        int end = this.length();
        for (start = 0; start < end && DiffString.isWhiteSpace(this.data(start)); ++start) {
        }
        while (end > start && DiffString.isWhiteSpace(this.data(end - 1))) {
            --end;
        }
        DiffString diffString = this.substring(start, end);
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "trim"));
        }
        return diffString;
    }

    @NotNull
    public DiffString trimLeading() {
        int i2;
        for (i2 = 0; i2 < this.length() && DiffString.isWhiteSpace(this.data(i2)); ++i2) {
        }
        DiffString diffString = this.substring(i2, this.length());
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "trimLeading"));
        }
        return diffString;
    }

    @NotNull
    public DiffString trimTrailing() {
        int end;
        for (end = this.length(); end > 0 && DiffString.isWhiteSpace(this.data(end - 1)); --end) {
        }
        DiffString diffString = this.substring(0, end);
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "trimTrailing"));
        }
        return diffString;
    }

    @NotNull
    public DiffString getLeadingSpaces() {
        int i2;
        for (i2 = 0; i2 < this.length() && this.data(i2) == ' '; ++i2) {
        }
        DiffString diffString = this.substring(0, i2);
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "getLeadingSpaces"));
        }
        return diffString;
    }

    @NotNull
    public DiffString skipSpaces() {
        DiffString s = this.trim();
        int count = 0;
        for (int i2 = 0; i2 < s.length(); ++i2) {
            if (!DiffString.isWhiteSpace(s.data(i2))) continue;
            ++count;
        }
        if (count == 0) {
            DiffString diffString = s;
            if (diffString == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "skipSpaces"));
            }
            return diffString;
        }
        char[] data = new char[s.length() - count];
        int index = 0;
        for (int i3 = 0; i3 < s.length(); ++i3) {
            if (DiffString.isWhiteSpace(s.data(i3))) continue;
            data[index] = s.data(i3);
            ++index;
        }
        DiffString diffString = DiffString.create(data);
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "skipSpaces"));
        }
        return diffString;
    }

    public int indexOf(char c) {
        return StringUtil.indexOf((CharSequence)this, c);
    }

    public boolean endsWith(char c) {
        if (this.isEmpty()) {
            return false;
        }
        return this.data(this.length() - 1) == c;
    }

    public static void checkBounds(int start, int length, int maxLength) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (length < 0) {
            throw new StringIndexOutOfBoundsException(length);
        }
        if (start + length > maxLength) {
            throw new StringIndexOutOfBoundsException(start + length);
        }
    }

    @NotNull
    public DiffString[] tokenize() {
        DiffString[] diffStringArray = new LineTokenizer(this).execute();
        if (diffStringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString", "tokenize"));
        }
        return diffStringArray;
    }

    public static class LineTokenizer
    extends LineTokenizerBase<DiffString> {
        @NotNull
        private final DiffString myText;

        public LineTokenizer(@NotNull DiffString text2) {
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/diff/impl/string/DiffString$LineTokenizer", "<init>"));
            }
            this.myText = text2;
        }

        @NotNull
        public DiffString[] execute() {
            ArrayList lines = new ArrayList();
            this.doExecute(lines);
            DiffString[] diffStringArray = ContainerUtil.toArray(lines, new DiffString[lines.size()]);
            if (diffStringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString$LineTokenizer", "execute"));
            }
            return diffStringArray;
        }

        @Override
        protected void addLine(List<DiffString> lines, int start, int end, boolean appendNewLine) {
            if (appendNewLine) {
                lines.add(this.myText.substring(start, end).append('\n'));
            } else {
                lines.add(this.myText.substring(start, end));
            }
        }

        @Override
        protected char charAt(int index) {
            return this.myText.data(index);
        }

        @Override
        protected int length() {
            return this.myText.length();
        }

        @Override
        @NotNull
        protected String substring(int start, int end) {
            String string = this.myText.substring(start, end).toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffString$LineTokenizer", "substring"));
            }
            return string;
        }
    }
}

