/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiLambdaParameterType;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiSuperMethodUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Producer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaUtil {
    public static final RecursionGuard ourParameterGuard = RecursionManager.createGuard("lambdaParameterGuard");
    public static final ThreadLocal<Map<PsiElement, PsiType>> ourFunctionTypes = new ThreadLocal();
    private static final Logger LOG = Logger.getInstance(LambdaUtil.class);

    @Nullable
    public static PsiType getFunctionalInterfaceReturnType(PsiFunctionalExpression expr) {
        return LambdaUtil.getFunctionalInterfaceReturnType(expr.getFunctionalInterfaceType());
    }

    @Nullable
    public static PsiType getFunctionalInterfaceReturnType(@Nullable PsiType functionalInterfaceType) {
        MethodSignature methodSignature;
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
        PsiClass psiClass = resolveResult.getElement();
        if (psiClass != null && (methodSignature = LambdaUtil.getFunction(psiClass)) != null) {
            PsiType returnType = LambdaUtil.getReturnType(psiClass, methodSignature);
            return resolveResult.getSubstitutor().substitute(returnType);
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiMethod getFunctionalInterfaceMethod(@Nullable PsiType functionalInterfaceType) {
        return LambdaUtil.getFunctionalInterfaceMethod(PsiUtil.resolveGenericsClassInType(functionalInterfaceType));
    }

    public static PsiMethod getFunctionalInterfaceMethod(@Nullable PsiElement element) {
        if (element instanceof PsiFunctionalExpression) {
            PsiType samType = ((PsiFunctionalExpression)element).getFunctionalInterfaceType();
            return LambdaUtil.getFunctionalInterfaceMethod(samType);
        }
        return null;
    }

    @Nullable
    public static PsiMethod getFunctionalInterfaceMethod(@NotNull PsiClassType.ClassResolveResult result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/LambdaUtil", "getFunctionalInterfaceMethod"));
        }
        return LambdaUtil.getFunctionalInterfaceMethod(result.getElement());
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiMethod getFunctionalInterfaceMethod(PsiClass aClass) {
        MethodSignature methodSignature = LambdaUtil.getFunction(aClass);
        if (methodSignature != null) {
            return LambdaUtil.getMethod(aClass, methodSignature);
        }
        return null;
    }

    public static PsiSubstitutor getSubstitutor(@NotNull PsiMethod method, @NotNull PsiClassType.ClassResolveResult resolveResult) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/LambdaUtil", "getSubstitutor"));
        }
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/psi/LambdaUtil", "getSubstitutor"));
        }
        PsiClass derivedClass = resolveResult.getElement();
        LOG.assertTrue(derivedClass != null);
        PsiClass methodContainingClass = method.getContainingClass();
        LOG.assertTrue(methodContainingClass != null);
        PsiSubstitutor initialSubst = resolveResult.getSubstitutor();
        PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(methodContainingClass, derivedClass, PsiSubstitutor.EMPTY);
        for (PsiTypeParameter param : superClassSubstitutor.getSubstitutionMap().keySet()) {
            initialSubst = initialSubst.put(param, initialSubst.substitute(superClassSubstitutor.substitute(param)));
        }
        return initialSubst;
    }

    public static boolean isFunctionalType(PsiType type) {
        if (type instanceof PsiIntersectionType) {
            return LambdaUtil.extractFunctionalConjunct((PsiIntersectionType)type) != null;
        }
        return LambdaUtil.isFunctionalClass(PsiUtil.resolveClassInClassTypeOnly(type));
    }

    @Contract(value="null -> false")
    public static boolean isFunctionalClass(PsiClass aClass) {
        if (aClass != null) {
            if (aClass instanceof PsiTypeParameter) {
                return false;
            }
            return LambdaUtil.getFunction(aClass) != null;
        }
        return false;
    }

    @Contract(value="null -> false")
    public static boolean isValidLambdaContext(@Nullable PsiElement context) {
        if (LambdaUtil.isAssignmentOrInvocationContext(context = PsiUtil.skipParenthesizedExprUp(context)) || context instanceof PsiTypeCastExpression) {
            return true;
        }
        if (context instanceof PsiConditionalExpression) {
            PsiElement parentContext = PsiUtil.skipParenthesizedExprUp(context.getParent());
            if (LambdaUtil.isAssignmentOrInvocationContext(parentContext)) {
                return true;
            }
            if (parentContext instanceof PsiConditionalExpression) {
                return LambdaUtil.isValidLambdaContext(parentContext);
            }
        }
        return false;
    }

    @Contract(value="null -> false")
    private static boolean isAssignmentOrInvocationContext(PsiElement context) {
        return LambdaUtil.isAssignmentContext(context) || LambdaUtil.isInvocationContext(context);
    }

    private static boolean isInvocationContext(@Nullable PsiElement context) {
        return context instanceof PsiExpressionList;
    }

    private static boolean isAssignmentContext(PsiElement context) {
        return context instanceof PsiLambdaExpression || context instanceof PsiReturnStatement || context instanceof PsiAssignmentExpression || context instanceof PsiVariable || context instanceof PsiArrayInitializerExpression;
    }

    public static boolean isLambdaFullyInferred(PsiLambdaExpression expression, PsiType functionalInterfaceType) {
        boolean hasParams;
        boolean bl = hasParams = expression.getParameterList().getParametersCount() > 0;
        if (hasParams || !PsiType.VOID.equals(LambdaUtil.getFunctionalInterfaceReturnType(functionalInterfaceType))) {
            return !LambdaUtil.dependsOnTypeParams(functionalInterfaceType, functionalInterfaceType, expression, new PsiTypeParameter[0]);
        }
        return true;
    }

    @Contract(value="null -> null")
    @Nullable
    public static MethodSignature getFunction(PsiClass psiClass) {
        if (LambdaUtil.isPlainInterface(psiClass)) {
            return (MethodSignature)CachedValuesManager.getCachedValue(psiClass, () -> CachedValueProvider.Result.create(LambdaUtil.calcFunction(psiClass), PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT));
        }
        return null;
    }

    private static boolean isPlainInterface(PsiClass psiClass) {
        return psiClass != null && psiClass.isInterface() && !psiClass.isAnnotationType();
    }

    @Nullable
    private static MethodSignature calcFunction(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/LambdaUtil", "calcFunction"));
        }
        if (LambdaUtil.hasManyOwnAbstractMethods(psiClass) || LambdaUtil.hasManyInheritedAbstractMethods(psiClass)) {
            return null;
        }
        List<HierarchicalMethodSignature> functions = LambdaUtil.findFunctionCandidates(psiClass);
        return functions != null && functions.size() == 1 ? (MethodSignature)functions.get(0) : null;
    }

    private static boolean hasManyOwnAbstractMethods(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/LambdaUtil", "hasManyOwnAbstractMethods"));
        }
        int abstractCount = 0;
        for (PsiMethod method : psiClass.getMethods()) {
            if (!LambdaUtil.isDefinitelyAbstractInterfaceMethod(method) || ++abstractCount <= 1) continue;
            return true;
        }
        return false;
    }

    private static boolean isDefinitelyAbstractInterfaceMethod(PsiMethod method) {
        return method.hasModifierProperty("abstract") && !LambdaUtil.isPublicObjectMethod(method.getName());
    }

    private static boolean isPublicObjectMethod(String methodName) {
        return "equals".equals(methodName) || "hashCode".equals(methodName) || "toString".equals(methodName);
    }

    private static boolean hasManyInheritedAbstractMethods(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/LambdaUtil", "hasManyInheritedAbstractMethods"));
        }
        HashSet abstractNames = ContainerUtil.newHashSet();
        HashSet defaultNames = ContainerUtil.newHashSet();
        InheritanceUtil.processSupers(psiClass, true, psiClass1 -> {
            for (PsiMethod method : psiClass1.getMethods()) {
                if (LambdaUtil.isDefinitelyAbstractInterfaceMethod(method)) {
                    abstractNames.add(method.getName());
                    continue;
                }
                if (!method.hasModifierProperty("default")) continue;
                defaultNames.add(method.getName());
            }
            return true;
        });
        abstractNames.removeAll(defaultNames);
        return abstractNames.size() > 1;
    }

    private static boolean overridesPublicObjectMethod(HierarchicalMethodSignature psiMethod) {
        PsiMethod method;
        PsiClass containingClass;
        List<HierarchicalMethodSignature> signatures = psiMethod.getSuperSignatures();
        if (signatures.isEmpty() && (containingClass = (method = psiMethod.getMethod()).getContainingClass()) != null && "java.lang.Object".equals(containingClass.getQualifiedName()) && method.hasModifierProperty("public")) {
            return true;
        }
        for (HierarchicalMethodSignature superMethod : signatures) {
            if (!LambdaUtil.overridesPublicObjectMethod(superMethod)) continue;
            return true;
        }
        return false;
    }

    private static MethodSignature getMethodSignature(PsiMethod method, PsiClass psiClass, PsiClass containingClass) {
        MethodSignature methodSignature = containingClass != null && containingClass != psiClass ? method.getSignature(TypeConversionUtil.getSuperClassSubstitutor(containingClass, psiClass, PsiSubstitutor.EMPTY)) : method.getSignature(PsiSubstitutor.EMPTY);
        return methodSignature;
    }

    @NotNull
    private static List<HierarchicalMethodSignature> hasSubSignature(List<HierarchicalMethodSignature> signatures) {
        for (HierarchicalMethodSignature signature : signatures) {
            boolean subSignature = true;
            for (HierarchicalMethodSignature methodSignature : signatures) {
                if (signature.equals(methodSignature) || LambdaUtil.skipMethod(signature, methodSignature)) continue;
                subSignature = false;
                break;
            }
            if (!subSignature) continue;
            List<HierarchicalMethodSignature> list = Collections.singletonList(signature);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/LambdaUtil", "hasSubSignature"));
            }
            return list;
        }
        List<HierarchicalMethodSignature> list = signatures;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/LambdaUtil", "hasSubSignature"));
        }
        return list;
    }

    private static boolean skipMethod(HierarchicalMethodSignature signature, HierarchicalMethodSignature methodSignature) {
        if (methodSignature.getTypeParameters().length == 0) {
            return false;
        }
        return signature.getMethod().getContainingClass() != methodSignature.getMethod().getContainingClass();
    }

    @Contract(value="null -> null")
    @Nullable
    public static List<HierarchicalMethodSignature> findFunctionCandidates(@Nullable PsiClass psiClass) {
        if (!LambdaUtil.isPlainInterface(psiClass)) {
            return null;
        }
        ArrayList<HierarchicalMethodSignature> methods = new ArrayList<HierarchicalMethodSignature>();
        Map<MethodSignature, Set<PsiMethod>> overrideEquivalents = PsiSuperMethodUtil.collectOverrideEquivalents(psiClass);
        Collection<HierarchicalMethodSignature> visibleSignatures = psiClass.getVisibleSignatures();
        for (HierarchicalMethodSignature signature : visibleSignatures) {
            PsiMethod psiMethod = signature.getMethod();
            if (!psiMethod.hasModifierProperty("abstract") || psiMethod.hasModifierProperty("static")) continue;
            Set<PsiMethod> equivalentMethods = overrideEquivalents.get(signature);
            if (equivalentMethods != null && equivalentMethods.size() > 1) {
                boolean hasNonAbstractOverrideEquivalent = false;
                for (PsiMethod method : equivalentMethods) {
                    if (method.hasModifierProperty("abstract") || MethodSignatureUtil.isSuperMethod(method, psiMethod)) continue;
                    hasNonAbstractOverrideEquivalent = true;
                    break;
                }
                if (hasNonAbstractOverrideEquivalent) continue;
            }
            if (LambdaUtil.overridesPublicObjectMethod(signature)) continue;
            methods.add(signature);
        }
        return LambdaUtil.hasSubSignature(methods);
    }

    @Nullable
    private static PsiType getReturnType(PsiClass psiClass, MethodSignature methodSignature) {
        PsiMethod method = LambdaUtil.getMethod(psiClass, methodSignature);
        if (method != null) {
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return null;
            }
            return TypeConversionUtil.getSuperClassSubstitutor(containingClass, psiClass, PsiSubstitutor.EMPTY).substitute(method.getReturnType());
        }
        return null;
    }

    @Nullable
    private static PsiMethod getMethod(PsiClass psiClass, MethodSignature methodSignature) {
        PsiMethod[] methodsByName;
        if (methodSignature instanceof MethodSignatureBackedByPsiMethod) {
            return ((MethodSignatureBackedByPsiMethod)methodSignature).getMethod();
        }
        for (PsiMethod psiMethod : methodsByName = psiClass.findMethodsByName(methodSignature.getName(), true)) {
            if (!MethodSignatureUtil.areSignaturesEqual(LambdaUtil.getMethodSignature(psiMethod, psiClass, psiMethod.getContainingClass()), methodSignature)) continue;
            return psiMethod;
        }
        return null;
    }

    public static int getLambdaIdx(PsiExpressionList expressionList, PsiElement element) {
        PsiExpression[] expressions = expressionList.getExpressions();
        for (int i2 = 0; i2 < expressions.length; ++i2) {
            PsiExpression expression = expressions[i2];
            if (!PsiTreeUtil.isAncestor(expression, element, false)) continue;
            return i2;
        }
        return -1;
    }

    public static boolean dependsOnTypeParams(PsiType type, PsiType functionalInterfaceType, PsiElement lambdaExpression, PsiTypeParameter ... param2Check) {
        return LambdaUtil.depends(type, new TypeParamsChecker(lambdaExpression, PsiUtil.resolveClassInType(functionalInterfaceType)), param2Check);
    }

    public static boolean depends(PsiType type, TypeParamsChecker visitor, PsiTypeParameter ... param2Check) {
        if (!visitor.startedInference()) {
            return false;
        }
        Boolean accept = type.accept(visitor);
        if (param2Check.length > 0) {
            return visitor.used(param2Check);
        }
        return accept != null && accept != false;
    }

    @Nullable
    public static PsiType getFunctionalInterfaceType(PsiElement expression, boolean tryToSubstitute) {
        PsiType type;
        PsiElement parent = expression.getParent();
        PsiElement element = expression;
        while (!(!(parent instanceof PsiParenthesizedExpression) && !(parent instanceof PsiConditionalExpression) || parent instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent).getThenExpression() != element && ((PsiConditionalExpression)parent).getElseExpression() != element)) {
            element = parent;
            parent = parent.getParent();
        }
        Map<PsiElement, PsiType> map = ourFunctionTypes.get();
        if (map != null && (type = map.get(expression)) != null) {
            return type;
        }
        if (parent instanceof PsiArrayInitializerExpression) {
            PsiType psiType = ((PsiArrayInitializerExpression)parent).getType();
            if (psiType instanceof PsiArrayType) {
                return ((PsiArrayType)psiType).getComponentType();
            }
        } else {
            if (parent instanceof PsiTypeCastExpression) {
                PsiType conjunct;
                PsiType castType;
                PsiTypeElement castTypeElement = ((PsiTypeCastExpression)parent).getCastType();
                PsiType psiType = castType = castTypeElement != null ? castTypeElement.getType() : null;
                if (castType instanceof PsiIntersectionType && (conjunct = LambdaUtil.extractFunctionalConjunct((PsiIntersectionType)castType)) != null) {
                    return conjunct;
                }
                return castType;
            }
            if (parent instanceof PsiVariable) {
                return ((PsiVariable)parent).getType();
            }
            if (parent instanceof PsiAssignmentExpression && expression instanceof PsiExpression && !PsiUtil.isOnAssignmentLeftHand((PsiExpression)expression)) {
                PsiExpression lExpression = ((PsiAssignmentExpression)parent).getLExpression();
                return lExpression.getType();
            }
            if (parent instanceof PsiExpressionList) {
                PsiExpressionList expressionList = (PsiExpressionList)parent;
                int lambdaIdx = LambdaUtil.getLambdaIdx(expressionList, expression);
                if (lambdaIdx > -1) {
                    PsiElement gParent = expressionList.getParent();
                    if (gParent instanceof PsiAnonymousClass) {
                        gParent = gParent.getParent();
                    }
                    if (gParent instanceof PsiCall) {
                        PsiCall contextCall = (PsiCall)gParent;
                        MethodCandidateInfo.CurrentCandidateProperties properties = MethodCandidateInfo.getCurrentMethod(contextCall.getArgumentList());
                        if (properties != null && properties.isApplicabilityCheck()) {
                            PsiParameter[] parameters = properties.getMethod().getParameterList().getParameters();
                            int finalLambdaIdx = LambdaUtil.adjustLambdaIdx(lambdaIdx, properties.getMethod(), parameters);
                            if (finalLambdaIdx < parameters.length) {
                                return properties.getSubstitutor().substitute(LambdaUtil.getNormalizedType(parameters[finalLambdaIdx]));
                            }
                        }
                        JavaResolveResult resolveResult = properties != null ? properties.getInfo() : PsiDiamondType.getDiamondsAwareResolveResult(contextCall);
                        return LambdaUtil.getSubstitutedType(expression, tryToSubstitute, lambdaIdx, resolveResult);
                    }
                }
            } else {
                if (parent instanceof PsiReturnStatement) {
                    return PsiTypesUtil.getMethodReturnType(parent);
                }
                if (parent instanceof PsiLambdaExpression) {
                    return LambdaUtil.getFunctionalInterfaceTypeByContainingLambda((PsiLambdaExpression)parent);
                }
            }
        }
        return null;
    }

    @Nullable
    private static PsiType getSubstitutedType(PsiElement expression, boolean tryToSubstitute, int lambdaIdx, JavaResolveResult resolveResult) {
        PsiParameter[] parameters;
        int finalLambdaIdx;
        PsiElement resolve = resolveResult.getElement();
        if (resolve instanceof PsiMethod && (finalLambdaIdx = LambdaUtil.adjustLambdaIdx(lambdaIdx, (PsiMethod)resolve, parameters = ((PsiMethod)resolve).getParameterList().getParameters())) < parameters.length) {
            if (!tryToSubstitute) {
                return LambdaUtil.getNormalizedType(parameters[finalLambdaIdx]);
            }
            return PsiResolveHelper.ourGraphGuard.doPreventingRecursion(expression, !MethodCandidateInfo.isOverloadCheck(), () -> {
                PsiType normalizedType = LambdaUtil.getNormalizedType(parameters[finalLambdaIdx]);
                if (resolveResult instanceof MethodCandidateInfo && ((MethodCandidateInfo)resolveResult).isRawSubstitution()) {
                    return TypeConversionUtil.erasure(normalizedType);
                }
                return resolveResult.getSubstitutor().substitute(normalizedType);
            });
        }
        return null;
    }

    public static boolean processParentOverloads(PsiFunctionalExpression functionalExpression, Consumer<PsiType> overloadProcessor) {
        PsiExpressionList expressionList;
        int lambdaIdx;
        LOG.assertTrue(PsiTypesUtil.getExpectedTypeByParent(functionalExpression) == null);
        PsiElement parent = functionalExpression.getParent();
        PsiElement expr = functionalExpression;
        while (!(!(parent instanceof PsiParenthesizedExpression) && !(parent instanceof PsiConditionalExpression) || parent instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent).getThenExpression() != expr && ((PsiConditionalExpression)parent).getElseExpression() != expr)) {
            expr = parent;
            parent = parent.getParent();
        }
        if (parent instanceof PsiExpressionList && (lambdaIdx = LambdaUtil.getLambdaIdx(expressionList = (PsiExpressionList)parent, functionalExpression)) > -1) {
            PsiElement gParent = expressionList.getParent();
            if (gParent instanceof PsiAnonymousClass) {
                gParent = gParent.getParent();
            }
            if (gParent instanceof PsiMethodCallExpression) {
                JavaResolveResult[] results;
                HashSet<PsiType> types = new HashSet<PsiType>();
                for (JavaResolveResult result : results = ((PsiMethodCallExpression)gParent).getMethodExpression().multiResolve(true)) {
                    PsiType functionalExpressionType = LambdaUtil.getSubstitutedType(functionalExpression, true, lambdaIdx, result);
                    if (functionalExpressionType == null || !types.add(functionalExpressionType)) continue;
                    overloadProcessor.consume(functionalExpressionType);
                }
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static PsiType extractFunctionalConjunct(PsiIntersectionType type) {
        PsiType conjunct = null;
        MethodSignature commonSignature = null;
        for (PsiType psiType : type.getConjuncts()) {
            MethodSignature signature;
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly(psiType);
            if (aClass instanceof PsiTypeParameter || (signature = LambdaUtil.getFunction(aClass)) == null) continue;
            if (commonSignature == null) {
                commonSignature = signature;
            } else if (!MethodSignatureUtil.areSignaturesEqual(commonSignature, signature)) {
                return null;
            }
            conjunct = psiType;
        }
        return conjunct;
    }

    private static PsiType getFunctionalInterfaceTypeByContainingLambda(@NotNull PsiLambdaExpression parentLambda) {
        if (parentLambda == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentLambda", "com/intellij/psi/LambdaUtil", "getFunctionalInterfaceTypeByContainingLambda"));
        }
        PsiType parentInterfaceType = parentLambda.getFunctionalInterfaceType();
        return parentInterfaceType != null ? LambdaUtil.getFunctionalInterfaceReturnType(parentInterfaceType) : null;
    }

    private static int adjustLambdaIdx(int lambdaIdx, PsiMethod resolve, PsiParameter[] parameters) {
        int finalLambdaIdx = resolve.isVarArgs() && lambdaIdx >= parameters.length ? parameters.length - 1 : lambdaIdx;
        return finalLambdaIdx;
    }

    private static PsiType getNormalizedType(PsiParameter parameter) {
        PsiType type = parameter.getType();
        if (type instanceof PsiEllipsisType) {
            return ((PsiEllipsisType)type).getComponentType();
        }
        return type;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean notInferredType(PsiType typeByExpression) {
        return typeByExpression instanceof PsiMethodReferenceType || typeByExpression instanceof PsiLambdaExpressionType || typeByExpression instanceof PsiLambdaParameterType;
    }

    @NotNull
    public static PsiReturnStatement[] getReturnStatements(PsiLambdaExpression lambdaExpression) {
        PsiElement body = lambdaExpression.getBody();
        PsiReturnStatement[] psiReturnStatementArray = body instanceof PsiCodeBlock ? PsiUtil.findReturnStatements((PsiCodeBlock)body) : PsiReturnStatement.EMPTY_ARRAY;
        if (psiReturnStatementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/LambdaUtil", "getReturnStatements"));
        }
        return psiReturnStatementArray;
    }

    public static List<PsiExpression> getReturnExpressions(PsiLambdaExpression lambdaExpression) {
        PsiElement body = lambdaExpression.getBody();
        if (body instanceof PsiExpression) {
            return Collections.singletonList((PsiExpression)body);
        }
        ArrayList<PsiExpression> result = new ArrayList<PsiExpression>();
        for (PsiReturnStatement returnStatement : LambdaUtil.getReturnStatements(lambdaExpression)) {
            PsiExpression returnValue = returnStatement.getReturnValue();
            if (returnValue == null) continue;
            result.add(returnValue);
        }
        return result;
    }

    @Contract(value="null -> false")
    public static boolean isExpressionStatementExpression(PsiElement body) {
        return body instanceof PsiAssignmentExpression || body instanceof PsiPrefixExpression && (((PsiPrefixExpression)body).getOperationTokenType() == JavaTokenType.PLUSPLUS || ((PsiPrefixExpression)body).getOperationTokenType() == JavaTokenType.MINUSMINUS) || body instanceof PsiPostfixExpression || body instanceof PsiCallExpression || body instanceof PsiReferenceExpression && !body.isPhysical();
    }

    public static PsiExpression extractSingleExpressionFromBody(PsiElement body) {
        PsiExpression expression = null;
        if (body instanceof PsiExpression) {
            expression = (PsiExpression)body;
        } else if (body instanceof PsiCodeBlock) {
            PsiStatement[] statements = ((PsiCodeBlock)body).getStatements();
            if (statements.length == 1) {
                if (statements[0] instanceof PsiReturnStatement) {
                    expression = ((PsiReturnStatement)statements[0]).getReturnValue();
                } else if (statements[0] instanceof PsiExpressionStatement) {
                    expression = ((PsiExpressionStatement)statements[0]).getExpression();
                } else if (statements[0] instanceof PsiBlockStatement) {
                    return LambdaUtil.extractSingleExpressionFromBody(((PsiBlockStatement)statements[0]).getCodeBlock());
                }
            }
        } else {
            if (body instanceof PsiBlockStatement) {
                return LambdaUtil.extractSingleExpressionFromBody(((PsiBlockStatement)body).getCodeBlock());
            }
            if (body instanceof PsiExpressionStatement) {
                expression = ((PsiExpressionStatement)body).getExpression();
            }
        }
        return expression;
    }

    public static boolean isPotentiallyCompatibleWithTypeParameter(PsiFunctionalExpression expression, PsiExpressionList argsList, PsiMethod method) {
        PsiParameter[] parameters;
        PsiParameter lambdaParameter;
        PsiClass paramClass;
        PsiCallExpression callExpression;
        if (!(Registry.is("JDK8042508.bug.fixed", false) || (callExpression = PsiTreeUtil.getParentOfType((PsiElement)argsList, PsiCallExpression.class)) != null && callExpression.getTypeArguments().length <= 0)) {
            return false;
        }
        int lambdaIdx = LambdaUtil.getLambdaIdx(argsList, expression);
        return lambdaIdx >= 0 && (paramClass = PsiUtil.resolveClassInType((lambdaParameter = (parameters = method.getParameterList().getParameters())[Math.min(lambdaIdx, parameters.length - 1)]).getType())) instanceof PsiTypeParameter && ((PsiTypeParameter)paramClass).getOwner() == method;
    }

    @NotNull
    public static Map<PsiElement, PsiType> getFunctionalTypeMap() {
        Map<PsiElement, PsiType> map = ourFunctionTypes.get();
        if (map == null) {
            map = new HashMap<PsiElement, PsiType>();
            ourFunctionTypes.set(map);
        }
        Map<PsiElement, PsiType> map2 = map;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/LambdaUtil", "getFunctionalTypeMap"));
        }
        return map2;
    }

    public static Map<PsiElement, String> checkReturnTypeCompatible(PsiLambdaExpression lambdaExpression, PsiType functionalInterfaceReturnType) {
        LinkedHashMap<PsiElement, String> errors;
        block15: {
            errors = new LinkedHashMap<PsiElement, String>();
            if (PsiType.VOID.equals(functionalInterfaceReturnType)) {
                PsiElement body = lambdaExpression.getBody();
                if (body instanceof PsiCodeBlock) {
                    for (PsiExpression expression : LambdaUtil.getReturnExpressions(lambdaExpression)) {
                        errors.put(expression, "Unexpected return value");
                    }
                } else if (body instanceof PsiExpression) {
                    PsiType type = ((PsiExpression)body).getType();
                    try {
                        if (PsiUtil.isStatement(JavaPsiFacade.getElementFactory(body.getProject()).createStatementFromText(body.getText(), body))) break block15;
                        if (PsiType.VOID.equals(type)) {
                            errors.put(body, "Lambda body must be a statement expression");
                            break block15;
                        }
                        errors.put(body, "Bad return type in lambda expression: " + (type == PsiType.NULL || type == null ? "<null>" : type.getPresentableText()) + " cannot be converted to void");
                    }
                    catch (IncorrectOperationException expression) {}
                }
            } else if (functionalInterfaceReturnType != null) {
                List<PsiExpression> returnExpressions = LambdaUtil.getReturnExpressions(lambdaExpression);
                for (PsiExpression expression : returnExpressions) {
                    PsiType expressionType = PsiResolveHelper.ourGraphGuard.doPreventingRecursion(expression, true, () -> expression.getType());
                    if (expressionType == null || functionalInterfaceReturnType.isAssignableFrom(expressionType)) continue;
                    errors.put(expression, "Bad return type in lambda expression: " + expressionType.getPresentableText() + " cannot be converted to " + functionalInterfaceReturnType.getPresentableText());
                }
                PsiReturnStatement[] returnStatements = LambdaUtil.getReturnStatements(lambdaExpression);
                if (returnStatements.length > returnExpressions.size()) {
                    for (PsiReturnStatement statement : returnStatements) {
                        PsiExpression value = statement.getReturnValue();
                        if (value != null) continue;
                        errors.put(statement, "Missing return value");
                    }
                } else if (returnExpressions.isEmpty() && !lambdaExpression.isVoidCompatible()) {
                    errors.put(lambdaExpression, "Missing return value");
                }
            }
        }
        return errors.isEmpty() ? null : errors;
    }

    @Nullable
    public static PsiType getLambdaParameterFromType(PsiType functionalInterfaceType, int parameterIndex) {
        PsiParameter[] parameters;
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
        PsiMethod method = LambdaUtil.getFunctionalInterfaceMethod(functionalInterfaceType);
        if (method != null && parameterIndex < (parameters = method.getParameterList().getParameters()).length) {
            return LambdaUtil.getSubstitutor(method, resolveResult).substitute(parameters[parameterIndex].getType());
        }
        return null;
    }

    public static boolean isLambdaParameterCheck() {
        return !ourParameterGuard.currentStack().isEmpty();
    }

    @Nullable
    public static PsiCall treeWalkUp(PsiElement context) {
        PsiCall top = null;
        Object parent = PsiTreeUtil.getParentOfType(context, PsiExpressionList.class, PsiLambdaExpression.class, PsiConditionalExpression.class, PsiCodeBlock.class, PsiCall.class);
        while (!(parent instanceof PsiCall)) {
            MethodCandidateInfo.CurrentCandidateProperties properties;
            PsiCall psiCall;
            PsiLambdaExpression lambdaExpression = PsiTreeUtil.getParentOfType(parent, PsiLambdaExpression.class);
            if (parent instanceof PsiCodeBlock) {
                if (lambdaExpression == null) break;
                boolean inReturnExpressions = false;
                for (PsiExpression expression : LambdaUtil.getReturnExpressions(lambdaExpression)) {
                    inReturnExpressions |= PsiTreeUtil.isAncestor(expression, context, false);
                }
                if (!inReturnExpressions || LambdaUtil.getFunctionalTypeMap().containsKey(lambdaExpression)) break;
            }
            if (parent instanceof PsiConditionalExpression && !PsiPolyExpressionUtil.isPolyExpression((PsiExpression)parent) || parent instanceof PsiLambdaExpression && LambdaUtil.getFunctionalTypeMap().containsKey(parent) || (psiCall = PsiTreeUtil.getParentOfType(parent, PsiCall.class, false, new Class[]{PsiMember.class, PsiVariable.class})) == null || (properties = MethodCandidateInfo.getCurrentMethod(psiCall.getArgumentList())) != null && (properties.isApplicabilityCheck() || lambdaExpression != null) || !((top = psiCall) instanceof PsiExpression) || !PsiPolyExpressionUtil.isPolyExpression((PsiExpression)((Object)top))) break;
            parent = PsiTreeUtil.getParentOfType(parent.getParent(), PsiExpressionList.class, PsiLambdaExpression.class, PsiCodeBlock.class);
        }
        if (top == null) {
            return null;
        }
        PsiExpressionList argumentList = top.getArgumentList();
        if (argumentList == null) {
            return null;
        }
        LOG.assertTrue(MethodCandidateInfo.getCurrentMethod(argumentList) == null);
        return top;
    }

    public static PsiCall copyTopLevelCall(@NotNull PsiCall call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/psi/LambdaUtil", "copyTopLevelCall"));
        }
        PsiCall copyCall = (PsiCall)call.copy();
        if (call instanceof PsiEnumConstant) {
            PsiClass containingClass = ((PsiEnumConstant)call).getContainingClass();
            if (containingClass == null) {
                return null;
            }
            String enumName = containingClass.getName();
            if (enumName == null) {
                return null;
            }
            PsiMethod resolveMethod = call.resolveMethod();
            if (resolveMethod == null) {
                return null;
            }
            PsiClass anEnum = JavaPsiFacade.getElementFactory(call.getProject()).createEnum(enumName);
            anEnum.add(resolveMethod);
            return (PsiCall)anEnum.add(call);
        }
        return copyCall;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T performWithSubstitutedParameterBounds(PsiTypeParameter[] typeParameters, PsiSubstitutor substitutor, Producer<T> producer) {
        try {
            for (PsiTypeParameter parameter : typeParameters) {
                PsiClassType[] types = parameter.getExtendsListTypes();
                if (types.length <= 0) continue;
                List<PsiType> conjuncts = ContainerUtil.map(types, type -> substitutor.substitute((PsiType)type));
                PsiType upperBound = PsiIntersectionType.createIntersection(false, conjuncts.toArray(new PsiType[conjuncts.size()]));
                LambdaUtil.getFunctionalTypeMap().put(parameter, upperBound);
            }
            T t = producer.produce();
            return t;
        }
        finally {
            for (PsiTypeParameter parameter : typeParameters) {
                LambdaUtil.getFunctionalTypeMap().remove(parameter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T performWithLambdaTargetType(PsiLambdaExpression lambdaExpression, PsiType targetType, Producer<T> producer) {
        try {
            LambdaUtil.getFunctionalTypeMap().put(lambdaExpression, targetType);
            T t = producer.produce();
            return t;
        }
        finally {
            LambdaUtil.getFunctionalTypeMap().remove(lambdaExpression);
        }
    }

    public static String createLambda(@NotNull PsiVariable variable, @NotNull PsiExpression expression) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/psi/LambdaUtil", "createLambda"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/psi/LambdaUtil", "createLambda"));
        }
        return variable.getName() + " -> " + expression.getText();
    }

    public static boolean isIdentityLambda(PsiLambdaExpression lambda2) {
        PsiParameterList parameters = lambda2.getParameterList();
        if (parameters.getParametersCount() != 1) {
            return false;
        }
        PsiExpression expression = PsiUtil.skipParenthesizedExprDown(LambdaUtil.extractSingleExpressionFromBody(lambda2.getBody()));
        return expression instanceof PsiReferenceExpression && ((PsiReferenceExpression)expression).isReferenceTo(parameters.getParameters()[0]);
    }

    public static class TypeParamsChecker
    extends PsiTypeVisitor<Boolean> {
        private PsiMethod myMethod;
        private final PsiClass myClass;
        public final Set<PsiTypeParameter> myUsedTypeParams = new HashSet<PsiTypeParameter>();

        public TypeParamsChecker(PsiElement expression, PsiClass aClass) {
            PsiElement gParent;
            PsiElement parent;
            this.myClass = aClass;
            PsiElement psiElement = parent = expression != null ? expression.getParent() : null;
            while (parent instanceof PsiParenthesizedExpression) {
                parent = parent.getParent();
            }
            if (parent instanceof PsiExpressionList && (gParent = parent.getParent()) instanceof PsiCall) {
                MethodCandidateInfo.CurrentCandidateProperties pair = MethodCandidateInfo.getCurrentMethod(parent);
                PsiMethod psiMethod = this.myMethod = pair != null ? pair.getMethod() : null;
                if (this.myMethod == null) {
                    this.myMethod = ((PsiCall)gParent).resolveMethod();
                }
                if (this.myMethod != null && PsiTreeUtil.isAncestor(this.myMethod, expression, false)) {
                    this.myMethod = null;
                }
            }
        }

        public boolean startedInference() {
            return this.myMethod != null;
        }

        @Override
        public Boolean visitClassType(PsiClassType classType) {
            PsiTypeParameter typeParameter;
            boolean used = false;
            for (PsiType paramType : classType.getParameters()) {
                Boolean paramAccepted = paramType.accept(this);
                used |= paramAccepted != null && paramAccepted != false;
            }
            PsiClass resolve = classType.resolve();
            if (resolve instanceof PsiTypeParameter && this.check(typeParameter = (PsiTypeParameter)resolve)) {
                this.myUsedTypeParams.add(typeParameter);
                return true;
            }
            return used;
        }

        @Override
        @Nullable
        public Boolean visitWildcardType(PsiWildcardType wildcardType) {
            PsiType bound = wildcardType.getBound();
            if (bound != null) {
                return bound.accept(this);
            }
            return false;
        }

        @Override
        @Nullable
        public Boolean visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
            return true;
        }

        @Override
        @Nullable
        public Boolean visitLambdaExpressionType(PsiLambdaExpressionType lambdaExpressionType) {
            return true;
        }

        @Override
        @Nullable
        public Boolean visitArrayType(PsiArrayType arrayType) {
            return arrayType.getComponentType().accept(this);
        }

        @Override
        public Boolean visitType(PsiType type) {
            return false;
        }

        private boolean check(PsiTypeParameter check) {
            PsiTypeParameterListOwner owner = check.getOwner();
            return owner == this.myMethod || owner == this.myClass;
        }

        public boolean used(PsiTypeParameter ... parameters) {
            for (PsiTypeParameter parameter : parameters) {
                if (!this.myUsedTypeParams.contains(parameter)) continue;
                return true;
            }
            return false;
        }
    }
}

