/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.callMatcher;

import com.intellij.psi.PsiMethodCallExpression;
import com.siyeh.ig.callMatcher.CallMatcher;
import java.util.function.Function;

public class CallHandler<T>
implements Function<PsiMethodCallExpression, T> {
    private final CallMatcher myMatcher;
    private final Function<PsiMethodCallExpression, T> myTransformer;

    public CallHandler(CallMatcher matcher, Function<PsiMethodCallExpression, T> transformer) {
        this.myMatcher = matcher;
        this.myTransformer = transformer;
    }

    public final CallMatcher matcher() {
        return this.myMatcher;
    }

    @Override
    public T apply(PsiMethodCallExpression call) {
        return this.matcher().test(call) ? (T)this.myTransformer.apply(call) : null;
    }

    public static <T> CallHandler<T> of(CallMatcher matcher, Function<PsiMethodCallExpression, T> transformer) {
        return new CallHandler<T>(matcher, transformer);
    }
}

