/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.TestFramework;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestUtils {
    public static final String RUN_WITH = "org.junit.runner.RunWith";

    private TestUtils() {
    }

    public static boolean isInTestSourceContent(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiFile file = element.getContainingFile();
        VirtualFile virtualFile = file == null ? null : file.getVirtualFile();
        return virtualFile != null && ProjectRootManager.getInstance(file.getProject()).getFileIndex().isInTestSourceContent(virtualFile);
    }

    public static boolean isPartOfJUnitTestMethod(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/TestUtils", "isPartOfJUnitTestMethod"));
        }
        PsiMethod method = PsiTreeUtil.getParentOfType(element, PsiMethod.class, false);
        return method != null && TestUtils.isJUnitTestMethod(method);
    }

    public static boolean isJUnit4BeforeOrAfterMethod(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/psiutils/TestUtils", "isJUnit4BeforeOrAfterMethod"));
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)method, "org.junit.Before", true) || AnnotationUtil.isAnnotated((PsiModifierListOwner)method, "org.junit.After", true);
    }

    public static boolean isJUnit4BeforeClassOrAfterClassMethod(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/psiutils/TestUtils", "isJUnit4BeforeClassOrAfterClassMethod"));
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)method, "org.junit.BeforeClass", true) || AnnotationUtil.isAnnotated((PsiModifierListOwner)method, "org.junit.AfterClass", true);
    }

    public static boolean isJUnitTestMethod(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        TestFramework framework = TestFrameworks.detectFramework(containingClass);
        return framework != null && framework.getName().startsWith("JUnit") && framework.isTestMethod(method);
    }

    public static boolean isRunnable(PsiMethod method) {
        if (method == null) {
            return false;
        }
        if (method.hasModifierProperty("abstract") || method.hasModifierProperty("static") || !method.hasModifierProperty("public")) {
            return false;
        }
        PsiType returnType = method.getReturnType();
        if (!PsiType.VOID.equals(returnType)) {
            return false;
        }
        PsiParameterList parameterList = method.getParameterList();
        return parameterList.getParametersCount() == 0;
    }

    public static boolean isJUnit3TestMethod(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        String methodName = method.getName();
        String test = "test";
        if (!methodName.startsWith("test")) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        return TestUtils.isJUnitTestClass(containingClass);
    }

    public static boolean isJUnit4TestMethod(@Nullable PsiMethod method) {
        return method != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)method, "org.junit.Test", true);
    }

    public static boolean isAnnotatedTestMethod(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        TestFramework testFramework = TestFrameworks.detectFramework(containingClass);
        if (testFramework == null) {
            return false;
        }
        if (testFramework.isTestMethod(method)) {
            String testFrameworkName = testFramework.getName();
            return testFrameworkName.equals("JUnit4") || testFrameworkName.equals("JUnit5");
        }
        return false;
    }

    public static boolean isJUnitTestClass(@Nullable PsiClass targetClass) {
        return targetClass != null && InheritanceUtil.isInheritor(targetClass, "junit.framework.TestCase");
    }

    public static boolean isJUnit4TestClass(@Nullable PsiClass aClass, boolean runWithIsTestClass) {
        if (aClass == null) {
            return false;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, RUN_WITH, true)) {
            return runWithIsTestClass;
        }
        for (PsiMethod method : aClass.getAllMethods()) {
            if (!TestUtils.isJUnit4TestMethod(method)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInTestCode(PsiElement element) {
        if (TestUtils.isPartOfJUnitTestMethod(element)) {
            return true;
        }
        PsiClass containingClass = PsiTreeUtil.getParentOfType(element, PsiClass.class);
        if (containingClass != null && TestFrameworks.getInstance().isTestOrConfig(containingClass)) {
            return true;
        }
        return TestUtils.isInTestSourceContent(element);
    }
}

