/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention;

import com.intellij.AbstractBundle;
import com.intellij.CommonBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.CustomLoadingExtensionPointBean;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntentionActionBean
extends CustomLoadingExtensionPointBean {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.intention.IntentionActionBean");
    @Tag(value="className")
    public String className;
    @Tag(value="category")
    public String category;
    @Tag(value="categoryKey")
    public String categoryKey;
    @Tag(value="bundleName")
    public String bundleName;
    @Tag(value="descriptionDirectoryName")
    public String descriptionDirectoryName;

    @Nullable
    public String[] getCategories() {
        if (this.categoryKey != null) {
            String baseName;
            String string = baseName = this.bundleName != null ? this.bundleName : ((IdeaPluginDescriptor)this.myPluginDescriptor).getResourceBundleBaseName();
            if (baseName == null) {
                LOG.error("No resource bundle specified for " + this.myPluginDescriptor);
            }
            ResourceBundle bundle = AbstractBundle.getResourceBundle(baseName, this.myPluginDescriptor.getPluginClassLoader());
            String[] keys = this.categoryKey.split("/");
            if (keys.length > 1) {
                return ContainerUtil.map2Array(keys, String.class, s -> CommonBundle.message(bundle, s, new Object[0]));
            }
            this.category = CommonBundle.message(bundle, this.categoryKey, new Object[0]);
        }
        if (this.category == null) {
            return null;
        }
        return this.category.split("/");
    }

    public String getDescriptionDirectoryName() {
        return this.descriptionDirectoryName;
    }

    @NotNull
    public IntentionAction instantiate() throws ClassNotFoundException {
        IntentionAction intentionAction = (IntentionAction)this.instantiateExtension(this.className, ApplicationManager.getApplication().getPicoContainer());
        if (intentionAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/IntentionActionBean", "instantiate"));
        }
        return intentionAction;
    }

    public ClassLoader getMetadataClassLoader() {
        return this.myPluginDescriptor.getPluginClassLoader();
    }
}

