/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.RemoveSuppressWarningAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaModule;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantSuppressInspectionBase
extends GlobalInspectionTool {
    private BidirectionalMap<String, QuickFix> myQuickFixes;
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.RedundantSuppressInspection");
    public boolean IGNORE_ALL;

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.DECLARATION_REDUNDANCY;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/RedundantSuppressInspectionBase", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message("inspection.redundant.suppression.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/RedundantSuppressInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    @NonNls
    public String getShortName() {
        if ("RedundantSuppression" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/RedundantSuppressInspectionBase", "getShortName"));
        }
        return "RedundantSuppression";
    }

    @Override
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Ignore '@SuppressWarning(\"ALL\")'", this, "IGNORE_ALL");
    }

    @Override
    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/RedundantSuppressInspectionBase", "writeSettings"));
        }
        if (this.IGNORE_ALL) {
            super.writeSettings(node);
        }
    }

    @Override
    public void runInspection(@NotNull AnalysisScope scope, final @NotNull InspectionManager manager, final @NotNull GlobalInspectionContext globalContext, final @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/RedundantSuppressInspectionBase", "runInspection"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/RedundantSuppressInspectionBase", "runInspection"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "com/intellij/codeInspection/RedundantSuppressInspectionBase", "runInspection"));
        }
        if (problemDescriptionsProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemDescriptionsProcessor", "com/intellij/codeInspection/RedundantSuppressInspectionBase", "runInspection"));
        }
        globalContext.getRefManager().iterate(new RefJavaVisitor(){

            @Override
            public void visitJavaModule(@NotNull RefJavaModule javaModule) {
                if (javaModule == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaModule", "com/intellij/codeInspection/RedundantSuppressInspectionBase$1", "visitJavaModule"));
                }
                this.visitElement(javaModule);
            }

            @Override
            public void visitClass(@NotNull RefClass refClass) {
                if (refClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refClass", "com/intellij/codeInspection/RedundantSuppressInspectionBase$1", "visitClass"));
                }
                this.visitElement(refClass);
            }

            private void visitElement(@NotNull RefElement refElement) {
                ProblemDescriptor[] descriptors;
                if (refElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElement", "com/intellij/codeInspection/RedundantSuppressInspectionBase$1", "visitElement"));
                }
                if (!globalContext.shouldCheck(refElement, RedundantSuppressInspectionBase.this)) {
                    return;
                }
                PsiElement element = refElement.getElement();
                if (element == null) {
                    return;
                }
                for (ProblemDescriptor descriptor : descriptors = RedundantSuppressInspectionBase.this.checkElement(element, manager)) {
                    if (descriptor instanceof ProblemDescriptor) {
                        PsiElement psiElement = descriptor.getPsiElement();
                        PsiMember member = PsiTreeUtil.getParentOfType(psiElement, PsiMember.class);
                        RefElement reference = globalContext.getRefManager().getReference(member);
                        if (reference != null) {
                            problemDescriptionsProcessor.addProblemElement(reference, descriptor);
                            continue;
                        }
                    }
                    problemDescriptionsProcessor.addProblemElement(refElement, descriptor);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ProblemDescriptor[] checkElement(final @NotNull PsiElement psiElement, @NotNull InspectionManager manager) {
        ArrayList<ProblemDescriptor> result;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInspection/RedundantSuppressInspectionBase", "checkElement"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/RedundantSuppressInspectionBase", "checkElement"));
        }
        THashMap suppressedScopes = new THashMap();
        psiElement.accept(new JavaRecursiveElementWalkingVisitor((Map)suppressedScopes){
            final /* synthetic */ Map val$suppressedScopes;
            {
                this.val$suppressedScopes = map;
            }

            @Override
            public void visitModifierList(PsiModifierList list) {
                super.visitModifierList(list);
                PsiElement parent = list.getParent();
                if (parent instanceof PsiModifierListOwner && !(parent instanceof PsiClass)) {
                    this.checkElement(parent);
                }
            }

            @Override
            public void visitComment(PsiComment comment) {
                this.checkElement(comment);
            }

            @Override
            public void visitClass(PsiClass aClass) {
                if (aClass == psiElement) {
                    super.visitClass(aClass);
                    this.checkElement(aClass);
                }
            }

            private void checkElement(PsiElement owner) {
                String idsString = JavaSuppressionUtil.getSuppressedInspectionIdsIn(owner);
                if (idsString != null && !idsString.isEmpty()) {
                    List<String> ids = StringUtil.split(idsString, ",");
                    if (RedundantSuppressInspectionBase.this.IGNORE_ALL && (ids.contains("ALL") || ids.contains("ALL".toLowerCase()))) {
                        return;
                    }
                    List<String> suppressed = (List<String>)this.val$suppressedScopes.get(owner);
                    if (suppressed == null) {
                        suppressed = ids;
                    } else {
                        for (String id : ids) {
                            if (suppressed.contains(id)) continue;
                            suppressed.add(id);
                        }
                    }
                    this.val$suppressedScopes.put(owner, suppressed);
                }
            }
        });
        if (suppressedScopes.values().isEmpty()) {
            if (ProblemDescriptor.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/RedundantSuppressInspectionBase", "checkElement"));
            }
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        THashMap suppressedTools = new THashMap();
        InspectionToolWrapper[] toolWrappers = this.getInspectionTools(psiElement, manager);
        for (Collection ids : suppressedScopes.values()) {
            Iterator iterator = ids.iterator();
            block4: while (iterator.hasNext()) {
                String shortName = ((String)iterator.next()).trim();
                for (InspectionToolWrapper toolWrapper : toolWrappers) {
                    if (toolWrapper instanceof LocalInspectionToolWrapper && (((LocalInspectionTool)((LocalInspectionToolWrapper)toolWrapper).getTool()).getID().equals(shortName) || shortName.equals(((LocalInspectionTool)((LocalInspectionToolWrapper)toolWrapper).getTool()).getAlternativeID()))) {
                        if (((LocalInspectionToolWrapper)toolWrapper).isUnfair()) {
                            iterator.remove();
                            continue block4;
                        }
                        suppressedTools.put(toolWrapper, shortName);
                        continue;
                    }
                    if (!toolWrapper.getShortName().equals(shortName)) continue;
                    if (toolWrapper instanceof LocalInspectionToolWrapper || toolWrapper instanceof GlobalInspectionToolWrapper && !((GlobalInspectionTool)((GlobalInspectionToolWrapper)toolWrapper).getTool()).isGraphNeeded()) {
                        suppressedTools.put(toolWrapper, shortName);
                        continue;
                    }
                    iterator.remove();
                    continue block4;
                }
            }
        }
        PsiFile file = psiElement.getContainingFile();
        AnalysisScope scope = new AnalysisScope(file);
        GlobalInspectionContextBase globalContext = this.createContext(file);
        globalContext.setCurrentScope(scope);
        RefManagerImpl refManager = (RefManagerImpl)globalContext.getRefManager();
        refManager.inspectionReadActionStarted();
        try {
            result = new ArrayList<ProblemDescriptor>();
            for (InspectionToolWrapper toolWrapper : suppressedTools.keySet()) {
                Object global;
                ArrayList<Object> descriptors;
                String toolId = (String)suppressedTools.get(toolWrapper);
                toolWrapper.initialize(globalContext);
                if (toolWrapper instanceof LocalInspectionToolWrapper) {
                    LocalInspectionToolWrapper local = (LocalInspectionToolWrapper)toolWrapper;
                    if (local.isUnfair()) continue;
                    List<ProblemDescriptor> results = ((LocalInspectionTool)local.getTool()).processFile(file, manager);
                    descriptors = new ArrayList<ProblemDescriptor>(results);
                } else {
                    GlobalInspectionTool globalTool;
                    if (!(toolWrapper instanceof GlobalInspectionToolWrapper) || (globalTool = (GlobalInspectionTool)((InspectionToolWrapper)(global = (GlobalInspectionToolWrapper)toolWrapper)).getTool()).isGraphNeeded()) continue;
                    descriptors = new ArrayList();
                    globalContext.getRefManager().iterate(new RefVisitor((GlobalInspectionToolWrapper)global, scope, manager, globalContext, descriptors){
                        final /* synthetic */ GlobalInspectionToolWrapper val$global;
                        final /* synthetic */ AnalysisScope val$scope;
                        final /* synthetic */ InspectionManager val$manager;
                        final /* synthetic */ GlobalInspectionContextBase val$globalContext;
                        final /* synthetic */ Collection val$descriptors;
                        {
                            this.val$global = globalInspectionToolWrapper;
                            this.val$scope = analysisScope;
                            this.val$manager = inspectionManager;
                            this.val$globalContext = globalInspectionContextBase;
                            this.val$descriptors = collection;
                        }

                        @Override
                        public void visitElement(@NotNull RefEntity refEntity) {
                            if (refEntity == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/RedundantSuppressInspectionBase$3", "visitElement"));
                            }
                            CommonProblemDescriptor[] descriptors1 = ((GlobalInspectionTool)this.val$global.getTool()).checkElement(refEntity, this.val$scope, this.val$manager, this.val$globalContext, new ProblemDescriptionsProcessor(){});
                            if (descriptors1 != null) {
                                ContainerUtil.addAll(this.val$descriptors, descriptors1);
                            }
                        }
                    });
                }
                global = suppressedScopes.keySet().iterator();
                block7: while (global.hasNext()) {
                    PsiElement suppressedScope = (PsiElement)global.next();
                    Collection suppressedIds = (Collection)suppressedScopes.get(suppressedScope);
                    if (!suppressedIds.contains(toolId)) continue;
                    for (CommonProblemDescriptor commonProblemDescriptor : descriptors) {
                        PsiElement annotation;
                        PsiElement element;
                        if (!(commonProblemDescriptor instanceof ProblemDescriptor) || (element = ((ProblemDescriptor)commonProblemDescriptor).getPsiElement()) == null || ((annotation = JavaSuppressionUtil.getElementToolSuppressedIn(element, toolId)) == null || !PsiTreeUtil.isAncestor(suppressedScope, annotation, false)) && (annotation != null || PsiTreeUtil.isAncestor(suppressedScope, element, false))) continue;
                        suppressedIds.remove(toolId);
                        continue block7;
                    }
                }
            }
            for (PsiElement suppressedScope : suppressedScopes.keySet()) {
                Collection suppressedIds = (Collection)suppressedScopes.get(suppressedScope);
                for (String toolId : suppressedIds) {
                    PsiElement identifier;
                    String string;
                    QuickFix fix;
                    PsiJavaDocumentedElement documentedElement;
                    String problemLine = null;
                    if (suppressedScope instanceof PsiJavaDocumentedElement) {
                        documentedElement = (PsiJavaDocumentedElement)suppressedScope;
                    } else {
                        documentedElement = PsiTreeUtil.getParentOfType(suppressedScope, PsiJavaDocumentedElement.class);
                        PsiStatement statement = PsiTreeUtil.getNextSiblingOfType(suppressedScope, PsiStatement.class);
                        String string2 = problemLine = statement != null ? statement.getText() : null;
                    }
                    if (documentedElement == null || !documentedElement.isValid()) continue;
                    String description = InspectionsBundle.message("inspection.redundant.suppression.description", new Object[0]);
                    if (this.myQuickFixes == null) {
                        this.myQuickFixes = new BidirectionalMap();
                    }
                    if ((fix = this.myQuickFixes.get(string = toolId + (problemLine != null ? ";" + problemLine : ""))) == null) {
                        fix = new RemoveSuppressWarningAction(toolId, problemLine);
                        this.myQuickFixes.put(string, fix);
                    }
                    if ((identifier = suppressedScope instanceof PsiNameIdentifierOwner && suppressedScope instanceof PsiJavaDocumentedElement ? ((PsiNameIdentifierOwner)suppressedScope).getNameIdentifier() : suppressedScope) == null) {
                        identifier = documentedElement;
                    }
                    result.add(manager.createProblemDescriptor(identifier, description, (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false));
                }
            }
        }
        finally {
            refManager.inspectionReadActionFinished();
            globalContext.close(true);
        }
        ProblemDescriptor[] problemDescriptorArray = result.toArray(new ProblemDescriptor[result.size()]);
        if (problemDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/RedundantSuppressInspectionBase", "checkElement"));
        }
        return problemDescriptorArray;
    }

    protected GlobalInspectionContextBase createContext(PsiFile file) {
        return new GlobalInspectionContextBase(file.getProject());
    }

    @NotNull
    protected InspectionToolWrapper[] getInspectionTools(PsiElement psiElement, @NotNull InspectionManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/RedundantSuppressInspectionBase", "getInspectionTools"));
        }
        InspectionToolWrapper[] inspectionToolWrapperArray = new InspectionProfileModifiableModel(InspectionProjectProfileManager.getInstance(manager.getProject()).getCurrentProfile()).getInspectionTools(psiElement);
        if (inspectionToolWrapperArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/RedundantSuppressInspectionBase", "getInspectionTools"));
        }
        return inspectionToolWrapperArray;
    }

    @Override
    @Nullable
    public QuickFix getQuickFix(String hint) {
        return this.myQuickFixes != null ? this.myQuickFixes.get(hint) : new RemoveSuppressWarningAction(hint);
    }

    @Override
    @Nullable
    public String getHint(@NotNull QuickFix fix) {
        List<String> list;
        if (fix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fix", "com/intellij/codeInspection/RedundantSuppressInspectionBase", "getHint"));
        }
        if (this.myQuickFixes != null && (list = this.myQuickFixes.getKeysByValue(fix)) != null) {
            LOG.assertTrue(list.size() == 1);
            return list.get(0);
        }
        return null;
    }

    @Override
    public boolean isEnabledByDefault() {
        return false;
    }
}

