/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.concurrencyAnnotations;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.concurrencyAnnotations.JCiPUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class NonFinalFieldInImmutableInspection
extends BaseJavaBatchLocalInspectionTool {
    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.CONCURRENCY_ANNOTATION_ISSUES;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/concurrencyAnnotations/NonFinalFieldInImmutableInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Non-final field in @Immutable class" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/concurrencyAnnotations/NonFinalFieldInImmutableInspection", "getDisplayName"));
        }
        return "Non-final field in @Immutable class";
    }

    @Override
    @NotNull
    public String getShortName() {
        if ("NonFinalFieldInImmutable" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/concurrencyAnnotations/NonFinalFieldInImmutableInspection", "getShortName"));
        }
        return "NonFinalFieldInImmutable";
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/concurrencyAnnotations/NonFinalFieldInImmutableInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitField(PsiField field) {
                super.visitField(field);
                if (field.hasModifierProperty("final")) {
                    return;
                }
                PsiClass containingClass = field.getContainingClass();
                if (containingClass != null) {
                    if (!JCiPUtil.isImmutable(containingClass)) {
                        return;
                    }
                    holder.registerProblem((PsiElement)field.getNameIdentifier(), "Non-final field <code>#ref</code> in @Immutable class  #loc", new LocalQuickFix[0]);
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/concurrencyAnnotations/NonFinalFieldInImmutableInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }
}

