/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.rangeSet;

import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaRangeValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.util.ThreeState;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.jetbrains.annotations.Nullable;

public abstract class LongRangeSet {
    LongRangeSet() {
    }

    public abstract LongRangeSet subtract(LongRangeSet var1);

    public LongRangeSet without(long value) {
        return this.subtract(LongRangeSet.point(value));
    }

    public boolean isEmpty() {
        return this == Empty.EMPTY;
    }

    public abstract LongRangeSet intersect(LongRangeSet var1);

    public LongRangeSet union(LongRangeSet other) {
        if (other.isEmpty() || other == this) {
            return this;
        }
        if (other.contains(this)) {
            return other;
        }
        return Range.LONG_RANGE.subtract(Range.LONG_RANGE.subtract(this).intersect(Range.LONG_RANGE.subtract(other)));
    }

    public abstract long min();

    public abstract long max();

    public abstract boolean intersects(LongRangeSet var1);

    public abstract boolean contains(long var1);

    public abstract boolean contains(LongRangeSet var1);

    public LongRangeSet fromRelation(@Nullable DfaRelationValue.RelationType relation) {
        if (this.isEmpty() || relation == null) {
            return null;
        }
        switch (relation) {
            case EQ: {
                return this;
            }
            case NE: {
                long min = this.min();
                if (min == this.max()) {
                    return LongRangeSet.all().without(min);
                }
                return LongRangeSet.all();
            }
            case GT: {
                long min = this.min();
                return min == Long.MAX_VALUE ? LongRangeSet.empty() : LongRangeSet.range(min + 1L, Long.MAX_VALUE);
            }
            case GE: {
                return LongRangeSet.range(this.min(), Long.MAX_VALUE);
            }
            case LE: {
                return LongRangeSet.range(Long.MIN_VALUE, this.max());
            }
            case LT: {
                long max = this.max();
                return max == Long.MIN_VALUE ? LongRangeSet.empty() : LongRangeSet.range(Long.MIN_VALUE, max - 1L);
            }
        }
        return null;
    }

    public abstract LongRangeSet abs(boolean var1);

    public LongRangeSet bitwiseAnd(LongRangeSet other) {
        if (this.isEmpty() || other.isEmpty()) {
            return LongRangeSet.empty();
        }
        long[] left = LongRangeSet.splitAtZero(this.asRanges());
        long[] right = LongRangeSet.splitAtZero(other.asRanges());
        if (left.length > 6) {
            left = LongRangeSet.splitAtZero(new long[]{left[0], left[left.length - 1]});
        }
        if (right.length > 6) {
            right = LongRangeSet.splitAtZero(new long[]{right[0], right[right.length - 1]});
        }
        LongRangeSet result = LongRangeSet.all();
        for (int i2 = 0; i2 < left.length; i2 += 2) {
            for (int j = 0; j < right.length; j += 2) {
                result = result.subtract(LongRangeSet.bitwiseAnd(left[i2], left[i2 + 1], right[j], right[j + 1]));
            }
        }
        return LongRangeSet.all().subtract(result);
    }

    private static long[] splitAtZero(long[] ranges) {
        for (int i2 = 0; i2 < ranges.length; i2 += 2) {
            if (ranges[i2] >= 0L || ranges[i2 + 1] < 0L) continue;
            long[] result = new long[ranges.length + 2];
            System.arraycopy(ranges, 0, result, 0, i2 + 1);
            result[i2 + 1] = -1L;
            System.arraycopy(ranges, i2 + 1, result, i2 + 3, ranges.length - i2 - 1);
            return result;
        }
        return ranges;
    }

    private static LongRangeSet bitwiseAnd(long leftFrom, long leftTo, long rightFrom, long rightTo) {
        if (leftFrom == leftTo && rightFrom == rightTo) {
            return LongRangeSet.point(leftFrom & rightFrom);
        }
        ThreeState[] leftBits = LongRangeSet.bits(leftFrom, leftTo);
        ThreeState[] rightBits = LongRangeSet.bits(rightFrom, rightTo);
        ThreeState[] resultBits = new ThreeState[64];
        for (int i2 = 0; i2 < 64; ++i2) {
            resultBits[i2] = leftBits[i2] == ThreeState.NO || rightBits[i2] == ThreeState.NO ? ThreeState.NO : (leftBits[i2] == ThreeState.UNSURE || rightBits[i2] == ThreeState.UNSURE ? ThreeState.UNSURE : ThreeState.YES);
        }
        return LongRangeSet.fromBits(resultBits);
    }

    private static LongRangeSet fromBits(ThreeState[] bits) {
        int j;
        int i2;
        long from = 0L;
        for (i2 = 0; i2 < 64 && bits[i2] != ThreeState.UNSURE; ++i2) {
            if (bits[i2] != ThreeState.YES) continue;
            from |= 1L << 63 - i2;
        }
        long to = (1L << 64 - i2) - 1L | from;
        for (j = 63; j > i2 && bits[j] != ThreeState.UNSURE; --j) {
            if (bits[j] != ThreeState.NO) continue;
            to &= 1L << 63 - j ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (i2 == j) {
            return LongRangeSet.point(from).union(LongRangeSet.point(to));
        }
        return from < to ? LongRangeSet.range(from, to) : LongRangeSet.range(to, from);
    }

    private static ThreeState[] bits(long from, long to) {
        ThreeState[] bits = new ThreeState[64];
        Arrays.setAll(bits, idx -> ThreeState.NO);
        while (true) {
            int toBit;
            int fromBit;
            if ((fromBit = Long.numberOfLeadingZeros(from)) != (toBit = Long.numberOfLeadingZeros(to))) {
                for (int i2 = Math.min(fromBit, toBit); i2 < 64; ++i2) {
                    bits[i2] = ThreeState.UNSURE;
                }
                break;
            }
            if (fromBit == 64) break;
            bits[fromBit] = ThreeState.YES;
            long clearMask = 1L << 63 - fromBit ^ 0xFFFFFFFFFFFFFFFFL;
            from &= clearMask;
            to &= clearMask;
        }
        return bits;
    }

    public abstract LongStream stream();

    public static LongRangeSet empty() {
        return Empty.EMPTY;
    }

    public static LongRangeSet all() {
        return Range.LONG_RANGE;
    }

    public static LongRangeSet point(long value) {
        return new Point(value);
    }

    @Nullable
    public static LongRangeSet fromConstant(Object val) {
        if (val instanceof Byte || val instanceof Short || val instanceof Integer || val instanceof Long) {
            return LongRangeSet.point(((Number)val).longValue());
        }
        if (val instanceof Character) {
            return LongRangeSet.point(((Character)val).charValue());
        }
        return null;
    }

    @Nullable
    public static LongRangeSet fromDfaValue(DfaValue value) {
        if (value instanceof DfaRangeValue) {
            return ((DfaRangeValue)value).getValue();
        }
        if (value instanceof DfaConstValue) {
            return LongRangeSet.fromConstant(((DfaConstValue)value).getValue());
        }
        if (value instanceof DfaVariableValue) {
            return LongRangeSet.fromType(((DfaVariableValue)value).getVariableType());
        }
        return null;
    }

    public static LongRangeSet range(long from, long to) {
        return from == to ? new Point(from) : new Range(from, to);
    }

    abstract long[] asRanges();

    static String toString(long from, long to) {
        return from == to ? String.valueOf(from) : from + (to - from == 1L ? ", " : "..") + to;
    }

    static long minValue(boolean isLong) {
        return isLong ? Long.MIN_VALUE : Integer.MIN_VALUE;
    }

    public static LongRangeSet indexRange() {
        return Range.INDEX_RANGE;
    }

    @Nullable
    public static LongRangeSet fromType(PsiType type) {
        if (type == null) {
            return null;
        }
        if ((type = PsiPrimitiveType.getOptionallyUnboxedType(type)) != null) {
            if (type.equals(PsiType.BYTE)) {
                return Range.BYTE_RANGE;
            }
            if (type.equals(PsiType.CHAR)) {
                return Range.CHAR_RANGE;
            }
            if (type.equals(PsiType.SHORT)) {
                return Range.SHORT_RANGE;
            }
            if (type.equals(PsiType.INT)) {
                return Range.INT_RANGE;
            }
            if (type.equals(PsiType.LONG)) {
                return LongRangeSet.all();
            }
        }
        return null;
    }

    static LongRangeSet fromRanges(long[] ranges, int bound) {
        if (bound == 0) {
            return Empty.EMPTY;
        }
        if (bound == 2) {
            return LongRangeSet.range(ranges[0], ranges[1]);
        }
        return new RangeSet(Arrays.copyOfRange(ranges, 0, bound));
    }

    static final class RangeSet
    extends LongRangeSet {
        final long[] myRanges;

        RangeSet(long[] ranges) {
            if (ranges.length < 4 || ranges.length % 2 != 0) {
                throw new IllegalArgumentException("Bad length: " + ranges.length + " " + Arrays.toString(ranges));
            }
            for (int i2 = 0; i2 < ranges.length; i2 += 2) {
                if (ranges[i2 + 1] < ranges[i2]) {
                    throw new IllegalArgumentException("Bad sub-range #" + i2 / 2 + " " + Arrays.toString(ranges));
                }
                if (i2 <= 0 || ranges[i2 - 1] != Long.MAX_VALUE && 1L + ranges[i2 - 1] <= ranges[i2]) continue;
                throw new IllegalArgumentException("Bad sub-ranges #" + (i2 / 2 - 1) + " and #" + i2 / 2 + " " + Arrays.toString(ranges));
            }
            this.myRanges = ranges;
        }

        @Override
        public LongRangeSet subtract(LongRangeSet other) {
            if (other.isEmpty()) {
                return this;
            }
            if (other == this) {
                return Empty.EMPTY;
            }
            long[] result = new long[this.myRanges.length + other.asRanges().length];
            int index = 0;
            for (int i2 = 0; i2 < this.myRanges.length; i2 += 2) {
                LongRangeSet res = RangeSet.range(this.myRanges[i2], this.myRanges[i2 + 1]).subtract(other);
                long[] ranges = res.asRanges();
                System.arraycopy(ranges, 0, result, index, ranges.length);
                index += ranges.length;
            }
            return RangeSet.fromRanges(result, index);
        }

        @Override
        public LongRangeSet intersect(LongRangeSet other) {
            if (other == this) {
                return this;
            }
            if (other.isEmpty()) {
                return other;
            }
            if (other instanceof Point || other instanceof Range) {
                return other.intersect(this);
            }
            return this.subtract(RangeSet.all().subtract(other));
        }

        @Override
        public long min() {
            return this.myRanges[0];
        }

        @Override
        public long max() {
            return this.myRanges[this.myRanges.length - 1];
        }

        @Override
        public boolean intersects(LongRangeSet other) {
            long bTo;
            long aFrom;
            if (other.isEmpty()) {
                return false;
            }
            if (other instanceof Point) {
                return this.contains(((Point)other).myValue);
            }
            long[] otherRanges = other.asRanges();
            int a = 0;
            int b = 0;
            do {
                aFrom = this.myRanges[a];
                long aTo = this.myRanges[a + 1];
                long bFrom = otherRanges[b];
                bTo = otherRanges[b + 1];
                if (aFrom > bTo || bFrom > aTo) continue;
                return true;
            } while (!(aFrom > bTo ? (b += 2) >= otherRanges.length : (a += 2) >= this.myRanges.length));
            return false;
        }

        @Override
        public boolean contains(long value) {
            for (int i2 = 0; i2 < this.myRanges.length; i2 += 2) {
                if (value < this.myRanges[i2] || value > this.myRanges[i2 + 1]) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean contains(LongRangeSet other) {
            if (other.isEmpty() || other == this) {
                return true;
            }
            return other.subtract(this).isEmpty();
        }

        @Override
        public LongRangeSet abs(boolean isLong) {
            LongRangeSet result = RangeSet.all();
            for (int i2 = 0; i2 < this.myRanges.length; i2 += 2) {
                result = result.subtract(RangeSet.range(this.myRanges[i2], this.myRanges[i2 + 1]).abs(isLong));
            }
            return RangeSet.all().subtract(result);
        }

        @Override
        public LongStream stream() {
            return IntStream.range(0, this.myRanges.length / 2).mapToObj(idx -> LongStream.rangeClosed(this.myRanges[idx * 2], this.myRanges[idx * 2 + 1])).reduce(LongStream::concat).orElseGet(LongStream::empty);
        }

        @Override
        long[] asRanges() {
            return this.myRanges;
        }

        public int hashCode() {
            return Arrays.hashCode(this.myRanges);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o != null && o instanceof RangeSet && Arrays.equals(this.myRanges, ((RangeSet)o).myRanges);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("{");
            for (int i2 = 0; i2 < this.myRanges.length; i2 += 2) {
                if (i2 > 0) {
                    sb.append(", ");
                }
                sb.append(LongRangeSet.toString(this.myRanges[i2], this.myRanges[i2 + 1]));
            }
            sb.append("}");
            return sb.toString();
        }
    }

    static final class Range
    extends LongRangeSet {
        static final Range BYTE_RANGE = new Range(-128L, 127L);
        static final Range CHAR_RANGE = new Range(0L, 65535L);
        static final Range SHORT_RANGE = new Range(-32768L, 32767L);
        static final Range INT_RANGE = new Range(Integer.MIN_VALUE, Integer.MAX_VALUE);
        static final Range LONG_RANGE = new Range(Long.MIN_VALUE, Long.MAX_VALUE);
        static final Range INDEX_RANGE = new Range(0L, Integer.MAX_VALUE);
        final long myFrom;
        final long myTo;

        Range(long from, long to) {
            if (to <= from) {
                throw new IllegalArgumentException(to + "<=" + from);
            }
            this.myFrom = from;
            this.myTo = to;
        }

        @Override
        public LongRangeSet subtract(LongRangeSet other) {
            if (other.isEmpty()) {
                return this;
            }
            if (other == this) {
                return Empty.EMPTY;
            }
            if (other instanceof Point) {
                long value = ((Point)other).myValue;
                if (value < this.myFrom || value > this.myTo) {
                    return this;
                }
                if (value == this.myFrom) {
                    return Range.range(this.myFrom + 1L, this.myTo);
                }
                if (value == this.myTo) {
                    return Range.range(this.myFrom, this.myTo - 1L);
                }
                return new RangeSet(new long[]{this.myFrom, value - 1L, value + 1L, this.myTo});
            }
            if (other instanceof Range) {
                long from = ((Range)other).myFrom;
                long to = ((Range)other).myTo;
                if (to < this.myFrom || from > this.myTo) {
                    return this;
                }
                if (from <= this.myFrom && to >= this.myTo) {
                    return Empty.EMPTY;
                }
                if (from > this.myFrom && to < this.myTo) {
                    return new RangeSet(new long[]{this.myFrom, from - 1L, to + 1L, this.myTo});
                }
                if (from <= this.myFrom) {
                    return Range.range(to + 1L, this.myTo);
                }
                if (to >= this.myTo) {
                    return Range.range(this.myFrom, from - 1L);
                }
                throw new InternalError("Impossible: " + this + ":" + other);
            }
            long[] ranges = ((RangeSet)other).myRanges;
            LongRangeSet result = this;
            for (int i2 = 0; i2 < ranges.length; i2 += 2) {
                if (!(result = result.subtract(Range.range(ranges[i2], ranges[i2 + 1]))).isEmpty()) continue;
                return result;
            }
            return result;
        }

        @Override
        public LongRangeSet intersect(LongRangeSet other) {
            if (other == this) {
                return this;
            }
            if (other.isEmpty()) {
                return other;
            }
            if (other instanceof Point) {
                return other.intersect(this);
            }
            if (other instanceof Range) {
                long from = ((Range)other).myFrom;
                long to = ((Range)other).myTo;
                if (from <= this.myFrom && to >= this.myTo) {
                    return this;
                }
                if (from >= this.myFrom && to <= this.myTo) {
                    return other;
                }
                if (from < this.myFrom) {
                    from = this.myFrom;
                }
                if (to > this.myTo) {
                    to = this.myTo;
                }
                return from <= to ? Range.range(from, to) : Empty.EMPTY;
            }
            long[] ranges = ((RangeSet)other).myRanges;
            long[] result = new long[ranges.length];
            int index = 0;
            for (int i2 = 0; i2 < ranges.length; i2 += 2) {
                long[] res = this.intersect(Range.range(ranges[i2], ranges[i2 + 1])).asRanges();
                System.arraycopy(res, 0, result, index, res.length);
                index += res.length;
            }
            return Range.fromRanges(result, index);
        }

        @Override
        public long min() {
            return this.myFrom;
        }

        @Override
        public long max() {
            return this.myTo;
        }

        @Override
        public boolean intersects(LongRangeSet other) {
            if (other.isEmpty()) {
                return false;
            }
            if (other instanceof RangeSet) {
                return other.intersects(this);
            }
            return this.myTo >= other.min() && this.myFrom <= other.max();
        }

        @Override
        public boolean contains(long value) {
            return this.myFrom <= value && this.myTo >= value;
        }

        @Override
        public boolean contains(LongRangeSet other) {
            return other.isEmpty() || other.min() >= this.myFrom && other.max() <= this.myTo;
        }

        @Override
        public LongRangeSet abs(boolean isLong) {
            if (this.myFrom >= 0L) {
                return this;
            }
            long minValue = Range.minValue(isLong);
            long low = this.myFrom;
            long hi = this.myTo;
            if (low <= minValue) {
                low = minValue + 1L;
            }
            if (this.myTo <= 0L) {
                hi = -low;
                low = -this.myTo;
            } else {
                hi = Math.max(-low, hi);
                low = 0L;
            }
            if (this.myFrom <= minValue) {
                return new RangeSet(new long[]{minValue, minValue, low, hi});
            }
            return new Range(low, hi);
        }

        @Override
        public LongStream stream() {
            return LongStream.rangeClosed(this.myFrom, this.myTo);
        }

        @Override
        long[] asRanges() {
            return new long[]{this.myFrom, this.myTo};
        }

        public int hashCode() {
            return Long.hashCode(this.myFrom) * 1337 + Long.hashCode(this.myTo);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o != null && o instanceof Range && this.myFrom == ((Range)o).myFrom && this.myTo == ((Range)o).myTo;
        }

        public String toString() {
            return "{" + Range.toString(this.myFrom, this.myTo) + "}";
        }
    }

    static final class Point
    extends LongRangeSet {
        final long myValue;

        Point(long value) {
            this.myValue = value;
        }

        @Override
        public LongRangeSet subtract(LongRangeSet other) {
            return other.contains(this.myValue) ? Empty.EMPTY : this;
        }

        @Override
        public LongRangeSet intersect(LongRangeSet other) {
            return other.contains(this.myValue) ? this : Empty.EMPTY;
        }

        @Override
        public long min() {
            return this.myValue;
        }

        @Override
        public long max() {
            return this.myValue;
        }

        @Override
        public boolean intersects(LongRangeSet other) {
            return other.contains(this.myValue);
        }

        @Override
        public boolean contains(long value) {
            return this.myValue == value;
        }

        @Override
        public boolean contains(LongRangeSet other) {
            return other.isEmpty() || this.equals(other);
        }

        @Override
        public LongRangeSet abs(boolean isLong) {
            return this.myValue >= 0L || this.myValue == Point.minValue(isLong) ? this : Point.point(-this.myValue);
        }

        @Override
        public LongStream stream() {
            return LongStream.of(this.myValue);
        }

        @Override
        long[] asRanges() {
            return new long[]{this.myValue, this.myValue};
        }

        public int hashCode() {
            return Long.hashCode(this.myValue);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o != null && o instanceof Point && this.myValue == ((Point)o).myValue;
        }

        public String toString() {
            return "{" + this.myValue + "}";
        }
    }

    static final class Empty
    extends LongRangeSet {
        static final LongRangeSet EMPTY = new Empty();

        Empty() {
        }

        @Override
        public LongRangeSet subtract(LongRangeSet other) {
            return this;
        }

        @Override
        public LongRangeSet intersect(LongRangeSet other) {
            return this;
        }

        @Override
        public LongRangeSet union(LongRangeSet other) {
            return other;
        }

        @Override
        public long min() {
            throw new NoSuchElementException();
        }

        @Override
        public long max() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean intersects(LongRangeSet other) {
            return false;
        }

        @Override
        public boolean contains(long value) {
            return false;
        }

        @Override
        public boolean contains(LongRangeSet other) {
            return other.isEmpty();
        }

        @Override
        public LongRangeSet abs(boolean isLong) {
            return this;
        }

        @Override
        public LongStream stream() {
            return LongStream.empty();
        }

        @Override
        long[] asRanges() {
            return new long[0];
        }

        public int hashCode() {
            return 2154231;
        }

        public boolean equals(Object obj) {
            return obj == this;
        }

        public String toString() {
            return "{}";
        }
    }
}

