/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.RenderingHints;

public enum AntialiasingType {
    SUBPIXEL("Subpixel", RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB, true),
    GREYSCALE("Greyscale", RenderingHints.VALUE_TEXT_ANTIALIAS_ON, true),
    OFF("No antialiasing", RenderingHints.VALUE_TEXT_ANTIALIAS_OFF, false);

    private final String myName;
    private final Object myHint;
    private final boolean isEnabled;

    public static Object getAAHintForSwingComponent() {
        AntialiasingType type;
        UISettings uiSettings;
        UISettings uISettings = uiSettings = ApplicationManager.getApplication() == null ? null : UISettings.getInstance();
        if (uiSettings != null && (type = uiSettings.getIdeAAType()) != null) {
            return type.getTextInfo();
        }
        return GREYSCALE.getTextInfo();
    }

    public static Object getKeyForCurrentScope(boolean inEditor) {
        UISettings uiSettings;
        UISettings uISettings = uiSettings = ApplicationManager.getApplication() == null ? null : UISettings.getInstance();
        if (uiSettings != null) {
            AntialiasingType type;
            AntialiasingType antialiasingType = type = inEditor ? uiSettings.getEditorAAType() : uiSettings.getIdeAAType();
            if (type != null) {
                return type.myHint;
            }
        }
        return RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
    }

    private AntialiasingType(String name, Object hint, boolean enabled) {
        this.myName = name;
        this.myHint = hint;
        this.isEnabled = enabled;
    }

    public Object getTextInfo() {
        return this.isEnabled ? GraphicsUtil.createAATextInfo(this.myHint) : null;
    }

    public String toString() {
        return this.myName;
    }
}

