/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.logging;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PropertyUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

class PublicMethodWithoutLoggingInspectionBase
extends BaseInspection {
    final List<String> loggerClassNames = new ArrayList<String>();
    public String loggerClassName = "java.util.logging.Logger,org.slf4j.Logger,org.apache.commons.logging.Log,org.apache.log4j.Logger";

    PublicMethodWithoutLoggingInspectionBase() {
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("public.method.without.logging.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/logging/PublicMethodWithoutLoggingInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("public.method.without.logging.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/logging/PublicMethodWithoutLoggingInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/logging/PublicMethodWithoutLoggingInspectionBase", "readSettings"));
        }
        super.readSettings(element);
        PublicMethodWithoutLoggingInspectionBase.parseString(this.loggerClassName, this.loggerClassNames);
    }

    @Override
    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/logging/PublicMethodWithoutLoggingInspectionBase", "writeSettings"));
        }
        this.loggerClassName = PublicMethodWithoutLoggingInspectionBase.formatString(this.loggerClassNames);
        super.writeSettings(element);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PublicMethodWithoutLoggingVisitor();
    }

    private class ContainsLoggingCallVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean containsLoggingCall;

        private ContainsLoggingCallVisitor() {
        }

        @Override
        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/logging/PublicMethodWithoutLoggingInspectionBase$ContainsLoggingCallVisitor", "visitElement"));
            }
            if (this.containsLoggingCall) {
                return;
            }
            super.visitElement(element);
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/logging/PublicMethodWithoutLoggingInspectionBase$ContainsLoggingCallVisitor", "visitMethodCallExpression"));
            }
            if (this.containsLoggingCall) {
                return;
            }
            super.visitMethodCallExpression(expression);
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String containingClassName = containingClass.getQualifiedName();
            if (containingClassName == null) {
                return;
            }
            if (PublicMethodWithoutLoggingInspectionBase.this.loggerClassNames.contains(containingClassName)) {
                this.containsLoggingCall = true;
            }
        }

        private boolean containsLoggingCall() {
            return this.containsLoggingCall;
        }
    }

    private class PublicMethodWithoutLoggingVisitor
    extends BaseInspectionVisitor {
        private PublicMethodWithoutLoggingVisitor() {
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/logging/PublicMethodWithoutLoggingInspectionBase$PublicMethodWithoutLoggingVisitor", "visitMethod"));
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            if (!method.hasModifierProperty("public")) {
                return;
            }
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return;
            }
            if (method.isConstructor()) {
                return;
            }
            if (PropertyUtil.isSimpleGetter(method) || PropertyUtil.isSimpleSetter(method)) {
                return;
            }
            if (this.containsLoggingCall(body)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private boolean containsLoggingCall(PsiCodeBlock block) {
            ContainsLoggingCallVisitor visitor = new ContainsLoggingCallVisitor();
            block.accept(visitor);
            return visitor.containsLoggingCall();
        }
    }
}

