/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.numeric.ConvertOctalLiteralToDecimalFix;
import com.siyeh.ig.numeric.RemoveLeadingZeroFix;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;

public class OctalLiteralInspection
extends BaseInspection {
    @Override
    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("OctalInteger" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/OctalLiteralInspection", "getID"));
        }
        return "OctalInteger";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("octal.literal.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/OctalLiteralInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("octal.literal.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/OctalLiteralInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new ConvertOctalLiteralToDecimalFix(), new RemoveLeadingZeroFix()};
        if (inspectionGadgetsFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/OctalLiteralInspection", "buildFixes"));
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OctalLiteralVisitor();
    }

    private static class OctalLiteralVisitor
    extends BaseInspectionVisitor {
        private OctalLiteralVisitor() {
        }

        @Override
        public void visitLiteralExpression(@NotNull PsiLiteralExpression literal) {
            if (literal == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/siyeh/ig/numeric/OctalLiteralInspection$OctalLiteralVisitor", "visitLiteralExpression"));
            }
            super.visitLiteralExpression(literal);
            PsiType type = literal.getType();
            if (type == null) {
                return;
            }
            if (!type.equals(PsiType.INT) && !type.equals(PsiType.LONG)) {
                return;
            }
            String text2 = literal.getText();
            if (text2.length() == 1) {
                return;
            }
            if (text2.charAt(0) != '0') {
                return;
            }
            char c1 = text2.charAt(1);
            if (c1 != '_' && (c1 < '0' || c1 > '7')) {
                return;
            }
            if (literal.getValue() == null) {
                return;
            }
            this.registerError((PsiElement)literal, new Object[0]);
        }
    }
}

