/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileIndexBase
implements FileIndex {
    protected final FileTypeRegistry myFileTypeRegistry;
    protected final DirectoryIndex myDirectoryIndex;
    private final VirtualFileFilter myContentFilter;

    public FileIndexBase(@NotNull DirectoryIndex directoryIndex, @NotNull FileTypeRegistry fileTypeManager) {
        if (directoryIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryIndex", "com/intellij/openapi/roots/impl/FileIndexBase", "<init>"));
        }
        if (fileTypeManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypeManager", "com/intellij/openapi/roots/impl/FileIndexBase", "<init>"));
        }
        this.myContentFilter = file -> {
            assert (file != null);
            return ReadAction.compute(() -> !this.isScopeDisposed() && this.isInContent(file));
        };
        this.myDirectoryIndex = directoryIndex;
        this.myFileTypeRegistry = fileTypeManager;
    }

    protected abstract boolean isScopeDisposed();

    @Override
    public boolean iterateContent(@NotNull ContentIterator processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/roots/impl/FileIndexBase", "iterateContent"));
        }
        return this.iterateContent(processor, null);
    }

    @Override
    public boolean iterateContentUnderDirectory(@NotNull VirtualFile dir, @NotNull ContentIterator processor, @Nullable VirtualFileFilter customFilter) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/roots/impl/FileIndexBase", "iterateContentUnderDirectory"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/roots/impl/FileIndexBase", "iterateContentUnderDirectory"));
        }
        VirtualFileFilter filter = customFilter != null ? file -> this.myContentFilter.accept(file) && customFilter.accept(file) : this.myContentFilter;
        return FileIndexBase.iterateContentUnderDirectoryWithFilter(dir, processor, filter);
    }

    @Override
    public boolean iterateContentUnderDirectory(@NotNull VirtualFile dir, @NotNull ContentIterator processor) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/roots/impl/FileIndexBase", "iterateContentUnderDirectory"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/roots/impl/FileIndexBase", "iterateContentUnderDirectory"));
        }
        return this.iterateContentUnderDirectory(dir, processor, null);
    }

    private static boolean iterateContentUnderDirectoryWithFilter(@NotNull VirtualFile dir, @NotNull ContentIterator iterator, @NotNull VirtualFileFilter filter) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/roots/impl/FileIndexBase", "iterateContentUnderDirectoryWithFilter"));
        }
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/openapi/roots/impl/FileIndexBase", "iterateContentUnderDirectoryWithFilter"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/openapi/roots/impl/FileIndexBase", "iterateContentUnderDirectoryWithFilter"));
        }
        return VfsUtilCore.iterateChildrenRecursively(dir, filter, iterator);
    }

    @NotNull
    protected DirectoryInfo getInfoForFileOrDirectory(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/FileIndexBase", "getInfoForFileOrDirectory"));
        }
        if (file instanceof VirtualFileWindow) {
            file = ((VirtualFileWindow)((Object)file)).getDelegate();
        }
        DirectoryInfo directoryInfo = this.myDirectoryIndex.getInfoForFile(file);
        if (directoryInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/FileIndexBase", "getInfoForFileOrDirectory"));
        }
        return directoryInfo;
    }

    @Override
    public boolean isContentSourceFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/FileIndexBase", "isContentSourceFile"));
        }
        return !file.isDirectory() && !this.myFileTypeRegistry.isFileIgnored(file) && this.isInSourceContent(file);
    }

    @NotNull
    protected static VirtualFile[][] getModuleContentAndSourceRoots(Module module) {
        VirtualFile[][] virtualFileArray = new VirtualFile[][]{ModuleRootManager.getInstance(module).getContentRoots(), ModuleRootManager.getInstance(module).getSourceRoots()};
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/FileIndexBase", "getModuleContentAndSourceRoots"));
        }
        return virtualFileArray;
    }
}

