/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ThrowableConsumer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataInputOutputUtilRt {
    public static int readINT(@NotNull DataInput record) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "com/intellij/openapi/util/io/DataInputOutputUtilRt", "readINT"));
        }
        int val = record.readUnsignedByte();
        if (val < 192) {
            return val;
        }
        int res = val - 192;
        int sh = 6;
        while (true) {
            int next = record.readUnsignedByte();
            res |= (next & 0x7F) << sh;
            if ((next & 0x80) == 0) {
                return res;
            }
            sh += 7;
        }
    }

    public static void writeINT(@NotNull DataOutput record, int val) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "com/intellij/openapi/util/io/DataInputOutputUtilRt", "writeINT"));
        }
        if (0 <= val && val < 192) {
            record.writeByte(val);
        } else {
            record.writeByte(192 + (val & 0x3F));
            val >>>= 6;
            while (val >= 128) {
                record.writeByte(val & 0x7F | 0x80);
                val >>>= 7;
            }
            record.writeByte(val);
        }
    }

    public static <T> void writeSeq(@NotNull DataOutput out, @NotNull Collection<T> collection, @NotNull ThrowableConsumer<T, IOException> writeElement) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/openapi/util/io/DataInputOutputUtilRt", "writeSeq"));
        }
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/openapi/util/io/DataInputOutputUtilRt", "writeSeq"));
        }
        if (writeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writeElement", "com/intellij/openapi/util/io/DataInputOutputUtilRt", "writeSeq"));
        }
        DataInputOutputUtilRt.writeINT(out, collection.size());
        for (T t : collection) {
            writeElement.consume(t);
        }
    }

    @NotNull
    public static <T> List<T> readSeq(@NotNull DataInput in, @NotNull ThrowableComputable<T, IOException> readElement) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/openapi/util/io/DataInputOutputUtilRt", "readSeq"));
        }
        if (readElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readElement", "com/intellij/openapi/util/io/DataInputOutputUtilRt", "readSeq"));
        }
        int size = DataInputOutputUtilRt.readINT(in);
        ArrayList<T> result = new ArrayList<T>(size);
        for (int i2 = 0; i2 < size; ++i2) {
            result.add(readElement.compute());
        }
        ArrayList<T> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/DataInputOutputUtilRt", "readSeq"));
        }
        return arrayList;
    }
}

