/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.util.ArrayUtil;
import com.intellij.util.text.CharArrayCharSequence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LineTokenizer {
    private int myOffset;
    private int myLength;
    private int myLineSeparatorLength;
    private boolean atEnd;
    private final CharSequence myText;

    @NotNull
    public static String[] tokenize(CharSequence chars, boolean includeSeparators) {
        String[] stringArray = LineTokenizer.tokenize(chars, includeSeparators, true);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/LineTokenizer", "tokenize"));
        }
        return stringArray;
    }

    @NotNull
    public static String[] tokenize(CharSequence chars, boolean includeSeparators, boolean skipLastEmptyLine) {
        List<String> strings = LineTokenizer.tokenizeIntoList(chars, includeSeparators, skipLastEmptyLine);
        String[] stringArray = strings.isEmpty() ? ArrayUtil.EMPTY_STRING_ARRAY : ArrayUtil.toStringArray(strings);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/LineTokenizer", "tokenize"));
        }
        return stringArray;
    }

    @NotNull
    public static List<String> tokenizeIntoList(CharSequence chars, boolean includeSeparators) {
        List<String> list = LineTokenizer.tokenizeIntoList(chars, includeSeparators, true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/LineTokenizer", "tokenizeIntoList"));
        }
        return list;
    }

    @NotNull
    public static List<String> tokenizeIntoList(CharSequence chars, boolean includeSeparators, boolean skipLastEmptyLine) {
        if (chars == null || chars.length() == 0) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/LineTokenizer", "tokenizeIntoList"));
            }
            return list;
        }
        LineTokenizer tokenizer = new LineTokenizer(chars);
        ArrayList<String> lines = new ArrayList<String>();
        while (!tokenizer.atEnd()) {
            int offset = tokenizer.getOffset();
            String line = includeSeparators ? chars.subSequence(offset, offset + tokenizer.getLength() + tokenizer.getLineSeparatorLength()).toString() : chars.subSequence(offset, offset + tokenizer.getLength()).toString();
            lines.add(line);
            tokenizer.advance();
        }
        if (!skipLastEmptyLine && LineTokenizer.stringEndsWithSeparator(tokenizer)) {
            lines.add("");
        }
        ArrayList<String> arrayList = lines;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/LineTokenizer", "tokenizeIntoList"));
        }
        return arrayList;
    }

    public static int calcLineCount(@NotNull CharSequence chars, boolean skipLastEmptyLine) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/util/text/LineTokenizer", "calcLineCount"));
        }
        int lineCount = 0;
        if (chars.length() != 0) {
            LineTokenizer tokenizer = new LineTokenizer(chars);
            while (!tokenizer.atEnd()) {
                ++lineCount;
                tokenizer.advance();
            }
            if (!skipLastEmptyLine && LineTokenizer.stringEndsWithSeparator(tokenizer)) {
                ++lineCount;
            }
        }
        return lineCount;
    }

    @NotNull
    public static String[] tokenize(@NotNull char[] chars, boolean includeSeparators) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/util/text/LineTokenizer", "tokenize"));
        }
        String[] stringArray = LineTokenizer.tokenize(chars, includeSeparators, true);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/LineTokenizer", "tokenize"));
        }
        return stringArray;
    }

    @NotNull
    public static String[] tokenize(@NotNull char[] chars, boolean includeSeparators, boolean skipLastEmptyLine) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/util/text/LineTokenizer", "tokenize"));
        }
        String[] stringArray = LineTokenizer.tokenize(chars, 0, chars.length, includeSeparators, skipLastEmptyLine);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/LineTokenizer", "tokenize"));
        }
        return stringArray;
    }

    @NotNull
    public static String[] tokenize(@NotNull char[] chars, int startOffset, int endOffset, boolean includeSeparators, boolean skipLastEmptyLine) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/util/text/LineTokenizer", "tokenize"));
        }
        String[] stringArray = LineTokenizer.tokenize(new CharArrayCharSequence(chars, startOffset, endOffset), includeSeparators, skipLastEmptyLine);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/LineTokenizer", "tokenize"));
        }
        return stringArray;
    }

    private static boolean stringEndsWithSeparator(@NotNull LineTokenizer tokenizer) {
        if (tokenizer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokenizer", "com/intellij/openapi/util/text/LineTokenizer", "stringEndsWithSeparator"));
        }
        return tokenizer.getLineSeparatorLength() > 0;
    }

    @NotNull
    public static String[] tokenize(@NotNull char[] chars, int startOffset, int endOffset, boolean includeSeparators) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/util/text/LineTokenizer", "tokenize"));
        }
        String[] stringArray = LineTokenizer.tokenize(chars, startOffset, endOffset, includeSeparators, true);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/LineTokenizer", "tokenize"));
        }
        return stringArray;
    }

    public LineTokenizer(@NotNull CharSequence text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/LineTokenizer", "<init>"));
        }
        this.myText = text2;
        this.myOffset = 0;
        this.advance();
    }

    public LineTokenizer(@NotNull char[] text2, int startOffset, int endOffset) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/LineTokenizer", "<init>"));
        }
        this(new CharArrayCharSequence(text2, startOffset, endOffset));
    }

    public final boolean atEnd() {
        return this.atEnd;
    }

    public final int getOffset() {
        return this.myOffset;
    }

    public final int getLength() {
        return this.myLength;
    }

    public final int getLineSeparatorLength() {
        return this.myLineSeparatorLength;
    }

    public void advance() {
        char c;
        int i2 = this.myOffset + this.myLength + this.myLineSeparatorLength;
        int textLength = this.myText.length();
        if (i2 >= textLength) {
            this.atEnd = true;
            return;
        }
        while (i2 < textLength && (c = this.myText.charAt(i2)) != '\r' && c != '\n') {
            ++i2;
        }
        this.myOffset += this.myLength + this.myLineSeparatorLength;
        this.myLength = i2 - this.myOffset;
        this.myLineSeparatorLength = 0;
        if (i2 == textLength) {
            return;
        }
        char first = this.myText.charAt(i2);
        if (first == '\r' || first == '\n') {
            this.myLineSeparatorLength = 1;
        }
        if (++i2 == textLength) {
            return;
        }
        char second = this.myText.charAt(i2);
        if (first == '\r' && second == '\n') {
            this.myLineSeparatorLength = 2;
        }
    }
}

