/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConditionalCanBePushedInsideExpressionInspection
extends BaseInspection {
    public boolean ignoreSingleArgument = true;

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("conditional.can.be.pushed.inside.expression.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/ConditionalCanBePushedInsideExpressionInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("conditional.can.be.pushed.inside.expression.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/ConditionalCanBePushedInsideExpressionInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("conditional.can.be.pushed.inside.expression.option", new Object[0]), this, "ignoreSingleArgument");
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new PushConditionalInsideFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConditionalCanBePushedInsideExpressionVisitor();
    }

    private class ConditionalCanBePushedInsideExpressionVisitor
    extends BaseInspectionVisitor {
        private ConditionalCanBePushedInsideExpressionVisitor() {
        }

        @Override
        public void visitConditionalExpression(PsiConditionalExpression expression) {
            super.visitConditionalExpression(expression);
            PsiExpression thenExpression = expression.getThenExpression();
            if (thenExpression == null) {
                return;
            }
            PsiExpression elseExpression = expression.getElseExpression();
            EquivalenceChecker.Match match = EquivalenceChecker.getCanonicalPsiEquivalence().expressionsMatch(thenExpression, elseExpression);
            if (match.isExactMismatch() || match.isExactMatch()) {
                return;
            }
            this.registerError((PsiElement)expression, ConditionalCanBePushedInsideExpressionInspection.this.ignoreSingleArgument && this.isOnlyArgumentOfMethodCall(match.getLeftDiff(), expression) ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new Object[0]);
        }

        private boolean isOnlyArgumentOfMethodCall(PsiElement element, PsiConditionalExpression conditional) {
            if (element == null) {
                return false;
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiExpressionList)) {
                return false;
            }
            PsiExpressionList expressionList = (PsiExpressionList)parent;
            if (expressionList.getExpressions().length != 1) {
                return false;
            }
            PsiElement grandParent = expressionList.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiElement greatGrandParent = ParenthesesUtils.getParentSkipParentheses(grandParent);
            return greatGrandParent == conditional;
        }
    }

    private static class PushConditionalInsideFix
    extends InspectionGadgetsFix {
        private PushConditionalInsideFix() {
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("conditional.can.be.pushed.inside.expression.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/ConditionalCanBePushedInsideExpressionInspection$PushConditionalInsideFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)descriptor.getPsiElement();
            PsiExpression thenExpression = conditionalExpression.getThenExpression();
            if (thenExpression == null) {
                return;
            }
            EquivalenceChecker.Match match = EquivalenceChecker.getCanonicalPsiEquivalence().expressionsMatch(thenExpression, conditionalExpression.getElseExpression());
            if (!match.isPartialMatch()) {
                return;
            }
            PsiElement leftDiff = match.getLeftDiff();
            PsiElement rightDiff = match.getRightDiff();
            String expression = "(" + conditionalExpression.getCondition().getText() + " ? " + leftDiff.getText() + " : " + rightDiff.getText() + ")";
            PsiExpression newConditionalExpression = JavaPsiFacade.getElementFactory(project).createExpressionFromText(expression, conditionalExpression);
            PsiElement replacedConditionalExpression = leftDiff.replace(newConditionalExpression);
            ParenthesesUtils.removeParentheses((PsiExpression)replacedConditionalExpression, false);
            conditionalExpression.replace(thenExpression);
        }
    }
}

