/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RemoveModifierFix;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryFinalOnLocalVariableOrParameterInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean onlyWarnOnAbstractMethods = false;
    public boolean reportLocalVariables = true;
    public boolean reportParameters = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.final.on.local.variable.or.parameter.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryFinalOnLocalVariableOrParameterInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiVariable variable = (PsiVariable)infos[0];
        String variableName = variable.getName();
        if (variable instanceof PsiParameter) {
            String string = InspectionGadgetsBundle.message("unnecessary.final.on.parameter.problem.descriptor", variableName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryFinalOnLocalVariableOrParameterInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("unnecessary.final.on.local.variable.problem.descriptor", variableName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryFinalOnLocalVariableOrParameterInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel(this);
        JCheckBox box1 = panel.addCheckboxEx(InspectionGadgetsBundle.message("unnecessary.final.report.local.variables.option", new Object[0]), "reportLocalVariables");
        JCheckBox box2 = panel.addCheckboxEx(InspectionGadgetsBundle.message("unnecessary.final.report.parameters.option", new Object[0]), "reportParameters");
        panel.addDependentCheckBox(InspectionGadgetsBundle.message("unnecessary.final.on.parameter.only.interface.option", new Object[0]), "onlyWarnOnAbstractMethods", box2);
        box1.addChangeListener(e -> {
            if (!box1.isSelected()) {
                box2.setSelected(true);
            }
        });
        box2.addChangeListener(e -> {
            if (!box2.isSelected()) {
                box1.setSelected(true);
            }
        });
        return panel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryFinalOnLocalVariableOrParameterVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new RemoveModifierFix("final");
    }

    private class UnnecessaryFinalOnLocalVariableOrParameterVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryFinalOnLocalVariableOrParameterVisitor() {
        }

        @Override
        public void visitDeclarationStatement(PsiDeclarationStatement statement) {
            super.visitDeclarationStatement(statement);
            if (!UnnecessaryFinalOnLocalVariableOrParameterInspection.this.reportLocalVariables) {
                return;
            }
            PsiElement[] declaredElements = statement.getDeclaredElements();
            if (declaredElements.length == 0) {
                return;
            }
            PsiElement firstElement = declaredElements[0];
            if (!(firstElement instanceof PsiLocalVariable)) {
                return;
            }
            PsiLocalVariable firstVariable = (PsiLocalVariable)firstElement;
            if (!firstVariable.hasModifierProperty("final")) {
                return;
            }
            PsiCodeBlock containingBlock = PsiTreeUtil.getParentOfType((PsiElement)statement, PsiCodeBlock.class);
            if (containingBlock == null) {
                return;
            }
            for (PsiElement declaredElement : declaredElements) {
                PsiLocalVariable variable = (PsiLocalVariable)declaredElement;
                if (!this.isNecessaryFinal(variable, containingBlock)) continue;
                return;
            }
            PsiLocalVariable variable = (PsiLocalVariable)firstElement;
            this.registerModifierError("final", variable, variable);
        }

        @Override
        public void visitMethod(PsiMethod method) {
            PsiParameter[] parameters;
            super.visitMethod(method);
            if (!UnnecessaryFinalOnLocalVariableOrParameterInspection.this.reportParameters) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            for (PsiParameter parameter : parameters = parameterList.getParameters()) {
                this.checkParameter(method, parameter);
            }
        }

        private void checkParameter(PsiMethod method, PsiParameter parameter) {
            if (!parameter.hasModifierProperty("final")) {
                return;
            }
            if (method.hasModifierProperty("abstract")) {
                this.registerModifierError("final", parameter, parameter);
            } else if (!UnnecessaryFinalOnLocalVariableOrParameterInspection.this.onlyWarnOnAbstractMethods) {
                this.check(parameter);
            }
        }

        @Override
        public void visitTryStatement(PsiTryStatement statement) {
            PsiCatchSection[] catchSections;
            super.visitTryStatement(statement);
            if (UnnecessaryFinalOnLocalVariableOrParameterInspection.this.onlyWarnOnAbstractMethods || !UnnecessaryFinalOnLocalVariableOrParameterInspection.this.reportParameters) {
                return;
            }
            for (PsiCatchSection catchSection : catchSections = statement.getCatchSections()) {
                PsiParameter parameter = catchSection.getParameter();
                PsiCodeBlock catchBlock = catchSection.getCatchBlock();
                if (parameter == null || catchBlock == null || !parameter.hasModifierProperty("final")) continue;
                this.check(parameter);
            }
        }

        @Override
        public void visitForeachStatement(PsiForeachStatement statement) {
            super.visitForeachStatement(statement);
            if (UnnecessaryFinalOnLocalVariableOrParameterInspection.this.onlyWarnOnAbstractMethods || !UnnecessaryFinalOnLocalVariableOrParameterInspection.this.reportParameters) {
                return;
            }
            PsiParameter parameter = statement.getIterationParameter();
            if (!parameter.hasModifierProperty("final")) {
                return;
            }
            this.check(parameter);
        }

        private boolean isNecessaryFinal(PsiVariable parameter, PsiElement context) {
            return !PsiUtil.isLanguageLevel8OrHigher(parameter) && VariableAccessUtils.variableIsUsedInInnerClass(parameter, context);
        }

        private void check(PsiParameter parameter) {
            if (!this.isNecessaryFinal(parameter, parameter.getDeclarationScope())) {
                this.registerModifierError("final", parameter, parameter);
            }
        }
    }
}

