/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ArgumentFixerActionFactory;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;

public abstract class MethodArgumentFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance(MethodArgumentFix.class);
    protected final PsiExpressionList myArgList;
    protected final int myIndex;
    private final ArgumentFixerActionFactory myArgumentFixerActionFactory;
    protected final PsiType myToType;

    protected MethodArgumentFix(@NotNull PsiExpressionList list, int i2, @NotNull PsiType toType, @NotNull ArgumentFixerActionFactory fixerActionFactory) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/daemon/impl/quickfix/MethodArgumentFix", "<init>"));
        }
        if (toType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toType", "com/intellij/codeInsight/daemon/impl/quickfix/MethodArgumentFix", "<init>"));
        }
        if (fixerActionFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixerActionFactory", "com/intellij/codeInsight/daemon/impl/quickfix/MethodArgumentFix", "<init>"));
        }
        this.myArgList = list;
        this.myIndex = i2;
        this.myArgumentFixerActionFactory = fixerActionFactory;
        this.myToType = toType instanceof PsiEllipsisType ? ((PsiEllipsisType)toType).toArrayType() : toType;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/MethodArgumentFix", "isAvailable"));
        }
        return this.myToType != null && this.myToType.isValid() && this.myArgList.getExpressions().length > this.myIndex && this.myArgList.getExpressions()[this.myIndex] != null && this.myArgList.getExpressions()[this.myIndex].isValid();
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/MethodArgumentFix", "invoke"));
        }
        PsiExpression expression = this.myArgList.getExpressions()[this.myIndex];
        LOG.assertTrue(expression != null && expression.isValid());
        PsiExpression modified = this.myArgumentFixerActionFactory.getModifiedArgument(expression, this.myToType);
        LOG.assertTrue(modified != null, this.myArgumentFixerActionFactory);
        expression.replace(modified);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("fix.argument.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/MethodArgumentFix", "getFamilyName"));
        }
        return string;
    }
}

