/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.instructions.ArrayAccessInstruction;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.BinopInstruction;
import com.intellij.codeInspection.dataFlow.instructions.CheckReturnValueInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ConditionalGotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.EmptyInstruction;
import com.intellij.codeInspection.dataFlow.instructions.EmptyStackInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FieldReferenceInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FlushVariableInstruction;
import com.intellij.codeInspection.dataFlow.instructions.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.LambdaInstruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.NotInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.instructions.TypeCastInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.PsiExpression;
import java.util.ArrayList;

public abstract class InstructionVisitor {
    public DfaInstructionState[] visitAssign(AssignInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        memState.pop();
        memState.push(memState.pop());
        return InstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    protected static DfaInstructionState[] nextInstruction(Instruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        return new DfaInstructionState[]{new DfaInstructionState(runner.getInstruction(instruction.getIndex() + 1), memState)};
    }

    public DfaInstructionState[] visitInstanceof(InstanceofInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        return this.visitBinop(instruction, runner, memState);
    }

    public DfaInstructionState[] visitBinop(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        memState.pop();
        memState.pop();
        memState.push(DfaUnknownValue.getInstance());
        return InstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public DfaInstructionState[] visitCheckReturnValue(CheckReturnValueInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        memState.pop();
        return InstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public DfaInstructionState[] visitLambdaExpression(LambdaInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        return InstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public DfaInstructionState[] visitConditionalGoto(ConditionalGotoInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValue condTrue;
        DfaValue condFalse;
        DfaValue cond = memState.pop();
        if (instruction.isNegated()) {
            condFalse = cond;
            condTrue = cond.createNegated();
        } else {
            condTrue = cond;
            condFalse = cond.createNegated();
        }
        if (condTrue == runner.getFactory().getConstFactory().getTrue()) {
            InstructionVisitor.markBranchReachable(instruction, true);
            return new DfaInstructionState[]{new DfaInstructionState(runner.getInstruction(instruction.getOffset()), memState)};
        }
        if (condFalse == runner.getFactory().getConstFactory().getTrue()) {
            InstructionVisitor.markBranchReachable(instruction, false);
            return InstructionVisitor.nextInstruction(instruction, runner, memState);
        }
        ArrayList<DfaInstructionState> result = new ArrayList<DfaInstructionState>();
        DfaMemoryState thenState = memState.createCopy();
        DfaMemoryState elseState = memState.createCopy();
        if (thenState.applyCondition(condTrue)) {
            result.add(new DfaInstructionState(runner.getInstruction(instruction.getOffset()), thenState));
            InstructionVisitor.markBranchReachable(instruction, true);
        }
        if (elseState.applyCondition(condFalse)) {
            result.add(new DfaInstructionState(runner.getInstruction(instruction.getIndex() + 1), elseState));
            InstructionVisitor.markBranchReachable(instruction, false);
        }
        return result.toArray(new DfaInstructionState[result.size()]);
    }

    private static void markBranchReachable(ConditionalGotoInstruction instruction, boolean isTrueBranch) {
        if (isTrueBranch ^ instruction.isNegated()) {
            instruction.setTrueReachable();
        } else {
            instruction.setFalseReachable();
        }
    }

    public DfaInstructionState[] visitEmptyStack(EmptyStackInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        memState.emptyStack();
        return InstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public DfaInstructionState[] visitFieldReference(FieldReferenceInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        memState.pop();
        return InstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public DfaInstructionState[] visitFlushVariable(FlushVariableInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaVariableValue variable = instruction.getVariable();
        if (variable != null) {
            if (instruction.isDependentsOnly()) {
                for (DfaVariableValue qualified : runner.getFactory().getVarFactory().getAllQualifiedBy(variable)) {
                    memState.flushVariable(qualified);
                }
            } else {
                memState.flushVariable(variable);
            }
        } else {
            memState.flushFields();
        }
        return InstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public DfaInstructionState[] visitMethodCall(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        for (PsiExpression arg : instruction.getArgs()) {
            memState.pop();
        }
        memState.pop();
        memState.push(DfaUnknownValue.getInstance());
        return InstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public DfaInstructionState[] visitCast(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        return this.visitMethodCall(instruction, runner, memState);
    }

    public DfaInstructionState[] visitNot(NotInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValue dfaValue = memState.pop();
        dfaValue = dfaValue.createNegated();
        memState.push(dfaValue);
        return InstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public DfaInstructionState[] visitPush(PushInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        memState.push(instruction.getValue());
        return InstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public DfaInstructionState[] visitArrayAccess(ArrayAccessInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        memState.pop();
        memState.pop();
        memState.push(instruction.getValue());
        return InstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public DfaInstructionState[] visitTypeCast(TypeCastInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        return InstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public DfaInstructionState[] visitEmptyInstruction(EmptyInstruction instruction, DataFlowRunner runner, DfaMemoryState before) {
        return InstructionVisitor.nextInstruction(instruction, runner, before);
    }
}

