/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInspection.htmlInspections.RemoveExtraClosingTagIntentionAction;
import com.intellij.codeInspection.htmlInspections.RenameTagBeginOrEndIntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlTagUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlWrongClosingTagNameInspection
implements Annotator {
    @Override
    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInspection/htmlInspections/XmlWrongClosingTagNameInspection", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/htmlInspections/XmlWrongClosingTagNameInspection", "annotate"));
        }
        if (psiElement instanceof XmlToken) {
            String message;
            PsiFile psiFile;
            PsiElement parent = psiElement.getParent();
            if (parent instanceof XmlTag) {
                XmlTag tag = (XmlTag)parent;
                XmlToken start = XmlTagUtil.getStartTagNameElement(tag);
                XmlToken endTagName = XmlTagUtil.getEndTagNameElement(tag);
                if (start == psiElement) {
                    PsiErrorElement errorElement;
                    if (endTagName != null && !(tag instanceof HtmlTag) && !tag.getName().equals(endTagName.getText())) {
                        XmlWrongClosingTagNameInspection.registerProblemStart(holder, tag, start, endTagName);
                    } else if (!(endTagName != null || tag instanceof HtmlTag && HtmlUtil.isSingleHtmlTag(tag.getName()) || (endTagName = XmlWrongClosingTagNameInspection.findEndTagName(errorElement = PsiTreeUtil.getChildOfType(tag, PsiErrorElement.class))) == null)) {
                        XmlWrongClosingTagNameInspection.registerProblemStart(holder, tag, start, endTagName);
                    }
                } else if (endTagName == psiElement && !(tag instanceof HtmlTag) && !tag.getName().equals(endTagName.getText())) {
                    XmlWrongClosingTagNameInspection.registerProblemEnd(holder, tag, endTagName);
                }
            } else if (parent instanceof PsiErrorElement && XmlTokenType.XML_NAME == ((XmlToken)psiElement).getTokenType() && (psiFile = psiElement.getContainingFile()) != null && (HTMLLanguage.INSTANCE == psiFile.getViewProvider().getBaseLanguage() || HTMLLanguage.INSTANCE == parent.getLanguage()) && (message = XmlErrorMessages.message("xml.parsing.closing.tag.matches.nothing", new Object[0])).equals(((PsiErrorElement)parent).getErrorDescription()) && psiFile.getContext() == null) {
                Annotation annotation = holder.createWarningAnnotation(parent, message);
                annotation.registerFix(new RemoveExtraClosingTagIntentionAction());
            }
        }
    }

    private static void registerProblemStart(@NotNull AnnotationHolder holder, @NotNull XmlTag tag, @NotNull XmlToken start, @NotNull XmlToken end) {
        ASTNode contextNode;
        ParserDefinition parserDefinition;
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/htmlInspections/XmlWrongClosingTagNameInspection", "registerProblemStart"));
        }
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/codeInspection/htmlInspections/XmlWrongClosingTagNameInspection", "registerProblemStart"));
        }
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/intellij/codeInspection/htmlInspections/XmlWrongClosingTagNameInspection", "registerProblemStart"));
        }
        if (end == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "end", "com/intellij/codeInspection/htmlInspections/XmlWrongClosingTagNameInspection", "registerProblemStart"));
        }
        PsiElement context = tag.getContainingFile().getContext();
        if (context != null && (parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(context.getLanguage())) != null && (contextNode = context.getNode()) != null && contextNode.getChildren(parserDefinition.getStringLiteralElements()) != null) {
            return;
        }
        String tagName = tag.getName();
        String endTokenText = end.getText();
        RenameTagBeginOrEndIntentionAction renameEndAction = new RenameTagBeginOrEndIntentionAction(tagName, endTokenText, false);
        RenameTagBeginOrEndIntentionAction renameStartAction = new RenameTagBeginOrEndIntentionAction(endTokenText, tagName, true);
        Annotation annotation = holder.createErrorAnnotation(start, XmlErrorMessages.message("tag.has.wrong.closing.tag.name", new Object[0]));
        annotation.registerFix(renameEndAction);
        annotation.registerFix(renameStartAction);
    }

    private static void registerProblemEnd(@NotNull AnnotationHolder holder, @NotNull XmlTag tag, @NotNull XmlToken end) {
        ASTNode contextNode;
        ParserDefinition parserDefinition;
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/htmlInspections/XmlWrongClosingTagNameInspection", "registerProblemEnd"));
        }
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/codeInspection/htmlInspections/XmlWrongClosingTagNameInspection", "registerProblemEnd"));
        }
        if (end == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "end", "com/intellij/codeInspection/htmlInspections/XmlWrongClosingTagNameInspection", "registerProblemEnd"));
        }
        PsiElement context = tag.getContainingFile().getContext();
        if (context != null && (parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(context.getLanguage())) != null && (contextNode = context.getNode()) != null && contextNode.getChildren(parserDefinition.getStringLiteralElements()) != null) {
            return;
        }
        String tagName = tag.getName();
        String endTokenText = end.getText();
        RenameTagBeginOrEndIntentionAction renameEndAction = new RenameTagBeginOrEndIntentionAction(tagName, endTokenText, false);
        RenameTagBeginOrEndIntentionAction renameStartAction = new RenameTagBeginOrEndIntentionAction(endTokenText, tagName, true);
        Annotation annotation = holder.createErrorAnnotation(end, XmlErrorMessages.message("wrong.closing.tag.name", new Object[0]));
        annotation.registerFix(new RemoveExtraClosingTagIntentionAction());
        annotation.registerFix(renameEndAction);
        annotation.registerFix(renameStartAction);
    }

    @Nullable
    static XmlToken findEndTagName(@Nullable PsiErrorElement element) {
        ASTNode current;
        if (element == null) {
            return null;
        }
        ASTNode astNode = element.getNode();
        if (astNode == null) {
            return null;
        }
        ASTNode prev = current = astNode.getLastChildNode();
        while (current != null) {
            IElementType elementType = prev.getElementType();
            if ((elementType == XmlTokenType.XML_NAME || elementType == XmlTokenType.XML_TAG_NAME) && current.getElementType() == XmlTokenType.XML_END_TAG_START) {
                return (XmlToken)prev.getPsi();
            }
            prev = current;
            current = current.getTreePrev();
        }
        return null;
    }
}

