/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ex.ProjectRoot;
import com.intellij.openapi.projectRoots.impl.CompositeProjectRoot;
import com.intellij.openapi.projectRoots.impl.SimpleProjectRoot;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.file.impl.FileManager;
import java.util.ArrayList;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ProjectRootUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.projectRoots.impl.ProjectRootUtil");
    @NonNls
    private static final String SIMPLE_ROOT = "simple";
    @NonNls
    private static final String COMPOSITE_ROOT = "composite";
    @NonNls
    public static final String JDK_ROOT = "jdk";
    @NonNls
    public static final String OUTPUT_ROOT = "output";
    @NonNls
    public static final String EXCLUDED_OUTPUT = "excludedOutput";
    @NonNls
    public static final String LIBRARY_ROOT = "library";
    @NonNls
    public static final String EJB_ROOT = "ejb";
    @NonNls
    private static final String ATTRIBUTE_TYPE = "type";
    @NonNls
    private static final String ELEMENT_ROOT = "root";

    private ProjectRootUtil() {
    }

    @NotNull
    static ProjectRoot read(Element element) {
        String type = element.getAttributeValue(ATTRIBUTE_TYPE);
        if (type.equals(SIMPLE_ROOT)) {
            SimpleProjectRoot simpleProjectRoot = new SimpleProjectRoot(element);
            if (simpleProjectRoot == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/ProjectRootUtil", "read"));
            }
            return simpleProjectRoot;
        }
        if (type.equals(COMPOSITE_ROOT)) {
            CompositeProjectRoot root = new CompositeProjectRoot();
            root.readExternal(element);
            CompositeProjectRoot compositeProjectRoot = root;
            if (compositeProjectRoot == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/ProjectRootUtil", "read"));
            }
            return compositeProjectRoot;
        }
        throw new IllegalArgumentException("Wrong type: " + type);
    }

    @NotNull
    static Element write(ProjectRoot projectRoot) {
        Element element = new Element(ELEMENT_ROOT);
        if (projectRoot instanceof SimpleProjectRoot) {
            element.setAttribute(ATTRIBUTE_TYPE, SIMPLE_ROOT);
            ((SimpleProjectRoot)projectRoot).writeExternal(element);
        } else if (projectRoot instanceof CompositeProjectRoot) {
            element.setAttribute(ATTRIBUTE_TYPE, COMPOSITE_ROOT);
            ((CompositeProjectRoot)projectRoot).writeExternal(element);
        } else {
            throw new IllegalArgumentException("Wrong root: " + projectRoot);
        }
        Element element2 = element;
        if (element2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/ProjectRootUtil", "write"));
        }
        return element2;
    }

    @NotNull
    private static PsiDirectory[] convertRoots(Project project, VirtualFile[] roots) {
        PsiDirectory[] psiDirectoryArray = ProjectRootUtil.convertRoots(((PsiManagerImpl)PsiManager.getInstance(project)).getFileManager(), roots);
        if (psiDirectoryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/ProjectRootUtil", "convertRoots"));
        }
        return psiDirectoryArray;
    }

    @NotNull
    private static PsiDirectory[] convertRoots(FileManager fileManager, VirtualFile[] roots) {
        ArrayList<PsiDirectory> dirs = new ArrayList<PsiDirectory>();
        for (VirtualFile root : roots) {
            PsiDirectory dir;
            if (!root.isValid()) {
                LOG.error("Root " + root + " is not valid!");
            }
            if ((dir = fileManager.findDirectory(root)) == null) continue;
            dirs.add(dir);
        }
        PsiDirectory[] psiDirectoryArray = dirs.toArray(new PsiDirectory[dirs.size()]);
        if (psiDirectoryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/ProjectRootUtil", "convertRoots"));
        }
        return psiDirectoryArray;
    }

    @NotNull
    public static PsiDirectory[] getSourceRootDirectories(Project project) {
        VirtualFile[] files = OrderEnumerator.orderEntries(project).sources().usingCache().getRoots();
        PsiDirectory[] psiDirectoryArray = ProjectRootUtil.convertRoots(project, files);
        if (psiDirectoryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/ProjectRootUtil", "getSourceRootDirectories"));
        }
        return psiDirectoryArray;
    }

    @NotNull
    public static PsiDirectory[] getAllContentRoots(Project project) {
        VirtualFile[] files = ProjectRootManager.getInstance(project).getContentRootsFromAllModules();
        PsiDirectory[] psiDirectoryArray = ProjectRootUtil.convertRoots(project, files);
        if (psiDirectoryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/ProjectRootUtil", "getAllContentRoots"));
        }
        return psiDirectoryArray;
    }
}

