/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class NestedSynchronizedStatementInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("nested.synchronized.statement.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/NestedSynchronizedStatementInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("nested.synchronized.statement.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/NestedSynchronizedStatementInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NestedSynchronizedStatementVisitor();
    }

    public static <T extends PsiStatement> boolean isNestedStatement(@NotNull T statement, @NotNull Class<T> aClass) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/threading/NestedSynchronizedStatementInspection", "isNestedStatement"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/threading/NestedSynchronizedStatementInspection", "isNestedStatement"));
        }
        return PsiTreeUtil.getParentOfType(statement, aClass, true, PsiClass.class, PsiLambdaExpression.class) != null;
    }

    private static class NestedSynchronizedStatementVisitor
    extends BaseInspectionVisitor {
        private NestedSynchronizedStatementVisitor() {
        }

        @Override
        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/threading/NestedSynchronizedStatementInspection$NestedSynchronizedStatementVisitor", "visitSynchronizedStatement"));
            }
            super.visitSynchronizedStatement(statement);
            if (NestedSynchronizedStatementInspection.isNestedStatement(statement, PsiSynchronizedStatement.class)) {
                this.registerStatementError(statement, new Object[0]);
            }
        }
    }
}

