/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.Component;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.Result;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

final class Pending
implements Result {
    @NotNull
    final Component[] delta;

    Pending(Collection<Component> delta) {
        this(delta.toArray(Component.EMPTY_ARRAY));
    }

    Pending(@NotNull Component[] delta) {
        if (delta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delta", "com/intellij/codeInspection/bytecodeAnalysis/Pending", "<init>"));
        }
        this.delta = delta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Arrays.equals(this.delta, ((Pending)o).delta);
    }

    public int hashCode() {
        return Arrays.hashCode(this.delta);
    }

    @NotNull
    Pending copy() {
        Component[] copy = new Component[this.delta.length];
        for (int i2 = 0; i2 < this.delta.length; ++i2) {
            copy[i2] = this.delta[i2].copy();
        }
        Pending pending = new Pending(copy);
        if (pending == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/Pending", "copy"));
        }
        return pending;
    }

    @Override
    public Stream<EKey> dependencies() {
        return Arrays.stream(this.delta).flatMap(component -> Stream.of(component.ids));
    }

    public String toString() {
        return "Pending[" + this.delta.length + "]";
    }
}

