/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.fix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.refactoring.extractMethod.ExtractMethodUtil;
import org.jetbrains.annotations.NotNull;

public class ReplaceWithConstantValueFix
implements LocalQuickFix {
    private final String myPresentableName;
    private final String myReplacementText;

    public ReplaceWithConstantValueFix(String presentableName, String replacementText) {
        this.myPresentableName = presentableName;
        this.myReplacementText = replacementText;
    }

    @Override
    @NotNull
    public String getName() {
        String string = "Replace with '" + this.myPresentableName + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/fix/ReplaceWithConstantValueFix", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        if ("Replace with constant value" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/fix/ReplaceWithConstantValueFix", "getFamilyName"));
        }
        return "Replace with constant value";
    }

    @Override
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/dataFlow/fix/ReplaceWithConstantValueFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/dataFlow/fix/ReplaceWithConstantValueFix", "applyFix"));
        }
        PsiElement problemElement = descriptor.getPsiElement();
        if (problemElement == null) {
            return;
        }
        PsiCall call = problemElement.getParent() instanceof PsiExpressionList && problemElement.getParent().getParent() instanceof PsiMethodCallExpression ? (PsiMethodCallExpression)problemElement.getParent().getParent() : null;
        PsiMethod targetMethod = call == null ? null : call.resolveMethod();
        JavaPsiFacade facade = JavaPsiFacade.getInstance(project);
        problemElement.replace(facade.getElementFactory().createExpressionFromText(this.myReplacementText, null));
        if (targetMethod != null) {
            ExtractMethodUtil.addCastsToEnsureResolveTarget(targetMethod, (PsiMethodCallExpression)call);
        }
    }
}

