/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl;

import com.intellij.application.options.PathMacrosCollector;
import com.intellij.application.options.PathMacrosImpl;
import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.CompositePathMacroFilter;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.TrackingPathMacroSubstitutorImpl;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.PathMacroUtil;

public class BasePathMacroManager
extends PathMacroManager {
    private PathMacrosImpl myPathMacros;

    public BasePathMacroManager(@Nullable PathMacros pathMacros) {
        this.myPathMacros = (PathMacrosImpl)pathMacros;
    }

    protected static void addFileHierarchyReplacements(@NotNull ExpandMacroToPathMap result, @NotNull String macroName, @Nullable String path) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/components/impl/BasePathMacroManager", "addFileHierarchyReplacements"));
        }
        if (macroName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "macroName", "com/intellij/openapi/components/impl/BasePathMacroManager", "addFileHierarchyReplacements"));
        }
        if (path != null) {
            BasePathMacroManager.addFileHierarchyReplacements(result, BasePathMacroManager.getLocalFileSystem().findFileByPath(path), '$' + macroName + '$');
        }
    }

    private static void addFileHierarchyReplacements(@NotNull ExpandMacroToPathMap result, @Nullable VirtualFile f, @NotNull String macro) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/components/impl/BasePathMacroManager", "addFileHierarchyReplacements"));
        }
        if (macro == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "macro", "com/intellij/openapi/components/impl/BasePathMacroManager", "addFileHierarchyReplacements"));
        }
        if (f == null) {
            return;
        }
        BasePathMacroManager.addFileHierarchyReplacements(result, f.getParent(), macro + "/..");
        result.put(macro, StringUtil.trimEnd(f.getPath(), "/"));
    }

    protected static void addFileHierarchyReplacements(ReplacePathToMacroMap result, String macroName, @Nullable String path, @Nullable String stopAt) {
        if (path == null) {
            return;
        }
        String macro = '$' + macroName + '$';
        path = StringUtil.trimEnd(FileUtil.toSystemIndependentName(path), "/");
        boolean overwrite = true;
        while (StringUtil.isNotEmpty(path) && path.contains("/")) {
            result.addReplacement(path, macro, overwrite);
            if (path.equals(stopAt)) break;
            macro = macro + "/..";
            overwrite = false;
            path = StringUtil.getPackageName(path, '/');
        }
    }

    @NotNull
    private static VirtualFileSystem getLocalFileSystem() {
        VirtualFileSystem virtualFileSystem = VirtualFileManager.getInstance().getFileSystem("file");
        if (virtualFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/BasePathMacroManager", "getLocalFileSystem"));
        }
        return virtualFileSystem;
    }

    @NotNull
    public ExpandMacroToPathMap getExpandMacroMap() {
        ExpandMacroToPathMap result = new ExpandMacroToPathMap();
        this.getPathMacros().addMacroExpands(result);
        for (Map.Entry<String, String> entry : PathMacroUtil.getGlobalSystemMacros().entrySet()) {
            result.addMacroExpand(entry.getKey(), entry.getValue());
        }
        ExpandMacroToPathMap expandMacroToPathMap = result;
        if (expandMacroToPathMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/BasePathMacroManager", "getExpandMacroMap"));
        }
        return expandMacroToPathMap;
    }

    @NotNull
    protected ReplacePathToMacroMap getReplacePathMap() {
        ReplacePathToMacroMap result = new ReplacePathToMacroMap();
        this.getPathMacros().addMacroReplacements(result);
        for (Map.Entry<String, String> entry : PathMacroUtil.getGlobalSystemMacros().entrySet()) {
            result.addMacroReplacement(entry.getValue(), entry.getKey());
        }
        ReplacePathToMacroMap replacePathToMacroMap = result;
        if (replacePathToMacroMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/BasePathMacroManager", "getReplacePathMap"));
        }
        return replacePathToMacroMap;
    }

    @Override
    @NotNull
    public TrackingPathMacroSubstitutor createTrackingSubstitutor() {
        TrackingPathMacroSubstitutorImpl trackingPathMacroSubstitutorImpl = new TrackingPathMacroSubstitutorImpl(this);
        if (trackingPathMacroSubstitutorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/BasePathMacroManager", "createTrackingSubstitutor"));
        }
        return trackingPathMacroSubstitutorImpl;
    }

    @Override
    @Contract(value="null -> null; !null -> !null")
    public String expandPath(@Nullable String text2) {
        if (StringUtil.isEmpty(text2)) {
            return text2;
        }
        return this.getExpandMacroMap().substitute(text2, SystemInfo.isFileSystemCaseSensitive);
    }

    @Override
    @Contract(value="null, _ -> null; !null, _ -> !null")
    public String collapsePath(@Nullable String text2, boolean recursively) {
        if (StringUtil.isEmpty(text2)) {
            return text2;
        }
        return this.getReplacePathMap().substitute(text2, SystemInfo.isFileSystemCaseSensitive, recursively);
    }

    @Override
    public void expandPaths(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/impl/BasePathMacroManager", "expandPaths"));
        }
        this.getExpandMacroMap().substitute(element, SystemInfo.isFileSystemCaseSensitive);
    }

    @Override
    public void collapsePaths(@NotNull Element element, boolean recursively) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/impl/BasePathMacroManager", "collapsePaths"));
        }
        this.getReplacePathMap().substitute(element, SystemInfo.isFileSystemCaseSensitive, recursively, Holder.FILTER);
    }

    @NotNull
    private PathMacrosImpl getPathMacros() {
        if (this.myPathMacros == null) {
            this.myPathMacros = PathMacrosImpl.getInstanceEx();
        }
        PathMacrosImpl pathMacrosImpl = this.myPathMacros;
        if (pathMacrosImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/BasePathMacroManager", "getPathMacros"));
        }
        return pathMacrosImpl;
    }

    protected static boolean pathsEqual(@Nullable String path1, @Nullable String path2) {
        return path1 != null && path2 != null && FileUtil.pathsEqual(FileUtil.toSystemIndependentName(path1), FileUtil.toSystemIndependentName(path2));
    }

    private static class Holder {
        private static final CompositePathMacroFilter FILTER = new CompositePathMacroFilter(Extensions.getExtensions(PathMacrosCollector.MACRO_FILTER_EXTENSION_POINT_NAME));

        private Holder() {
        }
    }
}

