/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileTypeRegistry {
    public static Getter<FileTypeRegistry> ourInstanceGetter;

    public abstract boolean isFileIgnored(@NotNull VirtualFile var1);

    public static FileTypeRegistry getInstance() {
        return ourInstanceGetter.get();
    }

    @NotNull
    public abstract FileType[] getRegisteredFileTypes();

    @NotNull
    public abstract FileType getFileTypeByFile(@NotNull VirtualFile var1);

    @NotNull
    public FileType getFileTypeByFileName(@NotNull @NonNls CharSequence fileNameSeq) {
        if (fileNameSeq == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNameSeq", "com/intellij/openapi/fileTypes/FileTypeRegistry", "getFileTypeByFileName"));
        }
        FileType fileType = this.getFileTypeByFileName(fileNameSeq.toString());
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/FileTypeRegistry", "getFileTypeByFileName"));
        }
        return fileType;
    }

    @NotNull
    public abstract FileType getFileTypeByFileName(@NotNull @NonNls String var1);

    @NotNull
    public abstract FileType getFileTypeByExtension(@NonNls @NotNull String var1);

    @Deprecated
    @NotNull
    public abstract FileType detectFileTypeFromContent(@NotNull VirtualFile var1);

    @Nullable
    public abstract FileType findFileTypeByName(@NotNull String var1);

    public static interface FileTypeDetector {
        public static final ExtensionPointName<FileTypeDetector> EP_NAME = ExtensionPointName.create("com.intellij.fileTypeDetector");

        @Nullable
        public FileType detect(@NotNull VirtualFile var1, @NotNull ByteSequence var2, @Nullable CharSequence var3);

        public int getVersion();
    }
}

