/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.ArrayUtilRt;

public class Base64 {
    private Base64() {
    }

    public static String encode(byte[] bytes) {
        return Base64.encode(bytes, 0, bytes.length);
    }

    public static String encode(byte[] bytes, int offset, int length) {
        if (length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i2 = offset; i2 < length; i2 += 3) {
            builder.append(Base64.encodeBlock(bytes, i2));
        }
        return builder.toString();
    }

    private static char[] encodeBlock(byte[] bytes, int offset) {
        int j = 0;
        int s = bytes.length - offset - 1;
        int l = s < 2 ? s : 2;
        for (int i2 = 0; i2 <= l; ++i2) {
            int b = bytes[offset + i2];
            int n = b >= 0 ? b : b + 256;
            j += n << 8 * (2 - i2);
        }
        char[] ac = new char[4];
        for (int k = 0; k < 4; ++k) {
            int l1 = j >>> 6 * (3 - k) & 0x3F;
            ac[k] = Base64.getChar(l1);
        }
        if (s < 1) {
            ac[2] = 61;
        }
        if (s < 2) {
            ac[3] = 61;
        }
        return ac;
    }

    private static char getChar(int i2) {
        if (i2 >= 0 && i2 <= 25) {
            return (char)(65 + i2);
        }
        if (i2 >= 26 && i2 <= 51) {
            return (char)(97 + (i2 - 26));
        }
        if (i2 >= 52 && i2 <= 61) {
            return (char)(48 + (i2 - 52));
        }
        if (i2 == 62) {
            return '+';
        }
        return i2 != 63 ? (char)'?' : '/';
    }

    public static byte[] decode(String s) {
        if (s.length() == 0) {
            return ArrayUtilRt.EMPTY_BYTE_ARRAY;
        }
        int i2 = 0;
        for (int j = s.length() - 1; j > 0 && s.charAt(j) == '='; --j) {
            ++i2;
        }
        int len = s.length() * 6 / 8 - i2;
        byte[] raw = new byte[len];
        int l = 0;
        for (int i1 = 0; i1 < s.length(); i1 += 4) {
            int n = s.length() - i1;
            if (n == 1) {
                throw new IllegalArgumentException("Invalid Base64 string");
            }
            int j1 = (Base64.getValue(s.charAt(i1)) << 18) + (Base64.getValue(s.charAt(i1 + 1)) << 12) + (n > 2 ? Base64.getValue(s.charAt(i1 + 2)) << 6 : 0) + (n > 3 ? Base64.getValue(s.charAt(i1 + 3)) : 0);
            for (int k = 0; k < 3 && l + k < raw.length; ++k) {
                raw[l + k] = (byte)(j1 >> 8 * (2 - k) & 0xFF);
            }
            l += 3;
        }
        return raw;
    }

    private static int getValue(char c) {
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 26;
        }
        if (c >= '0' && c <= '9') {
            return c - 48 + 52;
        }
        if (c == '+') {
            return 62;
        }
        if (c == '/') {
            return 63;
        }
        return c != '=' ? -1 : 0;
    }
}

