/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.codeInsight.daemon.impl.actions.SuppressFix;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressAllForClassFix
extends SuppressFix {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.daemon.impl.actions.AddNoInspectionAllForClassFix");

    public SuppressAllForClassFix() {
        super("ALL");
    }

    @Override
    @Nullable
    public PsiJavaDocumentedElement getContainer(PsiElement element) {
        PsiJavaDocumentedElement container = super.getContainer(element);
        if (container == null) {
            return null;
        }
        while (container != null) {
            PsiClass parentClass = PsiTreeUtil.getParentOfType((PsiElement)container, PsiClass.class);
            if (parentClass == null && container instanceof PsiClass) {
                return container;
            }
            container = parentClass;
        }
        return null;
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/actions/SuppressAllForClassFix", "getText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = InspectionsBundle.message("suppress.all.for.class", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/actions/SuppressAllForClassFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/actions/SuppressAllForClassFix", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/actions/SuppressAllForClassFix", "invoke"));
        }
        PsiJavaDocumentedElement container = this.getContainer(element);
        LOG.assertTrue(container != null);
        if (container instanceof PsiModifierListOwner && this.use15Suppressions(container)) {
            PsiAnnotation annotation;
            PsiModifierList modifierList = ((PsiModifierListOwner)((Object)container)).getModifierList();
            if (modifierList != null && (annotation = modifierList.findAnnotation("java.lang.SuppressWarnings")) != null) {
                String annoText = "@java.lang.SuppressWarnings(\"ALL\")";
                Runnable runnable = () -> {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/actions/SuppressAllForClassFix", "lambda$invoke$0"));
                    }
                    annotation.replace(JavaPsiFacade.getElementFactory(project).createAnnotationFromText(annoText, container));
                };
                WriteCommandAction.runWriteCommandAction(project, null, null, runnable, annotation.getContainingFile());
                return;
            }
        } else {
            PsiDocTag noInspectionTag;
            PsiDocComment docComment = container.getDocComment();
            if (docComment != null && (noInspectionTag = docComment.findTagByName("noinspection")) != null) {
                String tagText = "@noinspection ALL";
                Runnable runnable = () -> {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/actions/SuppressAllForClassFix", "lambda$invoke$1"));
                    }
                    noInspectionTag.replace(JavaPsiFacade.getElementFactory(project).createDocTagFromText(tagText));
                };
                WriteCommandAction.runWriteCommandAction(project, null, null, runnable, noInspectionTag.getContainingFile());
                return;
            }
        }
        super.invoke(project, element);
    }
}

