/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.Domination;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.NameHint;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;

public class StaticImportResolveProcessor
extends BaseScopeProcessor
implements NameHint {
    private final PsiImportStaticReferenceElement myReference;
    private final String myName;
    private final List<JavaResolveResult> myFieldResults;
    private final List<JavaResolveResult> myClassResult;
    private final List<JavaResolveResult> myResults;

    public StaticImportResolveProcessor(@NotNull PsiImportStaticReferenceElement reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/psi/impl/source/resolve/StaticImportResolveProcessor", "<init>"));
        }
        this.myFieldResults = new SmartList<JavaResolveResult>();
        this.myClassResult = new SmartList<JavaResolveResult>();
        this.myResults = new SmartList<JavaResolveResult>();
        this.myReference = reference;
        this.myName = this.myReference.getReferenceName();
    }

    @Override
    public boolean execute(@NotNull PsiElement candidate, @NotNull ResolveState state) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/psi/impl/source/resolve/StaticImportResolveProcessor", "execute"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/source/resolve/StaticImportResolveProcessor", "execute"));
        }
        if (candidate instanceof PsiMember && ((PsiModifierListOwner)candidate).hasModifierProperty("static")) {
            if (candidate instanceof PsiField) {
                if (StaticImportResolveProcessor.checkDomination((PsiMember)candidate, this.myFieldResults)) {
                    return true;
                }
                this.myFieldResults.add(new OurResolveResult(candidate, this.myReference));
            } else if (candidate instanceof PsiClass) {
                if (StaticImportResolveProcessor.checkDomination((PsiMember)candidate, this.myClassResult)) {
                    return true;
                }
                this.myClassResult.add(new OurResolveResult(candidate, this.myReference));
            } else {
                this.myResults.add(new OurResolveResult(candidate, this.myReference));
            }
        }
        return true;
    }

    private static boolean checkDomination(PsiMember candidate, List<JavaResolveResult> results) {
        if (!results.isEmpty()) {
            ListIterator<JavaResolveResult> i2 = results.listIterator(results.size());
            while (i2.hasPrevious()) {
                Domination domination = StaticImportResolveProcessor.dominates(candidate, (PsiMember)i2.previous().getElement());
                if (domination == Domination.DOMINATED_BY) {
                    return true;
                }
                if (domination != Domination.DOMINATES) continue;
                i2.remove();
            }
        }
        return false;
    }

    private static Domination dominates(PsiMember member1, PsiMember member2) {
        PsiClass class1 = member1.getContainingClass();
        PsiClass class2 = member2.getContainingClass();
        if (class1 != null && class2 != null) {
            if (class1.isInheritor(class2, true)) {
                return Domination.DOMINATES;
            }
            if (class2.isInheritor(class1, true)) {
                return Domination.DOMINATED_BY;
            }
        }
        return Domination.EQUAL;
    }

    @Override
    public String getName(@NotNull ResolveState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/source/resolve/StaticImportResolveProcessor", "getName"));
        }
        return this.myName;
    }

    @Override
    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "com/intellij/psi/impl/source/resolve/StaticImportResolveProcessor", "getHint"));
        }
        if (hintKey == NameHint.KEY) {
            return (T)this;
        }
        return super.getHint(hintKey);
    }

    @NotNull
    public JavaResolveResult[] getResults() {
        if (this.myResults.size() + this.myFieldResults.size() + this.myClassResult.size() > 1) {
            StaticImportResolveProcessor.filterInvalid(this.myResults);
            StaticImportResolveProcessor.filterInvalid(this.myFieldResults);
            StaticImportResolveProcessor.filterInvalid(this.myClassResult);
        }
        if (!this.myFieldResults.isEmpty()) {
            this.myResults.addAll(this.myFieldResults);
        }
        if (!this.myClassResult.isEmpty()) {
            this.myResults.addAll(this.myClassResult);
        }
        JavaResolveResult[] javaResolveResultArray = this.myResults.toArray(new JavaResolveResult[this.myResults.size()]);
        if (javaResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/StaticImportResolveProcessor", "getResults"));
        }
        return javaResolveResultArray;
    }

    private static void filterInvalid(List<JavaResolveResult> resultList) {
        if (resultList.isEmpty()) {
            return;
        }
        ListIterator<JavaResolveResult> i2 = resultList.listIterator(resultList.size());
        while (i2.hasPrevious()) {
            if (i2.previous().isValidResult()) continue;
            i2.remove();
        }
    }

    private static class OurResolveResult
    extends CandidateInfo {
        private final PsiImportStaticReferenceElement myReference;

        public OurResolveResult(@NotNull PsiElement candidate, PsiImportStaticReferenceElement reference) {
            if (candidate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/psi/impl/source/resolve/StaticImportResolveProcessor$OurResolveResult", "<init>"));
            }
            super(candidate, PsiSubstitutor.EMPTY);
            this.myReference = reference;
        }

        @Override
        public boolean isAccessible() {
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance(this.myReference.getProject()).getResolveHelper();
            PsiElement element = this.getElement();
            return element instanceof PsiMember && resolveHelper.isAccessible((PsiMember)element, this.myReference, null);
        }

        @Override
        public boolean isStaticsScopeCorrect() {
            return true;
        }
    }
}

